/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunning;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunning SupplierDunning}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.field.SupplierDunningField
 * SupplierDunningField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.link.SupplierDunningLink
 * SupplierDunningLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunning#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunning#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunning#DUNNING_AREA
 * DUNNING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunning#DUNNING_BLOCK
 * DUNNING_BLOCK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunning#DUNNING_LEVEL
 * DUNNING_LEVEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunning#DUNNING_PROCEDURE
 * DUNNING_PROCEDURE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunning#DUNNING_RECIPIENT
 * DUNNING_RECIPIENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunning#LAST_DUNNED_ON
 * LAST_DUNNED_ON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunning#LEG_DUNNING_PROCEDURE_ON
 * LEG_DUNNING_PROCEDURE_ON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunning#DUNNING_CLERK
 * DUNNING_CLERK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunning#AUTHORIZATION_GROUP
 * AUTHORIZATION_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunning#SUPPLIER_ACCOUNT_GROUP
 * SUPPLIER_ACCOUNT_GROUP}</li>
 * </ul>
 *
 */
public interface SupplierDunningSelectable extends EntitySelectable<SupplierDunning>
{

}
