/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier Supplier}. This interface is used
 * by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.field.SupplierField SupplierField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.link.SupplierLink SupplierLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier#SUPPLIER SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier#ALTERNATIVE_PAYEE_ACCOUNT_NUMBER
 * ALTERNATIVE_PAYEE_ACCOUNT_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier#AUTHORIZATION_GROUP
 * AUTHORIZATION_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier#CUSTOMER CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier#PAYMENT_IS_BLOCKED_FOR_SUPPLIER
 * PAYMENT_IS_BLOCKED_FOR_SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier#POSTING_IS_BLOCKED
 * POSTING_IS_BLOCKED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier#PURCHASING_IS_BLOCKED
 * PURCHASING_IS_BLOCKED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier#SUPPLIER_ACCOUNT_GROUP
 * SUPPLIER_ACCOUNT_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier#SUPPLIER_FULL_NAME
 * SUPPLIER_FULL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier#SUPPLIER_NAME
 * SUPPLIER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier#VAT_REGISTRATION
 * VAT_REGISTRATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier#BIRTH_DATE BIRTH_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier#CONCATENATED_INTERNATIONAL_LOC_NO
 * CONCATENATED_INTERNATIONAL_LOC_NO}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier#DELETION_INDICATOR
 * DELETION_INDICATOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier#FISCAL_ADDRESS
 * FISCAL_ADDRESS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier#INDUSTRY INDUSTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier#INTERNATIONAL_LOCATION_NUMBER1
 * INTERNATIONAL_LOCATION_NUMBER1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier#INTERNATIONAL_LOCATION_NUMBER2
 * INTERNATIONAL_LOCATION_NUMBER2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier#INTERNATIONAL_LOCATION_NUMBER3
 * INTERNATIONAL_LOCATION_NUMBER3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier#IS_NATURAL_PERSON
 * IS_NATURAL_PERSON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier#RESPONSIBLE_TYPE
 * RESPONSIBLE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier#SUPLR_QLTY_IN_PROCMT_CERTFN_VALID_TO
 * SUPLR_QLTY_IN_PROCMT_CERTFN_VALID_TO}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier#SUPLR_QUALITY_MANAGEMENT_SYSTEM
 * SUPLR_QUALITY_MANAGEMENT_SYSTEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier#SUPPLIER_CORPORATE_GROUP
 * SUPPLIER_CORPORATE_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier#SUPPLIER_PROCUREMENT_BLOCK
 * SUPPLIER_PROCUREMENT_BLOCK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier#TAX_NUMBER1 TAX_NUMBER1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier#TAX_NUMBER2 TAX_NUMBER2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier#TAX_NUMBER3 TAX_NUMBER3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier#TAX_NUMBER4 TAX_NUMBER4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier#TAX_NUMBER5 TAX_NUMBER5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier#TAX_NUMBER_RESPONSIBLE
 * TAX_NUMBER_RESPONSIBLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier#TAX_NUMBER_TYPE
 * TAX_NUMBER_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier#SUPLR_PROOF_OF_DELIV_RLVT_CODE
 * SUPLR_PROOF_OF_DELIV_RLVT_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier#BR_TAX_IS_SPLIT
 * BR_TAX_IS_SPLIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier#DATA_EXCHANGE_INSTRUCTION_KEY
 * DATA_EXCHANGE_INSTRUCTION_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier#TO_SUPPLIER_COMPANY
 * TO_SUPPLIER_COMPANY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier#TO_SUPPLIER_PURCHASING_ORG
 * TO_SUPPLIER_PURCHASING_ORG}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier#TO_SUPPLIER_TEXT
 * TO_SUPPLIER_TEXT}</li>
 * </ul>
 *
 */
public interface SupplierSelectable extends EntitySelectable<Supplier>
{

}
