/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTax;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTax
 * SupplierWithHoldingTax}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.field.SupplierWithHoldingTaxField
 * SupplierWithHoldingTaxField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.link.SupplierWithHoldingTaxLink
 * SupplierWithHoldingTaxLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTax#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTax#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTax#WITHHOLDING_TAX_TYPE
 * WITHHOLDING_TAX_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTax#EXEMPTION_DATE_BEGIN
 * EXEMPTION_DATE_BEGIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTax#EXEMPTION_DATE_END
 * EXEMPTION_DATE_END}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTax#EXEMPTION_REASON
 * EXEMPTION_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTax#IS_WITHHOLDING_TAX_SUBJECT
 * IS_WITHHOLDING_TAX_SUBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTax#RECIPIENT_TYPE
 * RECIPIENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTax#WITHHOLDING_TAX_CERTIFICATE
 * WITHHOLDING_TAX_CERTIFICATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTax#WITHHOLDING_TAX_CODE
 * WITHHOLDING_TAX_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTax#WITHHOLDING_TAX_EXMPT_PERCENT
 * WITHHOLDING_TAX_EXMPT_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTax#WITHHOLDING_TAX_NUMBER
 * WITHHOLDING_TAX_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTax#AUTHORIZATION_GROUP
 * AUTHORIZATION_GROUP}</li>
 * </ul>
 *
 */
public interface SupplierWithHoldingTaxSelectable extends EntitySelectable<SupplierWithHoldingTax>
{

}
