/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessplace;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessplace.field.BusinessPlaceField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessplace.link.BusinessPlaceLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessplace.selectable.BusinessPlaceSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Business Place Lists
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>BusinessPlace</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BusinessPlace extends VdmEntity<BusinessPlace>
{

    /**
     * Selector for all available fields of BusinessPlace.
     *
     */
    public final static BusinessPlaceSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @Key
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static BusinessPlaceField<String> COMPANY_CODE = new BusinessPlaceField<String>("CompanyCode");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPlaceID</b>
     * </p>
     *
     * @return Business Place
     */
    @Key
    @SerializedName( "BusinessPlaceID" )
    @JsonProperty( "BusinessPlaceID" )
    @Nullable
    @ODataField( odataName = "BusinessPlaceID" )
    private String businessPlaceID;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPlaceID</b> field to query operations.
     *
     */
    public final static BusinessPlaceField<String> BUSINESS_PLACE_ID =
        new BusinessPlaceField<String>("BusinessPlaceID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AddressID</b>
     * </p>
     *
     * @return Address
     */
    @SerializedName( "AddressID" )
    @JsonProperty( "AddressID" )
    @Nullable
    @ODataField( odataName = "AddressID" )
    private String addressID;
    /**
     * Use with available fluent helpers to apply the <b>AddressID</b> field to query operations.
     *
     */
    public final static BusinessPlaceField<String> ADDRESS_ID = new BusinessPlaceField<String>("AddressID");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>TaxNumber1</b>
     * </p>
     *
     * @return Tax Number 1
     */
    @SerializedName( "TaxNumber1" )
    @JsonProperty( "TaxNumber1" )
    @Nullable
    @ODataField( odataName = "TaxNumber1" )
    private String taxNumber1;
    /**
     * Use with available fluent helpers to apply the <b>TaxNumber1</b> field to query operations.
     *
     */
    public final static BusinessPlaceField<String> TAX_NUMBER1 = new BusinessPlaceField<String>("TaxNumber1");
    /**
     * Constraints: Not nullable, Maximum length: 11
     * <p>
     * Original property name from the Odata EDM: <b>TaxNumber2</b>
     * </p>
     *
     * @return Tax Number 2
     */
    @SerializedName( "TaxNumber2" )
    @JsonProperty( "TaxNumber2" )
    @Nullable
    @ODataField( odataName = "TaxNumber2" )
    private String taxNumber2;
    /**
     * Use with available fluent helpers to apply the <b>TaxNumber2</b> field to query operations.
     *
     */
    public final static BusinessPlaceField<String> TAX_NUMBER2 = new BusinessPlaceField<String>("TaxNumber2");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPlaceDescription</b>
     * </p>
     *
     * @return Name 1
     */
    @SerializedName( "BusinessPlaceDescription" )
    @JsonProperty( "BusinessPlaceDescription" )
    @Nullable
    @ODataField( odataName = "BusinessPlaceDescription" )
    private String businessPlaceDescription;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPlaceDescription</b> field to query operations.
     *
     */
    public final static BusinessPlaceField<String> BUSINESS_PLACE_DESCRIPTION =
        new BusinessPlaceField<String>("BusinessPlaceDescription");
    /**
     * Navigation property <b>BusinessPlaceCntryInfoSet</b> for <b>BusinessPlace</b> to multiple
     * <b>BusinessPlaceCntryInfo</b>.
     *
     */
    @SerializedName( "BusinessPlaceCntryInfoSet" )
    @JsonProperty( "BusinessPlaceCntryInfoSet" )
    @ODataField( odataName = "BusinessPlaceCntryInfoSet" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusinessPlaceCntryInfo> toBusinessPlaceCntryInfoSet;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPlaceCntryInfoSet</b> navigation property to query
     * operations.
     *
     */
    public final static BusinessPlaceLink<BusinessPlaceCntryInfo> TO_BUSINESS_PLACE_CNTRY_INFO_SET =
        new BusinessPlaceLink<BusinessPlaceCntryInfo>("BusinessPlaceCntryInfoSet");

    @Nonnull
    @Override
    public Class<BusinessPlace> getType()
    {
        return BusinessPlace.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPlaceID</b>
     * </p>
     *
     * @param businessPlaceID
     *            Business Place
     */
    public void setBusinessPlaceID( @Nullable final String businessPlaceID )
    {
        rememberChangedField("BusinessPlaceID", this.businessPlaceID);
        this.businessPlaceID = businessPlaceID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AddressID</b>
     * </p>
     *
     * @param addressID
     *            Address
     */
    public void setAddressID( @Nullable final String addressID )
    {
        rememberChangedField("AddressID", this.addressID);
        this.addressID = addressID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>TaxNumber1</b>
     * </p>
     *
     * @param taxNumber1
     *            Tax Number 1
     */
    public void setTaxNumber1( @Nullable final String taxNumber1 )
    {
        rememberChangedField("TaxNumber1", this.taxNumber1);
        this.taxNumber1 = taxNumber1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 11
     * <p>
     * Original property name from the Odata EDM: <b>TaxNumber2</b>
     * </p>
     *
     * @param taxNumber2
     *            Tax Number 2
     */
    public void setTaxNumber2( @Nullable final String taxNumber2 )
    {
        rememberChangedField("TaxNumber2", this.taxNumber2);
        this.taxNumber2 = taxNumber2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPlaceDescription</b>
     * </p>
     *
     * @param businessPlaceDescription
     *            Name 1
     */
    public void setBusinessPlaceDescription( @Nullable final String businessPlaceDescription )
    {
        rememberChangedField("BusinessPlaceDescription", this.businessPlaceDescription);
        this.businessPlaceDescription = businessPlaceDescription;
    }

    @Override
    protected String getEntityCollection()
    {
        return "BusinessPlaceSet";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CompanyCode", getCompanyCode());
        result.put("BusinessPlaceID", getBusinessPlaceID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CompanyCode", getCompanyCode());
        values.put("BusinessPlaceID", getBusinessPlaceID());
        values.put("AddressID", getAddressID());
        values.put("TaxNumber1", getTaxNumber1());
        values.put("TaxNumber2", getTaxNumber2());
        values.put("BusinessPlaceDescription", getBusinessPlaceDescription());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("BusinessPlaceID") ) {
                final Object value = values.remove("BusinessPlaceID");
                if( (value == null) || (!value.equals(getBusinessPlaceID())) ) {
                    setBusinessPlaceID(((String) value));
                }
            }
            if( values.containsKey("AddressID") ) {
                final Object value = values.remove("AddressID");
                if( (value == null) || (!value.equals(getAddressID())) ) {
                    setAddressID(((String) value));
                }
            }
            if( values.containsKey("TaxNumber1") ) {
                final Object value = values.remove("TaxNumber1");
                if( (value == null) || (!value.equals(getTaxNumber1())) ) {
                    setTaxNumber1(((String) value));
                }
            }
            if( values.containsKey("TaxNumber2") ) {
                final Object value = values.remove("TaxNumber2");
                if( (value == null) || (!value.equals(getTaxNumber2())) ) {
                    setTaxNumber2(((String) value));
                }
            }
            if( values.containsKey("BusinessPlaceDescription") ) {
                final Object value = values.remove("BusinessPlaceDescription");
                if( (value == null) || (!value.equals(getBusinessPlaceDescription())) ) {
                    setBusinessPlaceDescription(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("BusinessPlaceCntryInfoSet") ) {
                final Object value = (values).remove("BusinessPlaceCntryInfoSet");
                if( value instanceof Iterable ) {
                    if( toBusinessPlaceCntryInfoSet == null ) {
                        toBusinessPlaceCntryInfoSet = Lists.newArrayList();
                    } else {
                        toBusinessPlaceCntryInfoSet = Lists.newArrayList(toBusinessPlaceCntryInfoSet);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusinessPlaceCntryInfo entity;
                        if( toBusinessPlaceCntryInfoSet.size() > i ) {
                            entity = toBusinessPlaceCntryInfoSet.get(i);
                        } else {
                            entity = new BusinessPlaceCntryInfo();
                            toBusinessPlaceCntryInfoSet.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> BusinessPlaceField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BusinessPlaceField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BusinessPlaceField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BusinessPlaceField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessPlaceService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBusinessPlaceCntryInfoSet != null ) {
            (values).put("BusinessPlaceCntryInfoSet", toBusinessPlaceCntryInfoSet);
        }
        return values;
    }

    /**
     * Fetches the <b>BusinessPlaceCntryInfo</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>BusinessPlaceCntryInfoSet</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusinessPlaceCntryInfo</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusinessPlaceCntryInfo> fetchBusinessPlaceCntryInfoSet()
    {
        return fetchFieldAsList("BusinessPlaceCntryInfoSet", BusinessPlaceCntryInfo.class);
    }

    /**
     * Retrieval of associated <b>BusinessPlaceCntryInfo</b> entities (one to many). This corresponds to the OData
     * navigation property <b>BusinessPlaceCntryInfoSet</b>.
     * <p>
     * If the navigation property <b>BusinessPlaceCntryInfoSet</b> of a queried <b>BusinessPlace</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusinessPlaceCntryInfo</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusinessPlaceCntryInfo> getBusinessPlaceCntryInfoSetOrFetch()
    {
        if( toBusinessPlaceCntryInfoSet == null ) {
            toBusinessPlaceCntryInfoSet = fetchBusinessPlaceCntryInfoSet();
        }
        return toBusinessPlaceCntryInfoSet;
    }

    /**
     * Retrieval of associated <b>BusinessPlaceCntryInfo</b> entities (one to many). This corresponds to the OData
     * navigation property <b>BusinessPlaceCntryInfoSet</b>.
     * <p>
     * If the navigation property for an entity <b>BusinessPlace</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>BusinessPlaceCntryInfoSet</b> is already loaded, the result
     *         will contain the <b>BusinessPlaceCntryInfo</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusinessPlaceCntryInfo>> getBusinessPlaceCntryInfoSetIfPresent()
    {
        return Option.of(toBusinessPlaceCntryInfoSet);
    }

    /**
     * Overwrites the list of associated <b>BusinessPlaceCntryInfo</b> entities for the loaded navigation property
     * <b>BusinessPlaceCntryInfoSet</b>.
     * <p>
     * If the navigation property <b>BusinessPlaceCntryInfoSet</b> of a queried <b>BusinessPlace</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusinessPlaceCntryInfo</b> entities.
     */
    public void setBusinessPlaceCntryInfoSet( @Nonnull final List<BusinessPlaceCntryInfo> value )
    {
        if( toBusinessPlaceCntryInfoSet == null ) {
            toBusinessPlaceCntryInfoSet = Lists.newArrayList();
        }
        toBusinessPlaceCntryInfoSet.clear();
        toBusinessPlaceCntryInfoSet.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusinessPlaceCntryInfo</b> entities. This corresponds to the OData
     * navigation property <b>BusinessPlaceCntryInfoSet</b>.
     * <p>
     * If the navigation property <b>BusinessPlaceCntryInfoSet</b> of a queried <b>BusinessPlace</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusinessPlaceCntryInfo</b> entities.
     */
    public void addBusinessPlaceCntryInfoSet( BusinessPlaceCntryInfo... entity )
    {
        if( toBusinessPlaceCntryInfoSet == null ) {
            toBusinessPlaceCntryInfoSet = Lists.newArrayList();
        }
        toBusinessPlaceCntryInfoSet.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of BusinessPlace instances.
     *
     */
    public final static class BusinessPlaceBuilder
    {

        private List<BusinessPlaceCntryInfo> toBusinessPlaceCntryInfoSet = Lists.newArrayList();

        private BusinessPlace.BusinessPlaceBuilder toBusinessPlaceCntryInfoSet(
            final List<BusinessPlaceCntryInfo> value )
        {
            toBusinessPlaceCntryInfoSet.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>BusinessPlaceCntryInfoSet</b> for <b>BusinessPlace</b> to multiple
         * <b>BusinessPlaceCntryInfo</b>.
         *
         * @param value
         *            The BusinessPlaceCntryInfos to build this BusinessPlace with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusinessPlace.BusinessPlaceBuilder businessPlaceCntryInfoSet( BusinessPlaceCntryInfo... value )
        {
            return toBusinessPlaceCntryInfoSet(Lists.newArrayList(value));
        }

    }

}
