/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessplace;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmComplex;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original complex type name from the Odata EDM: <b>BusinessPlaceFieldProperties</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BusinessPlaceFieldProperties extends VdmComplex<BusinessPlaceFieldProperties>
{

    /**
     * Constraints: Not nullable
     * <p>
     * Original property from the Odata EDM: <b>Readonly</b>
     * </p>
     *
     * @param readonly
     *
     * @return Read Only
     */
    @SerializedName( "Readonly" )
    @JsonProperty( "Readonly" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Readonly" )
    private Boolean readonly;
    /**
     * Constraints: Not nullable
     * <p>
     * Original property from the Odata EDM: <b>Mandatory</b>
     * </p>
     *
     * @param mandatory
     *
     * @return Mandatory
     */
    @SerializedName( "Mandatory" )
    @JsonProperty( "Mandatory" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Mandatory" )
    private Boolean mandatory;
    /**
     * Constraints: Not nullable
     * <p>
     * Original property from the Odata EDM: <b>Enabled</b>
     * </p>
     *
     * @param enabled
     *
     * @return Enabled
     */
    @SerializedName( "Enabled" )
    @JsonProperty( "Enabled" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Enabled" )
    private Boolean enabled;

    @Nonnull
    @Override
    public Class<BusinessPlaceFieldProperties> getType()
    {
        return BusinessPlaceFieldProperties.class;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Readonly", getReadonly());
        values.put("Mandatory", getMandatory());
        values.put("Enabled", getEnabled());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Readonly") ) {
                final Object value = values.remove("Readonly");
                if( (value == null) || (!value.equals(getReadonly())) ) {
                    setReadonly(((Boolean) value));
                }
            }
            if( values.containsKey("Mandatory") ) {
                final Object value = values.remove("Mandatory");
                if( (value == null) || (!value.equals(getMandatory())) ) {
                    setMandatory(((Boolean) value));
                }
            }
            if( values.containsKey("Enabled") ) {
                final Object value = values.remove("Enabled");
                if( (value == null) || (!value.equals(getEnabled())) ) {
                    setEnabled(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        return result;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property from the Odata EDM: <b>Readonly</b>
     * </p>
     *
     * @param readonly
     *            Read Only
     */
    public void setReadonly( @Nullable final Boolean readonly )
    {
        rememberChangedField("Readonly", this.readonly);
        this.readonly = readonly;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property from the Odata EDM: <b>Mandatory</b>
     * </p>
     *
     * @param mandatory
     *            Mandatory
     */
    public void setMandatory( @Nullable final Boolean mandatory )
    {
        rememberChangedField("Mandatory", this.mandatory);
        this.mandatory = mandatory;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property from the Odata EDM: <b>Enabled</b>
     * </p>
     *
     * @param enabled
     *            Enabled
     */
    public void setEnabled( @Nullable final Boolean enabled )
    {
        rememberChangedField("Enabled", this.enabled);
        this.enabled = enabled;
    }

}
