/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessplace.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link BusinessPlaceServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessPlaceService BusinessPlaceService}, allowing you to
 * create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultBusinessPlaceServiceBatch
    extends
    BatchFluentHelperBasic<BusinessPlaceServiceBatch, BusinessPlaceServiceBatchChangeSet>
    implements
    BusinessPlaceServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessPlaceService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultBusinessPlaceServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultBusinessPlaceServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessPlaceService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessPlaceService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultBusinessPlaceServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultBusinessPlaceServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessPlaceService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultBusinessPlaceServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public BusinessPlaceServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultBusinessPlaceServiceBatchChangeSet(this, service);
    }

}
