/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessplace.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link BusinessPlaceServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessPlaceService BusinessPlaceService}.
 *
 */
public class DefaultBusinessPlaceServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<BusinessPlaceServiceBatch, BusinessPlaceServiceBatchChangeSet>
    implements
    BusinessPlaceServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessPlaceService service;

    @SuppressWarnings( "deprecation" )
    DefaultBusinessPlaceServiceBatchChangeSet(
        @Nonnull final DefaultBusinessPlaceServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessPlaceService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultBusinessPlaceServiceBatchChangeSet getThis()
    {
        return this;
    }

}
