/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessplace.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessplace.BusinessPlaceCntryInfo;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessplace.BusinessPlaceCntryInfo
 * BusinessPlaceCntryInfo}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessplace.field.BusinessPlaceCntryInfoField
 * BusinessPlaceCntryInfoField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessplace.link.BusinessPlaceCntryInfoLink
 * BusinessPlaceCntryInfoLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessplace.BusinessPlaceCntryInfo#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessplace.BusinessPlaceCntryInfo#BUSINESS_PLACE_ID
 * BUSINESS_PLACE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessplace.BusinessPlaceCntryInfo#COUNTRY
 * COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessplace.BusinessPlaceCntryInfo#FIELD_NAME
 * FIELD_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessplace.BusinessPlaceCntryInfo#FIELD_VALUE
 * FIELD_VALUE}</li>
 * </ul>
 *
 */
public interface BusinessPlaceCntryInfoSelectable extends EntitySelectable<BusinessPlaceCntryInfo>
{

}
