/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessplace.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessplace.BusinessPlace;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessplace.BusinessPlace BusinessPlace}. This interface
 * is used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessplace.field.BusinessPlaceField
 * BusinessPlaceField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessplace.link.BusinessPlaceLink BusinessPlaceLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessplace.BusinessPlace#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessplace.BusinessPlace#BUSINESS_PLACE_ID
 * BUSINESS_PLACE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessplace.BusinessPlace#ADDRESS_ID
 * ADDRESS_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessplace.BusinessPlace#TAX_NUMBER1
 * TAX_NUMBER1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessplace.BusinessPlace#TAX_NUMBER2
 * TAX_NUMBER2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessplace.BusinessPlace#BUSINESS_PLACE_DESCRIPTION
 * BUSINESS_PLACE_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessplace.BusinessPlace#TO_BUSINESS_PLACE_CNTRY_INFO_SET
 * TO_BUSINESS_PLACE_CNTRY_INFO_SET}</li>
 * </ul>
 *
 */
public interface BusinessPlaceSelectable extends EntitySelectable<BusinessPlace>
{

}
