/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessrolechanges;

import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessrolechanges.field.BusinessRoleChangesField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessrolechanges.selectable.BusinessRoleChangesSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Business Role Changes
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>BusinessRoleChangesType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BusinessRoleChanges extends VdmEntity<BusinessRoleChanges>
{

    /**
     * Selector for all available fields of BusinessRoleChanges.
     *
     */
    public final static BusinessRoleChangesSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusinessRoleID</b>
     * </p>
     *
     * @return Business Role ID
     */
    @Key
    @SerializedName( "BusinessRoleID" )
    @JsonProperty( "BusinessRoleID" )
    @Nullable
    @ODataField( odataName = "BusinessRoleID" )
    private String businessRoleID;
    /**
     * Use with available fluent helpers to apply the <b>BusinessRoleID</b> field to query operations.
     *
     */
    public final static BusinessRoleChangesField<String> BUSINESS_ROLE_ID =
        new BusinessRoleChangesField<String>("BusinessRoleID");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ChangedOn</b>
     * </p>
     *
     * @return Changed On
     */
    @Key
    @SerializedName( "ChangedOn" )
    @JsonProperty( "ChangedOn" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ChangedOn",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime changedOn;
    /**
     * Use with available fluent helpers to apply the <b>ChangedOn</b> field to query operations.
     *
     */
    public final static BusinessRoleChangesField<ZonedDateTime> CHANGED_ON =
        new BusinessRoleChangesField<ZonedDateTime>("ChangedOn");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ChangeCategory</b>
     * </p>
     *
     * @return Change Category
     */
    @Key
    @SerializedName( "ChangeCategory" )
    @JsonProperty( "ChangeCategory" )
    @Nullable
    @ODataField( odataName = "ChangeCategory" )
    private String changeCategory;
    /**
     * Use with available fluent helpers to apply the <b>ChangeCategory</b> field to query operations.
     *
     */
    public final static BusinessRoleChangesField<String> CHANGE_CATEGORY =
        new BusinessRoleChangesField<String>("ChangeCategory");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 256
     * <p>
     * Original property name from the Odata EDM: <b>Attribute</b>
     * </p>
     *
     * @return Attribute
     */
    @Key
    @SerializedName( "Attribute" )
    @JsonProperty( "Attribute" )
    @Nullable
    @ODataField( odataName = "Attribute" )
    private String attribute;
    /**
     * Use with available fluent helpers to apply the <b>Attribute</b> field to query operations.
     *
     */
    public final static BusinessRoleChangesField<String> ATTRIBUTE = new BusinessRoleChangesField<String>("Attribute");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 254
     * <p>
     * Original property name from the Odata EDM: <b>ValueChangedFrom</b>
     * </p>
     *
     * @return Value Changed From
     */
    @Key
    @SerializedName( "ValueChangedFrom" )
    @JsonProperty( "ValueChangedFrom" )
    @Nullable
    @ODataField( odataName = "ValueChangedFrom" )
    private String valueChangedFrom;
    /**
     * Use with available fluent helpers to apply the <b>ValueChangedFrom</b> field to query operations.
     *
     */
    public final static BusinessRoleChangesField<String> VALUE_CHANGED_FROM =
        new BusinessRoleChangesField<String>("ValueChangedFrom");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 254
     * <p>
     * Original property name from the Odata EDM: <b>ValueChangedTo</b>
     * </p>
     *
     * @return Value Changed To
     */
    @Key
    @SerializedName( "ValueChangedTo" )
    @JsonProperty( "ValueChangedTo" )
    @Nullable
    @ODataField( odataName = "ValueChangedTo" )
    private String valueChangedTo;
    /**
     * Use with available fluent helpers to apply the <b>ValueChangedTo</b> field to query operations.
     *
     */
    public final static BusinessRoleChangesField<String> VALUE_CHANGED_TO =
        new BusinessRoleChangesField<String>("ValueChangedTo");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>ChangedByUserName</b>
     * </p>
     *
     * @return Changed By User Name
     */
    @SerializedName( "ChangedByUserName" )
    @JsonProperty( "ChangedByUserName" )
    @Nullable
    @ODataField( odataName = "ChangedByUserName" )
    private String changedByUserName;
    /**
     * Use with available fluent helpers to apply the <b>ChangedByUserName</b> field to query operations.
     *
     */
    public final static BusinessRoleChangesField<String> CHANGED_BY_USER_NAME =
        new BusinessRoleChangesField<String>("ChangedByUserName");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangedByUserID</b>
     * </p>
     *
     * @return Changed By User ID
     */
    @SerializedName( "ChangedByUserID" )
    @JsonProperty( "ChangedByUserID" )
    @Nullable
    @ODataField( odataName = "ChangedByUserID" )
    private String changedByUserID;
    /**
     * Use with available fluent helpers to apply the <b>ChangedByUserID</b> field to query operations.
     *
     */
    public final static BusinessRoleChangesField<String> CHANGED_BY_USER_ID =
        new BusinessRoleChangesField<String>("ChangedByUserID");
    /**
     * Constraints: Not nullable, Maximum length: 241
     * <p>
     * Original property name from the Odata EDM: <b>ChangedByUserEmailAddress</b>
     * </p>
     *
     * @return Changed By User Email Address
     */
    @SerializedName( "ChangedByUserEmailAddress" )
    @JsonProperty( "ChangedByUserEmailAddress" )
    @Nullable
    @ODataField( odataName = "ChangedByUserEmailAddress" )
    private String changedByUserEmailAddress;
    /**
     * Use with available fluent helpers to apply the <b>ChangedByUserEmailAddress</b> field to query operations.
     *
     */
    public final static BusinessRoleChangesField<String> CHANGED_BY_USER_EMAIL_ADDRESS =
        new BusinessRoleChangesField<String>("ChangedByUserEmailAddress");
    /**
     * Constraints: Not nullable, Maximum length: 36
     * <p>
     * Original property name from the Odata EDM: <b>ChangedByGlobalUserID</b>
     * </p>
     *
     * @return Changed By Global User ID
     */
    @SerializedName( "ChangedByGlobalUserID" )
    @JsonProperty( "ChangedByGlobalUserID" )
    @Nullable
    @ODataField( odataName = "ChangedByGlobalUserID" )
    private String changedByGlobalUserID;
    /**
     * Use with available fluent helpers to apply the <b>ChangedByGlobalUserID</b> field to query operations.
     *
     */
    public final static BusinessRoleChangesField<String> CHANGED_BY_GLOBAL_USER_ID =
        new BusinessRoleChangesField<String>("ChangedByGlobalUserID");
    /**
     * Constraints: Not nullable, Maximum length: 256
     * <p>
     * Original property name from the Odata EDM: <b>Action</b>
     * </p>
     *
     * @return Action
     */
    @SerializedName( "Action" )
    @JsonProperty( "Action" )
    @Nullable
    @ODataField( odataName = "Action" )
    private String action;
    /**
     * Use with available fluent helpers to apply the <b>Action</b> field to query operations.
     *
     */
    public final static BusinessRoleChangesField<String> ACTION = new BusinessRoleChangesField<String>("Action");
    /**
     * Constraints: Not nullable, Maximum length: 128
     * <p>
     * Original property name from the Odata EDM: <b>ChangeCategoryText</b>
     * </p>
     *
     * @return Change Category Text
     */
    @SerializedName( "ChangeCategoryText" )
    @JsonProperty( "ChangeCategoryText" )
    @Nullable
    @ODataField( odataName = "ChangeCategoryText" )
    private String changeCategoryText;
    /**
     * Use with available fluent helpers to apply the <b>ChangeCategoryText</b> field to query operations.
     *
     */
    public final static BusinessRoleChangesField<String> CHANGE_CATEGORY_TEXT =
        new BusinessRoleChangesField<String>("ChangeCategoryText");

    @Nonnull
    @Override
    public Class<BusinessRoleChanges> getType()
    {
        return BusinessRoleChanges.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusinessRoleID</b>
     * </p>
     *
     * @param businessRoleID
     *            Business Role ID
     */
    public void setBusinessRoleID( @Nullable final String businessRoleID )
    {
        rememberChangedField("BusinessRoleID", this.businessRoleID);
        this.businessRoleID = businessRoleID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ChangedOn</b>
     * </p>
     *
     * @param changedOn
     *            Changed On
     */
    public void setChangedOn( @Nullable final ZonedDateTime changedOn )
    {
        rememberChangedField("ChangedOn", this.changedOn);
        this.changedOn = changedOn;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ChangeCategory</b>
     * </p>
     *
     * @param changeCategory
     *            Change Category
     */
    public void setChangeCategory( @Nullable final String changeCategory )
    {
        rememberChangedField("ChangeCategory", this.changeCategory);
        this.changeCategory = changeCategory;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 256
     * <p>
     * Original property name from the Odata EDM: <b>Attribute</b>
     * </p>
     *
     * @param attribute
     *            Attribute
     */
    public void setAttribute( @Nullable final String attribute )
    {
        rememberChangedField("Attribute", this.attribute);
        this.attribute = attribute;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 254
     * <p>
     * Original property name from the Odata EDM: <b>ValueChangedFrom</b>
     * </p>
     *
     * @param valueChangedFrom
     *            Value Changed From
     */
    public void setValueChangedFrom( @Nullable final String valueChangedFrom )
    {
        rememberChangedField("ValueChangedFrom", this.valueChangedFrom);
        this.valueChangedFrom = valueChangedFrom;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 254
     * <p>
     * Original property name from the Odata EDM: <b>ValueChangedTo</b>
     * </p>
     *
     * @param valueChangedTo
     *            Value Changed To
     */
    public void setValueChangedTo( @Nullable final String valueChangedTo )
    {
        rememberChangedField("ValueChangedTo", this.valueChangedTo);
        this.valueChangedTo = valueChangedTo;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>ChangedByUserName</b>
     * </p>
     *
     * @param changedByUserName
     *            Changed By User Name
     */
    public void setChangedByUserName( @Nullable final String changedByUserName )
    {
        rememberChangedField("ChangedByUserName", this.changedByUserName);
        this.changedByUserName = changedByUserName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangedByUserID</b>
     * </p>
     *
     * @param changedByUserID
     *            Changed By User ID
     */
    public void setChangedByUserID( @Nullable final String changedByUserID )
    {
        rememberChangedField("ChangedByUserID", this.changedByUserID);
        this.changedByUserID = changedByUserID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 241
     * <p>
     * Original property name from the Odata EDM: <b>ChangedByUserEmailAddress</b>
     * </p>
     *
     * @param changedByUserEmailAddress
     *            Changed By User Email Address
     */
    public void setChangedByUserEmailAddress( @Nullable final String changedByUserEmailAddress )
    {
        rememberChangedField("ChangedByUserEmailAddress", this.changedByUserEmailAddress);
        this.changedByUserEmailAddress = changedByUserEmailAddress;
    }

    /**
     * Constraints: Not nullable, Maximum length: 36
     * <p>
     * Original property name from the Odata EDM: <b>ChangedByGlobalUserID</b>
     * </p>
     *
     * @param changedByGlobalUserID
     *            Changed By Global User ID
     */
    public void setChangedByGlobalUserID( @Nullable final String changedByGlobalUserID )
    {
        rememberChangedField("ChangedByGlobalUserID", this.changedByGlobalUserID);
        this.changedByGlobalUserID = changedByGlobalUserID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 256
     * <p>
     * Original property name from the Odata EDM: <b>Action</b>
     * </p>
     *
     * @param action
     *            Action
     */
    public void setAction( @Nullable final String action )
    {
        rememberChangedField("Action", this.action);
        this.action = action;
    }

    /**
     * Constraints: Not nullable, Maximum length: 128
     * <p>
     * Original property name from the Odata EDM: <b>ChangeCategoryText</b>
     * </p>
     *
     * @param changeCategoryText
     *            Change Category Text
     */
    public void setChangeCategoryText( @Nullable final String changeCategoryText )
    {
        rememberChangedField("ChangeCategoryText", this.changeCategoryText);
        this.changeCategoryText = changeCategoryText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "BusinessRoleChanges";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BusinessRoleID", getBusinessRoleID());
        result.put("ChangedOn", getChangedOn());
        result.put("ChangeCategory", getChangeCategory());
        result.put("Attribute", getAttribute());
        result.put("ValueChangedFrom", getValueChangedFrom());
        result.put("ValueChangedTo", getValueChangedTo());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BusinessRoleID", getBusinessRoleID());
        values.put("ChangedOn", getChangedOn());
        values.put("ChangeCategory", getChangeCategory());
        values.put("Attribute", getAttribute());
        values.put("ValueChangedFrom", getValueChangedFrom());
        values.put("ValueChangedTo", getValueChangedTo());
        values.put("ChangedByUserName", getChangedByUserName());
        values.put("ChangedByUserID", getChangedByUserID());
        values.put("ChangedByUserEmailAddress", getChangedByUserEmailAddress());
        values.put("ChangedByGlobalUserID", getChangedByGlobalUserID());
        values.put("Action", getAction());
        values.put("ChangeCategoryText", getChangeCategoryText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BusinessRoleID") ) {
                final Object value = values.remove("BusinessRoleID");
                if( (value == null) || (!value.equals(getBusinessRoleID())) ) {
                    setBusinessRoleID(((String) value));
                }
            }
            if( values.containsKey("ChangedOn") ) {
                final Object value = values.remove("ChangedOn");
                if( (value == null) || (!value.equals(getChangedOn())) ) {
                    setChangedOn(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("ChangeCategory") ) {
                final Object value = values.remove("ChangeCategory");
                if( (value == null) || (!value.equals(getChangeCategory())) ) {
                    setChangeCategory(((String) value));
                }
            }
            if( values.containsKey("Attribute") ) {
                final Object value = values.remove("Attribute");
                if( (value == null) || (!value.equals(getAttribute())) ) {
                    setAttribute(((String) value));
                }
            }
            if( values.containsKey("ValueChangedFrom") ) {
                final Object value = values.remove("ValueChangedFrom");
                if( (value == null) || (!value.equals(getValueChangedFrom())) ) {
                    setValueChangedFrom(((String) value));
                }
            }
            if( values.containsKey("ValueChangedTo") ) {
                final Object value = values.remove("ValueChangedTo");
                if( (value == null) || (!value.equals(getValueChangedTo())) ) {
                    setValueChangedTo(((String) value));
                }
            }
            if( values.containsKey("ChangedByUserName") ) {
                final Object value = values.remove("ChangedByUserName");
                if( (value == null) || (!value.equals(getChangedByUserName())) ) {
                    setChangedByUserName(((String) value));
                }
            }
            if( values.containsKey("ChangedByUserID") ) {
                final Object value = values.remove("ChangedByUserID");
                if( (value == null) || (!value.equals(getChangedByUserID())) ) {
                    setChangedByUserID(((String) value));
                }
            }
            if( values.containsKey("ChangedByUserEmailAddress") ) {
                final Object value = values.remove("ChangedByUserEmailAddress");
                if( (value == null) || (!value.equals(getChangedByUserEmailAddress())) ) {
                    setChangedByUserEmailAddress(((String) value));
                }
            }
            if( values.containsKey("ChangedByGlobalUserID") ) {
                final Object value = values.remove("ChangedByGlobalUserID");
                if( (value == null) || (!value.equals(getChangedByGlobalUserID())) ) {
                    setChangedByGlobalUserID(((String) value));
                }
            }
            if( values.containsKey("Action") ) {
                final Object value = values.remove("Action");
                if( (value == null) || (!value.equals(getAction())) ) {
                    setAction(((String) value));
                }
            }
            if( values.containsKey("ChangeCategoryText") ) {
                final Object value = values.remove("ChangeCategoryText");
                if( (value == null) || (!value.equals(getChangeCategoryText())) ) {
                    setChangeCategoryText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> BusinessRoleChangesField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BusinessRoleChangesField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BusinessRoleChangesField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BusinessRoleChangesField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessRoleChangesService.DEFAULT_SERVICE_PATH);
    }

}
