/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessrolechanges.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link BusinessRoleChangesServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessRoleChangesService BusinessRoleChangesService}.
 *
 */
public class DefaultBusinessRoleChangesServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<BusinessRoleChangesServiceBatch, BusinessRoleChangesServiceBatchChangeSet>
    implements
    BusinessRoleChangesServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessRoleChangesService service;

    @SuppressWarnings( "deprecation" )
    DefaultBusinessRoleChangesServiceBatchChangeSet(
        @Nonnull final DefaultBusinessRoleChangesServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessRoleChangesService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultBusinessRoleChangesServiceBatchChangeSet getThis()
    {
        return this;
    }

}
