/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessrolechanges.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessrolechanges.BusinessRoleChanges;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessrolechanges.BusinessRoleChanges
 * BusinessRoleChanges}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessrolechanges.field.BusinessRoleChangesField
 * BusinessRoleChangesField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessrolechanges.link.BusinessRoleChangesLink
 * BusinessRoleChangesLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessrolechanges.BusinessRoleChanges#BUSINESS_ROLE_ID
 * BUSINESS_ROLE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessrolechanges.BusinessRoleChanges#CHANGED_ON
 * CHANGED_ON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessrolechanges.BusinessRoleChanges#CHANGE_CATEGORY
 * CHANGE_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessrolechanges.BusinessRoleChanges#ATTRIBUTE
 * ATTRIBUTE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessrolechanges.BusinessRoleChanges#VALUE_CHANGED_FROM
 * VALUE_CHANGED_FROM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessrolechanges.BusinessRoleChanges#VALUE_CHANGED_TO
 * VALUE_CHANGED_TO}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessrolechanges.BusinessRoleChanges#CHANGED_BY_USER_NAME
 * CHANGED_BY_USER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessrolechanges.BusinessRoleChanges#CHANGED_BY_USER_ID
 * CHANGED_BY_USER_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessrolechanges.BusinessRoleChanges#CHANGED_BY_USER_EMAIL_ADDRESS
 * CHANGED_BY_USER_EMAIL_ADDRESS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessrolechanges.BusinessRoleChanges#CHANGED_BY_GLOBAL_USER_ID
 * CHANGED_BY_GLOBAL_USER_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessrolechanges.BusinessRoleChanges#ACTION
 * ACTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessrolechanges.BusinessRoleChanges#CHANGE_CATEGORY_TEXT
 * CHANGE_CATEGORY_TEXT}</li>
 * </ul>
 *
 */
public interface BusinessRoleChangesSelectable extends EntitySelectable<BusinessRoleChanges>
{

}
