/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation;

import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.field.SitnDataContextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.selectable.SitnDataContextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Situation Data Context
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SitnDataContextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SitnDataContext extends VdmEntity<SitnDataContext>
{

    /**
     * Selector for all available fields of SitnDataContext.
     *
     */
    public final static SitnDataContextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>SitnDataContextID</b>
     * </p>
     *
     * @return Data Context ID
     */
    @Key
    @SerializedName( "SitnDataContextID" )
    @JsonProperty( "SitnDataContextID" )
    @Nullable
    @ODataField( odataName = "SitnDataContextID" )
    private String sitnDataContextID;
    /**
     * Use with available fluent helpers to apply the <b>SitnDataContextID</b> field to query operations.
     *
     */
    public final static SitnDataContextField<String> SITN_DATA_CONTEXT_ID =
        new SitnDataContextField<String>("SitnDataContextID");
    /**
     * Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>SitnInstceActivityID</b>
     * </p>
     *
     * @return Unique ID of Situation Instance Activity
     */
    @SerializedName( "SitnInstceActivityID" )
    @JsonProperty( "SitnInstceActivityID" )
    @Nullable
    @ODataField( odataName = "SitnInstceActivityID" )
    private String sitnInstceActivityID;
    /**
     * Use with available fluent helpers to apply the <b>SitnInstceActivityID</b> field to query operations.
     *
     */
    public final static SitnDataContextField<String> SITN_INSTCE_ACTIVITY_ID =
        new SitnDataContextField<String>("SitnInstceActivityID");
    /**
     * Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>SitnInstanceID</b>
     * </p>
     *
     * @return Instance ID
     */
    @SerializedName( "SitnInstanceID" )
    @JsonProperty( "SitnInstanceID" )
    @Nullable
    @ODataField( odataName = "SitnInstanceID" )
    private String sitnInstanceID;
    /**
     * Use with available fluent helpers to apply the <b>SitnInstanceID</b> field to query operations.
     *
     */
    public final static SitnDataContextField<String> SITN_INSTANCE_ID =
        new SitnDataContextField<String>("SitnInstanceID");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    @SerializedName( "CreationDateTime" )
    @JsonProperty( "CreationDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime creationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationDateTime</b> field to query operations.
     *
     */
    public final static SitnDataContextField<ZonedDateTime> CREATION_DATE_TIME =
        new SitnDataContextField<ZonedDateTime>("CreationDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>SitnInstceAnchorObjectKey</b>
     * </p>
     *
     * @return Anchor Object Key
     */
    @SerializedName( "SitnInstceAnchorObjectKey" )
    @JsonProperty( "SitnInstceAnchorObjectKey" )
    @Nullable
    @ODataField( odataName = "SitnInstceAnchorObjectKey" )
    private String sitnInstceAnchorObjectKey;
    /**
     * Use with available fluent helpers to apply the <b>SitnInstceAnchorObjectKey</b> field to query operations.
     *
     */
    public final static SitnDataContextField<String> SITN_INSTCE_ANCHOR_OBJECT_KEY =
        new SitnDataContextField<String>("SitnInstceAnchorObjectKey");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>SitnInstceTriggerObjectKey</b>
     * </p>
     *
     * @return Trigger Object Key
     */
    @SerializedName( "SitnInstceTriggerObjectKey" )
    @JsonProperty( "SitnInstceTriggerObjectKey" )
    @Nullable
    @ODataField( odataName = "SitnInstceTriggerObjectKey" )
    private String sitnInstceTriggerObjectKey;
    /**
     * Use with available fluent helpers to apply the <b>SitnInstceTriggerObjectKey</b> field to query operations.
     *
     */
    public final static SitnDataContextField<String> SITN_INSTCE_TRIGGER_OBJECT_KEY =
        new SitnDataContextField<String>("SitnInstceTriggerObjectKey");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SitnInstceStatus</b>
     * </p>
     *
     * @return Instance Status
     */
    @SerializedName( "SitnInstceStatus" )
    @JsonProperty( "SitnInstceStatus" )
    @Nullable
    @ODataField( odataName = "SitnInstceStatus" )
    private String sitnInstceStatus;
    /**
     * Use with available fluent helpers to apply the <b>SitnInstceStatus</b> field to query operations.
     *
     */
    public final static SitnDataContextField<String> SITN_INSTCE_STATUS =
        new SitnDataContextField<String>("SitnInstceStatus");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SitnInstceActyType</b>
     * </p>
     *
     * @return Instance Activity Type
     */
    @SerializedName( "SitnInstceActyType" )
    @JsonProperty( "SitnInstceActyType" )
    @Nullable
    @ODataField( odataName = "SitnInstceActyType" )
    private String sitnInstceActyType;
    /**
     * Use with available fluent helpers to apply the <b>SitnInstceActyType</b> field to query operations.
     *
     */
    public final static SitnDataContextField<String> SITN_INSTCE_ACTY_TYPE =
        new SitnDataContextField<String>("SitnInstceActyType");
    /**
     * Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>SitnDefinitionID</b>
     * </p>
     *
     * @return Situation Type ID
     */
    @SerializedName( "SitnDefinitionID" )
    @JsonProperty( "SitnDefinitionID" )
    @Nullable
    @ODataField( odataName = "SitnDefinitionID" )
    private String sitnDefinitionID;
    /**
     * Use with available fluent helpers to apply the <b>SitnDefinitionID</b> field to query operations.
     *
     */
    public final static SitnDataContextField<String> SITN_DEFINITION_ID =
        new SitnDataContextField<String>("SitnDefinitionID");
    /**
     * Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>SitnDefTemplateID</b>
     * </p>
     *
     * @return Situation Standard Template ID
     */
    @SerializedName( "SitnDefTemplateID" )
    @JsonProperty( "SitnDefTemplateID" )
    @Nullable
    @ODataField( odataName = "SitnDefTemplateID" )
    private String sitnDefTemplateID;
    /**
     * Use with available fluent helpers to apply the <b>SitnDefTemplateID</b> field to query operations.
     *
     */
    public final static SitnDataContextField<String> SITN_DEF_TEMPLATE_ID =
        new SitnDataContextField<String>("SitnDefTemplateID");
    /**
     * Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>SitnActionID</b>
     * </p>
     *
     * @return Action ID
     */
    @SerializedName( "SitnActionID" )
    @JsonProperty( "SitnActionID" )
    @Nullable
    @ODataField( odataName = "SitnActionID" )
    private String sitnActionID;
    /**
     * Use with available fluent helpers to apply the <b>SitnActionID</b> field to query operations.
     *
     */
    public final static SitnDataContextField<String> SITN_ACTION_ID = new SitnDataContextField<String>("SitnActionID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SitnDataContext</b>
     * </p>
     *
     * @return Situation Data Context Data
     */
    @SerializedName( "SitnDataContext" )
    @JsonProperty( "SitnDataContext" )
    @Nullable
    @ODataField( odataName = "SitnDataContext" )
    private String sitnDataContext;
    /**
     * Use with available fluent helpers to apply the <b>SitnDataContext</b> field to query operations.
     *
     */
    public final static SitnDataContextField<String> SITN_DATA_CONTEXT =
        new SitnDataContextField<String>("SitnDataContext");

    @Nonnull
    @Override
    public Class<SitnDataContext> getType()
    {
        return SitnDataContext.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>SitnDataContextID</b>
     * </p>
     *
     * @param sitnDataContextID
     *            Data Context ID
     */
    public void setSitnDataContextID( @Nullable final String sitnDataContextID )
    {
        rememberChangedField("SitnDataContextID", this.sitnDataContextID);
        this.sitnDataContextID = sitnDataContextID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>SitnInstceActivityID</b>
     * </p>
     *
     * @param sitnInstceActivityID
     *            Unique ID of Situation Instance Activity
     */
    public void setSitnInstceActivityID( @Nullable final String sitnInstceActivityID )
    {
        rememberChangedField("SitnInstceActivityID", this.sitnInstceActivityID);
        this.sitnInstceActivityID = sitnInstceActivityID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>SitnInstanceID</b>
     * </p>
     *
     * @param sitnInstanceID
     *            Instance ID
     */
    public void setSitnInstanceID( @Nullable final String sitnInstanceID )
    {
        rememberChangedField("SitnInstanceID", this.sitnInstanceID);
        this.sitnInstanceID = sitnInstanceID;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @param creationDateTime
     *            UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    public void setCreationDateTime( @Nullable final ZonedDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>SitnInstceAnchorObjectKey</b>
     * </p>
     *
     * @param sitnInstceAnchorObjectKey
     *            Anchor Object Key
     */
    public void setSitnInstceAnchorObjectKey( @Nullable final String sitnInstceAnchorObjectKey )
    {
        rememberChangedField("SitnInstceAnchorObjectKey", this.sitnInstceAnchorObjectKey);
        this.sitnInstceAnchorObjectKey = sitnInstceAnchorObjectKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>SitnInstceTriggerObjectKey</b>
     * </p>
     *
     * @param sitnInstceTriggerObjectKey
     *            Trigger Object Key
     */
    public void setSitnInstceTriggerObjectKey( @Nullable final String sitnInstceTriggerObjectKey )
    {
        rememberChangedField("SitnInstceTriggerObjectKey", this.sitnInstceTriggerObjectKey);
        this.sitnInstceTriggerObjectKey = sitnInstceTriggerObjectKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SitnInstceStatus</b>
     * </p>
     *
     * @param sitnInstceStatus
     *            Instance Status
     */
    public void setSitnInstceStatus( @Nullable final String sitnInstceStatus )
    {
        rememberChangedField("SitnInstceStatus", this.sitnInstceStatus);
        this.sitnInstceStatus = sitnInstceStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SitnInstceActyType</b>
     * </p>
     *
     * @param sitnInstceActyType
     *            Instance Activity Type
     */
    public void setSitnInstceActyType( @Nullable final String sitnInstceActyType )
    {
        rememberChangedField("SitnInstceActyType", this.sitnInstceActyType);
        this.sitnInstceActyType = sitnInstceActyType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>SitnDefinitionID</b>
     * </p>
     *
     * @param sitnDefinitionID
     *            Situation Type ID
     */
    public void setSitnDefinitionID( @Nullable final String sitnDefinitionID )
    {
        rememberChangedField("SitnDefinitionID", this.sitnDefinitionID);
        this.sitnDefinitionID = sitnDefinitionID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>SitnDefTemplateID</b>
     * </p>
     *
     * @param sitnDefTemplateID
     *            Situation Standard Template ID
     */
    public void setSitnDefTemplateID( @Nullable final String sitnDefTemplateID )
    {
        rememberChangedField("SitnDefTemplateID", this.sitnDefTemplateID);
        this.sitnDefTemplateID = sitnDefTemplateID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>SitnActionID</b>
     * </p>
     *
     * @param sitnActionID
     *            Action ID
     */
    public void setSitnActionID( @Nullable final String sitnActionID )
    {
        rememberChangedField("SitnActionID", this.sitnActionID);
        this.sitnActionID = sitnActionID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SitnDataContext</b>
     * </p>
     *
     * @param sitnDataContext
     *            Situation Data Context Data
     */
    public void setSitnDataContext( @Nullable final String sitnDataContext )
    {
        rememberChangedField("SitnDataContext", this.sitnDataContext);
        this.sitnDataContext = sitnDataContext;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SitnDataContext";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SitnDataContextID", getSitnDataContextID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SitnDataContextID", getSitnDataContextID());
        values.put("SitnInstceActivityID", getSitnInstceActivityID());
        values.put("SitnInstanceID", getSitnInstanceID());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("SitnInstceAnchorObjectKey", getSitnInstceAnchorObjectKey());
        values.put("SitnInstceTriggerObjectKey", getSitnInstceTriggerObjectKey());
        values.put("SitnInstceStatus", getSitnInstceStatus());
        values.put("SitnInstceActyType", getSitnInstceActyType());
        values.put("SitnDefinitionID", getSitnDefinitionID());
        values.put("SitnDefTemplateID", getSitnDefTemplateID());
        values.put("SitnActionID", getSitnActionID());
        values.put("SitnDataContext", getSitnDataContext());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SitnDataContextID") ) {
                final Object value = values.remove("SitnDataContextID");
                if( (value == null) || (!value.equals(getSitnDataContextID())) ) {
                    setSitnDataContextID(((String) value));
                }
            }
            if( values.containsKey("SitnInstceActivityID") ) {
                final Object value = values.remove("SitnInstceActivityID");
                if( (value == null) || (!value.equals(getSitnInstceActivityID())) ) {
                    setSitnInstceActivityID(((String) value));
                }
            }
            if( values.containsKey("SitnInstanceID") ) {
                final Object value = values.remove("SitnInstanceID");
                if( (value == null) || (!value.equals(getSitnInstanceID())) ) {
                    setSitnInstanceID(((String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("SitnInstceAnchorObjectKey") ) {
                final Object value = values.remove("SitnInstceAnchorObjectKey");
                if( (value == null) || (!value.equals(getSitnInstceAnchorObjectKey())) ) {
                    setSitnInstceAnchorObjectKey(((String) value));
                }
            }
            if( values.containsKey("SitnInstceTriggerObjectKey") ) {
                final Object value = values.remove("SitnInstceTriggerObjectKey");
                if( (value == null) || (!value.equals(getSitnInstceTriggerObjectKey())) ) {
                    setSitnInstceTriggerObjectKey(((String) value));
                }
            }
            if( values.containsKey("SitnInstceStatus") ) {
                final Object value = values.remove("SitnInstceStatus");
                if( (value == null) || (!value.equals(getSitnInstceStatus())) ) {
                    setSitnInstceStatus(((String) value));
                }
            }
            if( values.containsKey("SitnInstceActyType") ) {
                final Object value = values.remove("SitnInstceActyType");
                if( (value == null) || (!value.equals(getSitnInstceActyType())) ) {
                    setSitnInstceActyType(((String) value));
                }
            }
            if( values.containsKey("SitnDefinitionID") ) {
                final Object value = values.remove("SitnDefinitionID");
                if( (value == null) || (!value.equals(getSitnDefinitionID())) ) {
                    setSitnDefinitionID(((String) value));
                }
            }
            if( values.containsKey("SitnDefTemplateID") ) {
                final Object value = values.remove("SitnDefTemplateID");
                if( (value == null) || (!value.equals(getSitnDefTemplateID())) ) {
                    setSitnDefTemplateID(((String) value));
                }
            }
            if( values.containsKey("SitnActionID") ) {
                final Object value = values.remove("SitnActionID");
                if( (value == null) || (!value.equals(getSitnActionID())) ) {
                    setSitnActionID(((String) value));
                }
            }
            if( values.containsKey("SitnDataContext") ) {
                final Object value = values.remove("SitnDataContext");
                if( (value == null) || (!value.equals(getSitnDataContext())) ) {
                    setSitnDataContext(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SitnDataContextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SitnDataContextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SitnDataContextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SitnDataContextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSituationService.DEFAULT_SERVICE_PATH);
    }

}
