/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.selectable.SitnDataContextSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SitnDataContext SitnDataContext} entity
 * using key fields. This fluent helper allows methods which modify the underlying query to be called before executing
 * the query itself.
 *
 */
public class SitnDataContextByKeyFluentHelper
    extends
    FluentHelperByKey<SitnDataContextByKeyFluentHelper, SitnDataContext, SitnDataContextSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SitnDataContext SitnDataContext}
     * entity with the provided key field values. To perform execution, call the {@link #executeRequest executeRequest}
     * method on the fluent helper object.
     *
     * @param sitnDataContextID
     *            Data Context ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 32
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SitnDataContext}
     * @param servicePath
     *            Service path to be used to fetch a single {@code SitnDataContext}
     */
    public SitnDataContextByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String sitnDataContextID )
    {
        super(servicePath, entityCollection);
        this.key.put("SitnDataContextID", sitnDataContextID);
    }

    @Override
    @Nonnull
    protected Class<SitnDataContext> getEntityClass()
    {
        return SitnDataContext.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
