/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation;

import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.field.SitnInstanceField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.selectable.SitnInstanceSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Situation Instance
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SitnInstanceType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SitnInstance extends VdmEntity<SitnInstance>
{

    /**
     * Selector for all available fields of SitnInstance.
     *
     */
    public final static SitnInstanceSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>SitnInstanceID</b>
     * </p>
     *
     * @return Instance ID
     */
    @Key
    @SerializedName( "SitnInstanceID" )
    @JsonProperty( "SitnInstanceID" )
    @Nullable
    @ODataField( odataName = "SitnInstanceID" )
    private String sitnInstanceID;
    /**
     * Use with available fluent helpers to apply the <b>SitnInstanceID</b> field to query operations.
     *
     */
    public final static SitnInstanceField<String> SITN_INSTANCE_ID = new SitnInstanceField<String>("SitnInstanceID");
    /**
     * Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>SitnDefinitionID</b>
     * </p>
     *
     * @return Situation Type ID
     */
    @SerializedName( "SitnDefinitionID" )
    @JsonProperty( "SitnDefinitionID" )
    @Nullable
    @ODataField( odataName = "SitnDefinitionID" )
    private String sitnDefinitionID;
    /**
     * Use with available fluent helpers to apply the <b>SitnDefinitionID</b> field to query operations.
     *
     */
    public final static SitnInstanceField<String> SITN_DEFINITION_ID =
        new SitnInstanceField<String>("SitnDefinitionID");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>SitnInstceAnchorObjectKey</b>
     * </p>
     *
     * @return Anchor Object Key
     */
    @SerializedName( "SitnInstceAnchorObjectKey" )
    @JsonProperty( "SitnInstceAnchorObjectKey" )
    @Nullable
    @ODataField( odataName = "SitnInstceAnchorObjectKey" )
    private String sitnInstceAnchorObjectKey;
    /**
     * Use with available fluent helpers to apply the <b>SitnInstceAnchorObjectKey</b> field to query operations.
     *
     */
    public final static SitnInstanceField<String> SITN_INSTCE_ANCHOR_OBJECT_KEY =
        new SitnInstanceField<String>("SitnInstceAnchorObjectKey");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>SitnInstceTriggerObjectKey</b>
     * </p>
     *
     * @return Trigger Object Key
     */
    @SerializedName( "SitnInstceTriggerObjectKey" )
    @JsonProperty( "SitnInstceTriggerObjectKey" )
    @Nullable
    @ODataField( odataName = "SitnInstceTriggerObjectKey" )
    private String sitnInstceTriggerObjectKey;
    /**
     * Use with available fluent helpers to apply the <b>SitnInstceTriggerObjectKey</b> field to query operations.
     *
     */
    public final static SitnInstanceField<String> SITN_INSTCE_TRIGGER_OBJECT_KEY =
        new SitnInstanceField<String>("SitnInstceTriggerObjectKey");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SitnInstceStatus</b>
     * </p>
     *
     * @return Instance Status
     */
    @SerializedName( "SitnInstceStatus" )
    @JsonProperty( "SitnInstceStatus" )
    @Nullable
    @ODataField( odataName = "SitnInstceStatus" )
    private String sitnInstceStatus;
    /**
     * Use with available fluent helpers to apply the <b>SitnInstceStatus</b> field to query operations.
     *
     */
    public final static SitnInstanceField<String> SITN_INSTCE_STATUS =
        new SitnInstanceField<String>("SitnInstceStatus");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SitnInstceStage</b>
     * </p>
     *
     * @return Stage of Instance
     */
    @SerializedName( "SitnInstceStage" )
    @JsonProperty( "SitnInstceStage" )
    @Nullable
    @ODataField( odataName = "SitnInstceStage" )
    private String sitnInstceStage;
    /**
     * Use with available fluent helpers to apply the <b>SitnInstceStage</b> field to query operations.
     *
     */
    public final static SitnInstanceField<String> SITN_INSTCE_STAGE = new SitnInstanceField<String>("SitnInstceStage");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    @SerializedName( "CreationDateTime" )
    @JsonProperty( "CreationDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime creationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationDateTime</b> field to query operations.
     *
     */
    public final static SitnInstanceField<ZonedDateTime> CREATION_DATE_TIME =
        new SitnInstanceField<ZonedDateTime>("CreationDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SitnDefAnchorObject</b>
     * </p>
     *
     * @return Situation Anchor Object Type
     */
    @SerializedName( "SitnDefAnchorObject" )
    @JsonProperty( "SitnDefAnchorObject" )
    @Nullable
    @ODataField( odataName = "SitnDefAnchorObject" )
    private String sitnDefAnchorObject;
    /**
     * Use with available fluent helpers to apply the <b>SitnDefAnchorObject</b> field to query operations.
     *
     */
    public final static SitnInstanceField<String> SITN_DEF_ANCHOR_OBJECT =
        new SitnInstanceField<String>("SitnDefAnchorObject");
    /**
     * Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>SitnDefTemplateID</b>
     * </p>
     *
     * @return Situation Standard Template ID
     */
    @SerializedName( "SitnDefTemplateID" )
    @JsonProperty( "SitnDefTemplateID" )
    @Nullable
    @ODataField( odataName = "SitnDefTemplateID" )
    private String sitnDefTemplateID;
    /**
     * Use with available fluent helpers to apply the <b>SitnDefTemplateID</b> field to query operations.
     *
     */
    public final static SitnInstanceField<String> SITN_DEF_TEMPLATE_ID =
        new SitnInstanceField<String>("SitnDefTemplateID");

    @Nonnull
    @Override
    public Class<SitnInstance> getType()
    {
        return SitnInstance.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>SitnInstanceID</b>
     * </p>
     *
     * @param sitnInstanceID
     *            Instance ID
     */
    public void setSitnInstanceID( @Nullable final String sitnInstanceID )
    {
        rememberChangedField("SitnInstanceID", this.sitnInstanceID);
        this.sitnInstanceID = sitnInstanceID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>SitnDefinitionID</b>
     * </p>
     *
     * @param sitnDefinitionID
     *            Situation Type ID
     */
    public void setSitnDefinitionID( @Nullable final String sitnDefinitionID )
    {
        rememberChangedField("SitnDefinitionID", this.sitnDefinitionID);
        this.sitnDefinitionID = sitnDefinitionID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>SitnInstceAnchorObjectKey</b>
     * </p>
     *
     * @param sitnInstceAnchorObjectKey
     *            Anchor Object Key
     */
    public void setSitnInstceAnchorObjectKey( @Nullable final String sitnInstceAnchorObjectKey )
    {
        rememberChangedField("SitnInstceAnchorObjectKey", this.sitnInstceAnchorObjectKey);
        this.sitnInstceAnchorObjectKey = sitnInstceAnchorObjectKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>SitnInstceTriggerObjectKey</b>
     * </p>
     *
     * @param sitnInstceTriggerObjectKey
     *            Trigger Object Key
     */
    public void setSitnInstceTriggerObjectKey( @Nullable final String sitnInstceTriggerObjectKey )
    {
        rememberChangedField("SitnInstceTriggerObjectKey", this.sitnInstceTriggerObjectKey);
        this.sitnInstceTriggerObjectKey = sitnInstceTriggerObjectKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SitnInstceStatus</b>
     * </p>
     *
     * @param sitnInstceStatus
     *            Instance Status
     */
    public void setSitnInstceStatus( @Nullable final String sitnInstceStatus )
    {
        rememberChangedField("SitnInstceStatus", this.sitnInstceStatus);
        this.sitnInstceStatus = sitnInstceStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SitnInstceStage</b>
     * </p>
     *
     * @param sitnInstceStage
     *            Stage of Instance
     */
    public void setSitnInstceStage( @Nullable final String sitnInstceStage )
    {
        rememberChangedField("SitnInstceStage", this.sitnInstceStage);
        this.sitnInstceStage = sitnInstceStage;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @param creationDateTime
     *            UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    public void setCreationDateTime( @Nullable final ZonedDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SitnDefAnchorObject</b>
     * </p>
     *
     * @param sitnDefAnchorObject
     *            Situation Anchor Object Type
     */
    public void setSitnDefAnchorObject( @Nullable final String sitnDefAnchorObject )
    {
        rememberChangedField("SitnDefAnchorObject", this.sitnDefAnchorObject);
        this.sitnDefAnchorObject = sitnDefAnchorObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>SitnDefTemplateID</b>
     * </p>
     *
     * @param sitnDefTemplateID
     *            Situation Standard Template ID
     */
    public void setSitnDefTemplateID( @Nullable final String sitnDefTemplateID )
    {
        rememberChangedField("SitnDefTemplateID", this.sitnDefTemplateID);
        this.sitnDefTemplateID = sitnDefTemplateID;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SitnInstance";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SitnInstanceID", getSitnInstanceID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SitnInstanceID", getSitnInstanceID());
        values.put("SitnDefinitionID", getSitnDefinitionID());
        values.put("SitnInstceAnchorObjectKey", getSitnInstceAnchorObjectKey());
        values.put("SitnInstceTriggerObjectKey", getSitnInstceTriggerObjectKey());
        values.put("SitnInstceStatus", getSitnInstceStatus());
        values.put("SitnInstceStage", getSitnInstceStage());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("SitnDefAnchorObject", getSitnDefAnchorObject());
        values.put("SitnDefTemplateID", getSitnDefTemplateID());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SitnInstanceID") ) {
                final Object value = values.remove("SitnInstanceID");
                if( (value == null) || (!value.equals(getSitnInstanceID())) ) {
                    setSitnInstanceID(((String) value));
                }
            }
            if( values.containsKey("SitnDefinitionID") ) {
                final Object value = values.remove("SitnDefinitionID");
                if( (value == null) || (!value.equals(getSitnDefinitionID())) ) {
                    setSitnDefinitionID(((String) value));
                }
            }
            if( values.containsKey("SitnInstceAnchorObjectKey") ) {
                final Object value = values.remove("SitnInstceAnchorObjectKey");
                if( (value == null) || (!value.equals(getSitnInstceAnchorObjectKey())) ) {
                    setSitnInstceAnchorObjectKey(((String) value));
                }
            }
            if( values.containsKey("SitnInstceTriggerObjectKey") ) {
                final Object value = values.remove("SitnInstceTriggerObjectKey");
                if( (value == null) || (!value.equals(getSitnInstceTriggerObjectKey())) ) {
                    setSitnInstceTriggerObjectKey(((String) value));
                }
            }
            if( values.containsKey("SitnInstceStatus") ) {
                final Object value = values.remove("SitnInstceStatus");
                if( (value == null) || (!value.equals(getSitnInstceStatus())) ) {
                    setSitnInstceStatus(((String) value));
                }
            }
            if( values.containsKey("SitnInstceStage") ) {
                final Object value = values.remove("SitnInstceStage");
                if( (value == null) || (!value.equals(getSitnInstceStage())) ) {
                    setSitnInstceStage(((String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("SitnDefAnchorObject") ) {
                final Object value = values.remove("SitnDefAnchorObject");
                if( (value == null) || (!value.equals(getSitnDefAnchorObject())) ) {
                    setSitnDefAnchorObject(((String) value));
                }
            }
            if( values.containsKey("SitnDefTemplateID") ) {
                final Object value = values.remove("SitnDefTemplateID");
                if( (value == null) || (!value.equals(getSitnDefTemplateID())) ) {
                    setSitnDefTemplateID(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SitnInstanceField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SitnInstanceField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SitnInstanceField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SitnInstanceField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSituationService.DEFAULT_SERVICE_PATH);
    }

}
