/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link BusinessSituationServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSituationService BusinessSituationService}, allowing
 * you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultBusinessSituationServiceBatch
    extends
    BatchFluentHelperBasic<BusinessSituationServiceBatch, BusinessSituationServiceBatchChangeSet>
    implements
    BusinessSituationServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSituationService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultBusinessSituationServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultBusinessSituationServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSituationService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSituationService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultBusinessSituationServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultBusinessSituationServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSituationService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultBusinessSituationServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public BusinessSituationServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultBusinessSituationServiceBatchChangeSet(this, service);
    }

}
