/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link BusinessSituationServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSituationService BusinessSituationService}.
 *
 */
public class DefaultBusinessSituationServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<BusinessSituationServiceBatch, BusinessSituationServiceBatchChangeSet>
    implements
    BusinessSituationServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSituationService service;

    @SuppressWarnings( "deprecation" )
    DefaultBusinessSituationServiceBatchChangeSet(
        @Nonnull final DefaultBusinessSituationServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSituationService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultBusinessSituationServiceBatchChangeSet getThis()
    {
        return this;
    }

}
