/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SitnDataContext;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SitnDataContext SitnDataContext}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.field.SitnDataContextField
 * SitnDataContextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.link.SitnDataContextLink
 * SitnDataContextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SitnDataContext#SITN_DATA_CONTEXT_ID
 * SITN_DATA_CONTEXT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SitnDataContext#SITN_INSTCE_ACTIVITY_ID
 * SITN_INSTCE_ACTIVITY_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SitnDataContext#SITN_INSTANCE_ID
 * SITN_INSTANCE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SitnDataContext#CREATION_DATE_TIME
 * CREATION_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SitnDataContext#SITN_INSTCE_ANCHOR_OBJECT_KEY
 * SITN_INSTCE_ANCHOR_OBJECT_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SitnDataContext#SITN_INSTCE_TRIGGER_OBJECT_KEY
 * SITN_INSTCE_TRIGGER_OBJECT_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SitnDataContext#SITN_INSTCE_STATUS
 * SITN_INSTCE_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SitnDataContext#SITN_INSTCE_ACTY_TYPE
 * SITN_INSTCE_ACTY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SitnDataContext#SITN_DEFINITION_ID
 * SITN_DEFINITION_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SitnDataContext#SITN_DEF_TEMPLATE_ID
 * SITN_DEF_TEMPLATE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SitnDataContext#SITN_ACTION_ID
 * SITN_ACTION_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SitnDataContext#SITN_DATA_CONTEXT
 * SITN_DATA_CONTEXT}</li>
 * </ul>
 *
 */
public interface SitnDataContextSelectable extends EntitySelectable<SitnDataContext>
{

}
