/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SitnInstance;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SitnInstance SitnInstance}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.field.SitnInstanceField
 * SitnInstanceField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.link.SitnInstanceLink SitnInstanceLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SitnInstance#SITN_INSTANCE_ID
 * SITN_INSTANCE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SitnInstance#SITN_DEFINITION_ID
 * SITN_DEFINITION_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SitnInstance#SITN_INSTCE_ANCHOR_OBJECT_KEY
 * SITN_INSTCE_ANCHOR_OBJECT_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SitnInstance#SITN_INSTCE_TRIGGER_OBJECT_KEY
 * SITN_INSTCE_TRIGGER_OBJECT_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SitnInstance#SITN_INSTCE_STATUS
 * SITN_INSTCE_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SitnInstance#SITN_INSTCE_STAGE
 * SITN_INSTCE_STAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SitnInstance#CREATION_DATE_TIME
 * CREATION_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SitnInstance#SITN_DEF_ANCHOR_OBJECT
 * SITN_DEF_ANCHOR_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SitnInstance#SITN_DEF_TEMPLATE_ID
 * SITN_DEF_TEMPLATE_ID}</li>
 * </ul>
 *
 */
public interface SitnInstanceSelectable extends EntitySelectable<SitnInstance>
{

}
