/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.selectable.SituationActionSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationAction SituationAction}
 * entity using key fields. This fluent helper allows methods which modify the underlying query to be called before
 * executing the query itself.
 *
 */
public class SituationActionByKeyFluentHelper
    extends
    FluentHelperByKey<SituationActionByKeyFluentHelper, SituationAction, SituationActionSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationAction SituationAction}
     * entity with the provided key field values. To perform execution, call the {@link #executeRequest executeRequest}
     * method on the fluent helper object.
     *
     * @param sitnDefTemplateID
     *            Situation Standard Template ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 32
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SituationAction}
     * @param servicePath
     *            Service path to be used to fetch a single {@code SituationAction}
     * @param sitnActionID
     *            Action ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 32
     *            </p>
     */
    public SituationActionByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String sitnDefTemplateID,
        final String sitnActionID )
    {
        super(servicePath, entityCollection);
        this.key.put("SitnDefTemplateID", sitnDefTemplateID);
        this.key.put("SitnActionID", sitnActionID);
    }

    @Override
    @Nonnull
    protected Class<SituationAction> getEntityClass()
    {
        return SituationAction.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
