/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.field.SituationTypeField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.link.SituationTypeLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.link.SituationTypeOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.selectable.SituationTypeSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Situation Type
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SituationTypeType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SituationType extends VdmEntity<SituationType>
{

    /**
     * Selector for all available fields of SituationType.
     *
     */
    public final static SituationTypeSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>SitnDefinitionID</b>
     * </p>
     *
     * @return Situation Type ID
     */
    @Key
    @SerializedName( "SitnDefinitionID" )
    @JsonProperty( "SitnDefinitionID" )
    @Nullable
    @ODataField( odataName = "SitnDefinitionID" )
    private String sitnDefinitionID;
    /**
     * Use with available fluent helpers to apply the <b>SitnDefinitionID</b> field to query operations.
     *
     */
    public final static SituationTypeField<String> SITN_DEFINITION_ID =
        new SituationTypeField<String>("SitnDefinitionID");
    /**
     * Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>SitnDefTemplateID</b>
     * </p>
     *
     * @return Situation Standard Template ID
     */
    @SerializedName( "SitnDefTemplateID" )
    @JsonProperty( "SitnDefTemplateID" )
    @Nullable
    @ODataField( odataName = "SitnDefTemplateID" )
    private String sitnDefTemplateID;
    /**
     * Use with available fluent helpers to apply the <b>SitnDefTemplateID</b> field to query operations.
     *
     */
    public final static SituationTypeField<String> SITN_DEF_TEMPLATE_ID =
        new SituationTypeField<String>("SitnDefTemplateID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SitnDefIsEnabled</b>
     * </p>
     *
     * @return Data element for domain BOOLE: TRUE (='X') and FALSE (=' ')
     */
    @SerializedName( "SitnDefIsEnabled" )
    @JsonProperty( "SitnDefIsEnabled" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "SitnDefIsEnabled" )
    private Boolean sitnDefIsEnabled;
    /**
     * Use with available fluent helpers to apply the <b>SitnDefIsEnabled</b> field to query operations.
     *
     */
    public final static SituationTypeField<Boolean> SITN_DEF_IS_ENABLED =
        new SituationTypeField<Boolean>("SitnDefIsEnabled");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SitnDefDataContextIsEnabled</b>
     * </p>
     *
     * @return Data Context Enabled
     */
    @SerializedName( "SitnDefDataContextIsEnabled" )
    @JsonProperty( "SitnDefDataContextIsEnabled" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "SitnDefDataContextIsEnabled" )
    private Boolean sitnDefDataContextIsEnabled;
    /**
     * Use with available fluent helpers to apply the <b>SitnDefDataContextIsEnabled</b> field to query operations.
     *
     */
    public final static SituationTypeField<Boolean> SITN_DEF_DATA_CONTEXT_IS_ENABLED =
        new SituationTypeField<Boolean>("SitnDefDataContextIsEnabled");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SitnDefAutomationIsEnabled</b>
     * </p>
     *
     * @return Automation Enabled
     */
    @SerializedName( "SitnDefAutomationIsEnabled" )
    @JsonProperty( "SitnDefAutomationIsEnabled" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "SitnDefAutomationIsEnabled" )
    private Boolean sitnDefAutomationIsEnabled;
    /**
     * Use with available fluent helpers to apply the <b>SitnDefAutomationIsEnabled</b> field to query operations.
     *
     */
    public final static SituationTypeField<Boolean> SITN_DEF_AUTOMATION_IS_ENABLED =
        new SituationTypeField<Boolean>("SitnDefAutomationIsEnabled");
    /**
     * Navigation property <b>to_SituationTypeText</b> for <b>SituationType</b> to multiple <b>SituationTypeText</b>.
     *
     */
    @SerializedName( "to_SituationTypeText" )
    @JsonProperty( "to_SituationTypeText" )
    @ODataField( odataName = "to_SituationTypeText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SituationTypeText> toSituationTypeText;
    /**
     * Navigation property <b>to_SituationTemplate</b> for <b>SituationType</b> to single <b>SituationTemplate</b>.
     *
     */
    @SerializedName( "to_SituationTemplate" )
    @JsonProperty( "to_SituationTemplate" )
    @ODataField( odataName = "to_SituationTemplate" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SituationTemplate toSituationTemplate;
    /**
     * Use with available fluent helpers to apply the <b>to_SituationTypeText</b> navigation property to query
     * operations.
     *
     */
    public final static SituationTypeLink<SituationTypeText> TO_SITUATION_TYPE_TEXT =
        new SituationTypeLink<SituationTypeText>("to_SituationTypeText");
    /**
     * Use with available fluent helpers to apply the <b>to_SituationTemplate</b> navigation property to query
     * operations.
     *
     */
    public final static SituationTypeOneToOneLink<SituationTemplate> TO_SITUATION_TEMPLATE =
        new SituationTypeOneToOneLink<SituationTemplate>("to_SituationTemplate");

    @Nonnull
    @Override
    public Class<SituationType> getType()
    {
        return SituationType.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>SitnDefinitionID</b>
     * </p>
     *
     * @param sitnDefinitionID
     *            Situation Type ID
     */
    public void setSitnDefinitionID( @Nullable final String sitnDefinitionID )
    {
        rememberChangedField("SitnDefinitionID", this.sitnDefinitionID);
        this.sitnDefinitionID = sitnDefinitionID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>SitnDefTemplateID</b>
     * </p>
     *
     * @param sitnDefTemplateID
     *            Situation Standard Template ID
     */
    public void setSitnDefTemplateID( @Nullable final String sitnDefTemplateID )
    {
        rememberChangedField("SitnDefTemplateID", this.sitnDefTemplateID);
        this.sitnDefTemplateID = sitnDefTemplateID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SitnDefIsEnabled</b>
     * </p>
     *
     * @param sitnDefIsEnabled
     *            Data element for domain BOOLE: TRUE (='X') and FALSE (=' ')
     */
    public void setSitnDefIsEnabled( @Nullable final Boolean sitnDefIsEnabled )
    {
        rememberChangedField("SitnDefIsEnabled", this.sitnDefIsEnabled);
        this.sitnDefIsEnabled = sitnDefIsEnabled;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SitnDefDataContextIsEnabled</b>
     * </p>
     *
     * @param sitnDefDataContextIsEnabled
     *            Data Context Enabled
     */
    public void setSitnDefDataContextIsEnabled( @Nullable final Boolean sitnDefDataContextIsEnabled )
    {
        rememberChangedField("SitnDefDataContextIsEnabled", this.sitnDefDataContextIsEnabled);
        this.sitnDefDataContextIsEnabled = sitnDefDataContextIsEnabled;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SitnDefAutomationIsEnabled</b>
     * </p>
     *
     * @param sitnDefAutomationIsEnabled
     *            Automation Enabled
     */
    public void setSitnDefAutomationIsEnabled( @Nullable final Boolean sitnDefAutomationIsEnabled )
    {
        rememberChangedField("SitnDefAutomationIsEnabled", this.sitnDefAutomationIsEnabled);
        this.sitnDefAutomationIsEnabled = sitnDefAutomationIsEnabled;
    }

    @Override
    protected String getEntityCollection()
    {
        return "SituationType";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SitnDefinitionID", getSitnDefinitionID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SitnDefinitionID", getSitnDefinitionID());
        values.put("SitnDefTemplateID", getSitnDefTemplateID());
        values.put("SitnDefIsEnabled", getSitnDefIsEnabled());
        values.put("SitnDefDataContextIsEnabled", getSitnDefDataContextIsEnabled());
        values.put("SitnDefAutomationIsEnabled", getSitnDefAutomationIsEnabled());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SitnDefinitionID") ) {
                final Object value = values.remove("SitnDefinitionID");
                if( (value == null) || (!value.equals(getSitnDefinitionID())) ) {
                    setSitnDefinitionID(((String) value));
                }
            }
            if( values.containsKey("SitnDefTemplateID") ) {
                final Object value = values.remove("SitnDefTemplateID");
                if( (value == null) || (!value.equals(getSitnDefTemplateID())) ) {
                    setSitnDefTemplateID(((String) value));
                }
            }
            if( values.containsKey("SitnDefIsEnabled") ) {
                final Object value = values.remove("SitnDefIsEnabled");
                if( (value == null) || (!value.equals(getSitnDefIsEnabled())) ) {
                    setSitnDefIsEnabled(((Boolean) value));
                }
            }
            if( values.containsKey("SitnDefDataContextIsEnabled") ) {
                final Object value = values.remove("SitnDefDataContextIsEnabled");
                if( (value == null) || (!value.equals(getSitnDefDataContextIsEnabled())) ) {
                    setSitnDefDataContextIsEnabled(((Boolean) value));
                }
            }
            if( values.containsKey("SitnDefAutomationIsEnabled") ) {
                final Object value = values.remove("SitnDefAutomationIsEnabled");
                if( (value == null) || (!value.equals(getSitnDefAutomationIsEnabled())) ) {
                    setSitnDefAutomationIsEnabled(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_SituationTypeText") ) {
                final Object value = (values).remove("to_SituationTypeText");
                if( value instanceof Iterable ) {
                    if( toSituationTypeText == null ) {
                        toSituationTypeText = Lists.newArrayList();
                    } else {
                        toSituationTypeText = Lists.newArrayList(toSituationTypeText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SituationTypeText entity;
                        if( toSituationTypeText.size() > i ) {
                            entity = toSituationTypeText.get(i);
                        } else {
                            entity = new SituationTypeText();
                            toSituationTypeText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SituationTemplate") ) {
                final Object value = (values).remove("to_SituationTemplate");
                if( value instanceof Map ) {
                    if( toSituationTemplate == null ) {
                        toSituationTemplate = new SituationTemplate();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSituationTemplate.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SituationTypeField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SituationTypeField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SituationTypeField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SituationTypeField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSituationTypeService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSituationTypeText != null ) {
            (values).put("to_SituationTypeText", toSituationTypeText);
        }
        if( toSituationTemplate != null ) {
            (values).put("to_SituationTemplate", toSituationTemplate);
        }
        return values;
    }

    /**
     * Fetches the <b>SituationTypeText</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_SituationTypeText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SituationTypeText</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SituationTypeText> fetchSituationTypeText()
    {
        return fetchFieldAsList("to_SituationTypeText", SituationTypeText.class);
    }

    /**
     * Retrieval of associated <b>SituationTypeText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_SituationTypeText</b>.
     * <p>
     * If the navigation property <b>to_SituationTypeText</b> of a queried <b>SituationType</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SituationTypeText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SituationTypeText> getSituationTypeTextOrFetch()
    {
        if( toSituationTypeText == null ) {
            toSituationTypeText = fetchSituationTypeText();
        }
        return toSituationTypeText;
    }

    /**
     * Retrieval of associated <b>SituationTypeText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_SituationTypeText</b>.
     * <p>
     * If the navigation property for an entity <b>SituationType</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SituationTypeText</b> is already loaded, the result will
     *         contain the <b>SituationTypeText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SituationTypeText>> getSituationTypeTextIfPresent()
    {
        return Option.of(toSituationTypeText);
    }

    /**
     * Overwrites the list of associated <b>SituationTypeText</b> entities for the loaded navigation property
     * <b>to_SituationTypeText</b>.
     * <p>
     * If the navigation property <b>to_SituationTypeText</b> of a queried <b>SituationType</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SituationTypeText</b> entities.
     */
    public void setSituationTypeText( @Nonnull final List<SituationTypeText> value )
    {
        if( toSituationTypeText == null ) {
            toSituationTypeText = Lists.newArrayList();
        }
        toSituationTypeText.clear();
        toSituationTypeText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SituationTypeText</b> entities. This corresponds to the OData
     * navigation property <b>to_SituationTypeText</b>.
     * <p>
     * If the navigation property <b>to_SituationTypeText</b> of a queried <b>SituationType</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SituationTypeText</b> entities.
     */
    public void addSituationTypeText( SituationTypeText... entity )
    {
        if( toSituationTypeText == null ) {
            toSituationTypeText = Lists.newArrayList();
        }
        toSituationTypeText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SituationTemplate</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_SituationTemplate</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SituationTemplate</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SituationTemplate fetchSituationTemplate()
    {
        return fetchFieldAsSingle("to_SituationTemplate", SituationTemplate.class);
    }

    /**
     * Retrieval of associated <b>SituationTemplate</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SituationTemplate</b>.
     * <p>
     * If the navigation property <b>to_SituationTemplate</b> of a queried <b>SituationType</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SituationTemplate</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SituationTemplate getSituationTemplateOrFetch()
    {
        if( toSituationTemplate == null ) {
            toSituationTemplate = fetchSituationTemplate();
        }
        return toSituationTemplate;
    }

    /**
     * Retrieval of associated <b>SituationTemplate</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SituationTemplate</b>.
     * <p>
     * If the navigation property for an entity <b>SituationType</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SituationTemplate</b> is already loaded, the result will
     *         contain the <b>SituationTemplate</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SituationTemplate> getSituationTemplateIfPresent()
    {
        return Option.of(toSituationTemplate);
    }

    /**
     * Overwrites the associated <b>SituationTemplate</b> entity for the loaded navigation property
     * <b>to_SituationTemplate</b>.
     *
     * @param value
     *            New <b>SituationTemplate</b> entity.
     */
    public void setSituationTemplate( final SituationTemplate value )
    {
        toSituationTemplate = value;
    }

    /**
     * Helper class to allow for fluent creation of SituationType instances.
     *
     */
    public final static class SituationTypeBuilder
    {

        private List<SituationTypeText> toSituationTypeText = Lists.newArrayList();
        private SituationTemplate toSituationTemplate;

        private SituationType.SituationTypeBuilder toSituationTypeText( final List<SituationTypeText> value )
        {
            toSituationTypeText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SituationTypeText</b> for <b>SituationType</b> to multiple
         * <b>SituationTypeText</b>.
         *
         * @param value
         *            The SituationTypeTexts to build this SituationType with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SituationType.SituationTypeBuilder situationTypeText( SituationTypeText... value )
        {
            return toSituationTypeText(Lists.newArrayList(value));
        }

        private SituationType.SituationTypeBuilder toSituationTemplate( final SituationTemplate value )
        {
            toSituationTemplate = value;
            return this;
        }

        /**
         * Navigation property <b>to_SituationTemplate</b> for <b>SituationType</b> to single <b>SituationTemplate</b>.
         *
         * @param value
         *            The SituationTemplate to build this SituationType with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SituationType.SituationTypeBuilder situationTemplate( final SituationTemplate value )
        {
            return toSituationTemplate(value);
        }

    }

}
