/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.selectable.SituationTypeSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationType SituationType} entity
 * using key fields. This fluent helper allows methods which modify the underlying query to be called before executing
 * the query itself.
 *
 */
public class SituationTypeByKeyFluentHelper
    extends
    FluentHelperByKey<SituationTypeByKeyFluentHelper, SituationType, SituationTypeSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationType SituationType}
     * entity with the provided key field values. To perform execution, call the {@link #executeRequest executeRequest}
     * method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SituationType}
     * @param sitnDefinitionID
     *            Situation Type ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 32
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code SituationType}
     */
    public SituationTypeByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String sitnDefinitionID )
    {
        super(servicePath, entityCollection);
        this.key.put("SitnDefinitionID", sitnDefinitionID);
    }

    @Override
    @Nonnull
    protected Class<SituationType> getEntityClass()
    {
        return SituationType.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
