/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link BusinessSituationTypeServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSituationTypeService BusinessSituationTypeService}.
 *
 */
public class DefaultBusinessSituationTypeServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<BusinessSituationTypeServiceBatch, BusinessSituationTypeServiceBatchChangeSet>
    implements
    BusinessSituationTypeServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSituationTypeService service;

    @SuppressWarnings( "deprecation" )
    DefaultBusinessSituationTypeServiceBatchChangeSet(
        @Nonnull final DefaultBusinessSituationTypeServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSituationTypeService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultBusinessSituationTypeServiceBatchChangeSet getThis()
    {
        return this;
    }

}
