/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationActionText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationActionText
 * SituationActionText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.field.SituationActionTextField
 * SituationActionTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.link.SituationActionTextLink
 * SituationActionTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationActionText#SITN_ACTION_ID
 * SITN_ACTION_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationActionText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationActionText#SITN_ACTION_NAME
 * SITN_ACTION_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationActionText#SITN_ACTION_DESCRIPTION
 * SITN_ACTION_DESCRIPTION}</li>
 * </ul>
 *
 */
public interface SituationActionTextSelectable extends EntitySelectable<SituationActionText>
{

}
