/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTemplate;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTemplate
 * SituationTemplate}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.field.SituationTemplateField
 * SituationTemplateField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.link.SituationTemplateLink
 * SituationTemplateLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTemplate#SITN_DEF_TEMPLATE_ID
 * SITN_DEF_TEMPLATE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTemplate#SITN_DEF_DATA_CONTEXT_IS_ENABLED
 * SITN_DEF_DATA_CONTEXT_IS_ENABLED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTemplate#TO_SITUATION_ACTION
 * TO_SITUATION_ACTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTemplate#TO_SITUATION_TEMPLATE_TEXT
 * TO_SITUATION_TEMPLATE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTemplate#TO_SITUATION_TYPE
 * TO_SITUATION_TYPE}</li>
 * </ul>
 *
 */
public interface SituationTemplateSelectable extends EntitySelectable<SituationTemplate>
{

}
