/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTemplateText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTemplateText
 * SituationTemplateText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.field.SituationTemplateTextField
 * SituationTemplateTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.link.SituationTemplateTextLink
 * SituationTemplateTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTemplateText#SITN_DEF_TEMPLATE_ID
 * SITN_DEF_TEMPLATE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTemplateText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTemplateText#SITN_DEF_NAME
 * SITN_DEF_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTemplateText#SITN_DEF_DESCRIPTION
 * SITN_DEF_DESCRIPTION}</li>
 * </ul>
 *
 */
public interface SituationTemplateTextSelectable extends EntitySelectable<SituationTemplateText>
{

}
