/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTypeText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTypeText
 * SituationTypeText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.field.SituationTypeTextField
 * SituationTypeTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.link.SituationTypeTextLink
 * SituationTypeTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTypeText#SITN_DEFINITION_ID
 * SITN_DEFINITION_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTypeText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTypeText#SITN_DEF_NAME
 * SITN_DEF_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTypeText#SITN_DEF_DESCRIPTION
 * SITN_DEF_DESCRIPTION}</li>
 * </ul>
 *
 */
public interface SituationTypeTextSelectable extends EntitySelectable<SituationTypeText>
{

}
