/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.field.SituationActionField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.link.SituationActionLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.selectable.SituationActionSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Situation Action
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SituationActionType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SituationAction extends VdmEntity<SituationAction>
{

    /**
     * Selector for all available fields of SituationAction.
     *
     */
    public final static SituationActionSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>SitnDefTemplateID</b>
     * </p>
     *
     * @return Situation Standard Template ID
     */
    @Key
    @SerializedName( "SitnDefTemplateID" )
    @JsonProperty( "SitnDefTemplateID" )
    @Nullable
    @ODataField( odataName = "SitnDefTemplateID" )
    private String sitnDefTemplateID;
    /**
     * Use with available fluent helpers to apply the <b>SitnDefTemplateID</b> field to query operations.
     *
     */
    public final static SituationActionField<String> SITN_DEF_TEMPLATE_ID =
        new SituationActionField<String>("SitnDefTemplateID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>SitnActionID</b>
     * </p>
     *
     * @return Action ID
     */
    @Key
    @SerializedName( "SitnActionID" )
    @JsonProperty( "SitnActionID" )
    @Nullable
    @ODataField( odataName = "SitnActionID" )
    private String sitnActionID;
    /**
     * Use with available fluent helpers to apply the <b>SitnActionID</b> field to query operations.
     *
     */
    public final static SituationActionField<String> SITN_ACTION_ID = new SituationActionField<String>("SitnActionID");
    /**
     * Navigation property <b>to_SituationActionText</b> for <b>SituationAction</b> to multiple
     * <b>SituationActionText</b>.
     *
     */
    @SerializedName( "to_SituationActionText" )
    @JsonProperty( "to_SituationActionText" )
    @ODataField( odataName = "to_SituationActionText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SituationActionText> toSituationActionText;
    /**
     * Use with available fluent helpers to apply the <b>to_SituationActionText</b> navigation property to query
     * operations.
     *
     */
    public final static SituationActionLink<SituationActionText> TO_SITUATION_ACTION_TEXT =
        new SituationActionLink<SituationActionText>("to_SituationActionText");

    @Nonnull
    @Override
    public Class<SituationAction> getType()
    {
        return SituationAction.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>SitnDefTemplateID</b>
     * </p>
     *
     * @param sitnDefTemplateID
     *            Situation Standard Template ID
     */
    public void setSitnDefTemplateID( @Nullable final String sitnDefTemplateID )
    {
        rememberChangedField("SitnDefTemplateID", this.sitnDefTemplateID);
        this.sitnDefTemplateID = sitnDefTemplateID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>SitnActionID</b>
     * </p>
     *
     * @param sitnActionID
     *            Action ID
     */
    public void setSitnActionID( @Nullable final String sitnActionID )
    {
        rememberChangedField("SitnActionID", this.sitnActionID);
        this.sitnActionID = sitnActionID;
    }

    @Override
    protected String getEntityCollection()
    {
        return "SituationAction";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SitnDefTemplateID", getSitnDefTemplateID());
        result.put("SitnActionID", getSitnActionID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SitnDefTemplateID", getSitnDefTemplateID());
        values.put("SitnActionID", getSitnActionID());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SitnDefTemplateID") ) {
                final Object value = values.remove("SitnDefTemplateID");
                if( (value == null) || (!value.equals(getSitnDefTemplateID())) ) {
                    setSitnDefTemplateID(((String) value));
                }
            }
            if( values.containsKey("SitnActionID") ) {
                final Object value = values.remove("SitnActionID");
                if( (value == null) || (!value.equals(getSitnActionID())) ) {
                    setSitnActionID(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_SituationActionText") ) {
                final Object value = (values).remove("to_SituationActionText");
                if( value instanceof Iterable ) {
                    if( toSituationActionText == null ) {
                        toSituationActionText = Lists.newArrayList();
                    } else {
                        toSituationActionText = Lists.newArrayList(toSituationActionText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SituationActionText entity;
                        if( toSituationActionText.size() > i ) {
                            entity = toSituationActionText.get(i);
                        } else {
                            entity = new SituationActionText();
                            toSituationActionText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SituationActionField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SituationActionField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SituationActionField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SituationActionField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSituationTypeV2Service.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSituationActionText != null ) {
            (values).put("to_SituationActionText", toSituationActionText);
        }
        return values;
    }

    /**
     * Fetches the <b>SituationActionText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_SituationActionText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SituationActionText</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SituationActionText> fetchSituationActionText()
    {
        return fetchFieldAsList("to_SituationActionText", SituationActionText.class);
    }

    /**
     * Retrieval of associated <b>SituationActionText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SituationActionText</b>.
     * <p>
     * If the navigation property <b>to_SituationActionText</b> of a queried <b>SituationAction</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SituationActionText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SituationActionText> getSituationActionTextOrFetch()
    {
        if( toSituationActionText == null ) {
            toSituationActionText = fetchSituationActionText();
        }
        return toSituationActionText;
    }

    /**
     * Retrieval of associated <b>SituationActionText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SituationActionText</b>.
     * <p>
     * If the navigation property for an entity <b>SituationAction</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SituationActionText</b> is already loaded, the result
     *         will contain the <b>SituationActionText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SituationActionText>> getSituationActionTextIfPresent()
    {
        return Option.of(toSituationActionText);
    }

    /**
     * Overwrites the list of associated <b>SituationActionText</b> entities for the loaded navigation property
     * <b>to_SituationActionText</b>.
     * <p>
     * If the navigation property <b>to_SituationActionText</b> of a queried <b>SituationAction</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SituationActionText</b> entities.
     */
    public void setSituationActionText( @Nonnull final List<SituationActionText> value )
    {
        if( toSituationActionText == null ) {
            toSituationActionText = Lists.newArrayList();
        }
        toSituationActionText.clear();
        toSituationActionText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SituationActionText</b> entities. This corresponds to the OData
     * navigation property <b>to_SituationActionText</b>.
     * <p>
     * If the navigation property <b>to_SituationActionText</b> of a queried <b>SituationAction</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SituationActionText</b> entities.
     */
    public void addSituationActionText( SituationActionText... entity )
    {
        if( toSituationActionText == null ) {
            toSituationActionText = Lists.newArrayList();
        }
        toSituationActionText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of SituationAction instances.
     *
     */
    public final static class SituationActionBuilder
    {

        private List<SituationActionText> toSituationActionText = Lists.newArrayList();

        private SituationAction.SituationActionBuilder toSituationActionText( final List<SituationActionText> value )
        {
            toSituationActionText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SituationActionText</b> for <b>SituationAction</b> to multiple
         * <b>SituationActionText</b>.
         *
         * @param value
         *            The SituationActionTexts to build this SituationAction with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SituationAction.SituationActionBuilder situationActionText( SituationActionText... value )
        {
            return toSituationActionText(Lists.newArrayList(value));
        }

    }

}
