/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.field.SituationActionTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.selectable.SituationActionTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Situation Action for Sitn Tmpl - Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SituationActionTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SituationActionText extends VdmEntity<SituationActionText>
{

    /**
     * Selector for all available fields of SituationActionText.
     *
     */
    public final static SituationActionTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>SitnActionID</b>
     * </p>
     *
     * @return Action ID
     */
    @Key
    @SerializedName( "SitnActionID" )
    @JsonProperty( "SitnActionID" )
    @Nullable
    @ODataField( odataName = "SitnActionID" )
    private String sitnActionID;
    /**
     * Use with available fluent helpers to apply the <b>SitnActionID</b> field to query operations.
     *
     */
    public final static SituationActionTextField<String> SITN_ACTION_ID =
        new SituationActionTextField<String>("SitnActionID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static SituationActionTextField<String> LANGUAGE = new SituationActionTextField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SitnActionName</b>
     * </p>
     *
     * @return Action Name
     */
    @SerializedName( "SitnActionName" )
    @JsonProperty( "SitnActionName" )
    @Nullable
    @ODataField( odataName = "SitnActionName" )
    private String sitnActionName;
    /**
     * Use with available fluent helpers to apply the <b>SitnActionName</b> field to query operations.
     *
     */
    public final static SituationActionTextField<String> SITN_ACTION_NAME =
        new SituationActionTextField<String>("SitnActionName");
    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>SitnActionDescription</b>
     * </p>
     *
     * @return Description of Action
     */
    @SerializedName( "SitnActionDescription" )
    @JsonProperty( "SitnActionDescription" )
    @Nullable
    @ODataField( odataName = "SitnActionDescription" )
    private String sitnActionDescription;
    /**
     * Use with available fluent helpers to apply the <b>SitnActionDescription</b> field to query operations.
     *
     */
    public final static SituationActionTextField<String> SITN_ACTION_DESCRIPTION =
        new SituationActionTextField<String>("SitnActionDescription");

    @Nonnull
    @Override
    public Class<SituationActionText> getType()
    {
        return SituationActionText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>SitnActionID</b>
     * </p>
     *
     * @param sitnActionID
     *            Action ID
     */
    public void setSitnActionID( @Nullable final String sitnActionID )
    {
        rememberChangedField("SitnActionID", this.sitnActionID);
        this.sitnActionID = sitnActionID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SitnActionName</b>
     * </p>
     *
     * @param sitnActionName
     *            Action Name
     */
    public void setSitnActionName( @Nullable final String sitnActionName )
    {
        rememberChangedField("SitnActionName", this.sitnActionName);
        this.sitnActionName = sitnActionName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>SitnActionDescription</b>
     * </p>
     *
     * @param sitnActionDescription
     *            Description of Action
     */
    public void setSitnActionDescription( @Nullable final String sitnActionDescription )
    {
        rememberChangedField("SitnActionDescription", this.sitnActionDescription);
        this.sitnActionDescription = sitnActionDescription;
    }

    @Override
    protected String getEntityCollection()
    {
        return "SituationActionText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SitnActionID", getSitnActionID());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SitnActionID", getSitnActionID());
        values.put("Language", getLanguage());
        values.put("SitnActionName", getSitnActionName());
        values.put("SitnActionDescription", getSitnActionDescription());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SitnActionID") ) {
                final Object value = values.remove("SitnActionID");
                if( (value == null) || (!value.equals(getSitnActionID())) ) {
                    setSitnActionID(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("SitnActionName") ) {
                final Object value = values.remove("SitnActionName");
                if( (value == null) || (!value.equals(getSitnActionName())) ) {
                    setSitnActionName(((String) value));
                }
            }
            if( values.containsKey("SitnActionDescription") ) {
                final Object value = values.remove("SitnActionDescription");
                if( (value == null) || (!value.equals(getSitnActionDescription())) ) {
                    setSitnActionDescription(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SituationActionTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SituationActionTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SituationActionTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SituationActionTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSituationTypeV2Service.DEFAULT_SERVICE_PATH);
    }

}
