/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.selectable.SituationActionTextSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationActionText
 * SituationActionText} entity using key fields. This fluent helper allows methods which modify the underlying query to
 * be called before executing the query itself.
 *
 */
public class SituationActionTextByKeyFluentHelper
    extends
    FluentHelperByKey<SituationActionTextByKeyFluentHelper, SituationActionText, SituationActionTextSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationActionText
     * SituationActionText} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SituationActionText}
     * @param servicePath
     *            Service path to be used to fetch a single {@code SituationActionText}
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param sitnActionID
     *            Action ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 32
     *            </p>
     */
    public SituationActionTextByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String sitnActionID,
        final String language )
    {
        super(servicePath, entityCollection);
        this.key.put("SitnActionID", sitnActionID);
        this.key.put("Language", language);
    }

    @Override
    @Nonnull
    protected Class<SituationActionText> getEntityClass()
    {
        return SituationActionText.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
