/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.field.SituationContextDefSchemaField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.link.SituationContextDefSchemaLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.selectable.SituationContextDefSchemaSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Schema for Data Context Definition
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SituationContextDefSchema_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SituationContextDefSchema extends VdmEntity<SituationContextDefSchema>
{

    /**
     * Selector for all available fields of SituationContextDefSchema.
     *
     */
    public final static SituationContextDefSchemaSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>SitnDefTemplateID</b>
     * </p>
     *
     * @return Situation Standard Template ID
     */
    @Key
    @SerializedName( "SitnDefTemplateID" )
    @JsonProperty( "SitnDefTemplateID" )
    @Nullable
    @ODataField( odataName = "SitnDefTemplateID" )
    private String sitnDefTemplateID;
    /**
     * Use with available fluent helpers to apply the <b>SitnDefTemplateID</b> field to query operations.
     *
     */
    public final static SituationContextDefSchemaField<String> SITN_DEF_TEMPLATE_ID =
        new SituationContextDefSchemaField<String>("SitnDefTemplateID");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SitnDataCntxtVersion</b>
     * </p>
     *
     * @return Version of Data Context Definition
     */
    @Key
    @SerializedName( "SitnDataCntxtVersion" )
    @JsonProperty( "SitnDataCntxtVersion" )
    @Nullable
    @ODataField( odataName = "SitnDataCntxtVersion" )
    private Integer sitnDataCntxtVersion;
    /**
     * Use with available fluent helpers to apply the <b>SitnDataCntxtVersion</b> field to query operations.
     *
     */
    public final static SituationContextDefSchemaField<Integer> SITN_DATA_CNTXT_VERSION =
        new SituationContextDefSchemaField<Integer>("SitnDataCntxtVersion");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SitnDataCntxtFormatVersion</b>
     * </p>
     *
     * @return Context Format Version
     */
    @Key
    @SerializedName( "SitnDataCntxtFormatVersion" )
    @JsonProperty( "SitnDataCntxtFormatVersion" )
    @Nullable
    @ODataField( odataName = "SitnDataCntxtFormatVersion" )
    private Integer sitnDataCntxtFormatVersion;
    /**
     * Use with available fluent helpers to apply the <b>SitnDataCntxtFormatVersion</b> field to query operations.
     *
     */
    public final static SituationContextDefSchemaField<Integer> SITN_DATA_CNTXT_FORMAT_VERSION =
        new SituationContextDefSchemaField<Integer>("SitnDataCntxtFormatVersion");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SitnDataCntxtSchemaVersion</b>
     * </p>
     *
     * @return Schema Version of Data Context Definition
     */
    @Key
    @SerializedName( "SitnDataCntxtSchemaVersion" )
    @JsonProperty( "SitnDataCntxtSchemaVersion" )
    @Nullable
    @ODataField( odataName = "SitnDataCntxtSchemaVersion" )
    private Integer sitnDataCntxtSchemaVersion;
    /**
     * Use with available fluent helpers to apply the <b>SitnDataCntxtSchemaVersion</b> field to query operations.
     *
     */
    public final static SituationContextDefSchemaField<Integer> SITN_DATA_CNTXT_SCHEMA_VERSION =
        new SituationContextDefSchemaField<Integer>("SitnDataCntxtSchemaVersion");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SitnDataCntxtSchema</b>
     * </p>
     *
     * @return Situation Data Context Data
     */
    @SerializedName( "SitnDataCntxtSchema" )
    @JsonProperty( "SitnDataCntxtSchema" )
    @Nullable
    @ODataField( odataName = "SitnDataCntxtSchema" )
    private String sitnDataCntxtSchema;
    /**
     * Use with available fluent helpers to apply the <b>SitnDataCntxtSchema</b> field to query operations.
     *
     */
    public final static SituationContextDefSchemaField<String> SITN_DATA_CNTXT_SCHEMA =
        new SituationContextDefSchemaField<String>("SitnDataCntxtSchema");
    /**
     * Navigation property <b>to_SituationContextDefText</b> for <b>SituationContextDefSchema</b> to multiple
     * <b>SituationContextDefText</b>.
     *
     */
    @SerializedName( "to_SituationContextDefText" )
    @JsonProperty( "to_SituationContextDefText" )
    @ODataField( odataName = "to_SituationContextDefText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SituationContextDefText> toSituationContextDefText;
    /**
     * Use with available fluent helpers to apply the <b>to_SituationContextDefText</b> navigation property to query
     * operations.
     *
     */
    public final static SituationContextDefSchemaLink<SituationContextDefText> TO_SITUATION_CONTEXT_DEF_TEXT =
        new SituationContextDefSchemaLink<SituationContextDefText>("to_SituationContextDefText");

    @Nonnull
    @Override
    public Class<SituationContextDefSchema> getType()
    {
        return SituationContextDefSchema.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>SitnDefTemplateID</b>
     * </p>
     *
     * @param sitnDefTemplateID
     *            Situation Standard Template ID
     */
    public void setSitnDefTemplateID( @Nullable final String sitnDefTemplateID )
    {
        rememberChangedField("SitnDefTemplateID", this.sitnDefTemplateID);
        this.sitnDefTemplateID = sitnDefTemplateID;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SitnDataCntxtVersion</b>
     * </p>
     *
     * @param sitnDataCntxtVersion
     *            Version of Data Context Definition
     */
    public void setSitnDataCntxtVersion( @Nullable final Integer sitnDataCntxtVersion )
    {
        rememberChangedField("SitnDataCntxtVersion", this.sitnDataCntxtVersion);
        this.sitnDataCntxtVersion = sitnDataCntxtVersion;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SitnDataCntxtFormatVersion</b>
     * </p>
     *
     * @param sitnDataCntxtFormatVersion
     *            Context Format Version
     */
    public void setSitnDataCntxtFormatVersion( @Nullable final Integer sitnDataCntxtFormatVersion )
    {
        rememberChangedField("SitnDataCntxtFormatVersion", this.sitnDataCntxtFormatVersion);
        this.sitnDataCntxtFormatVersion = sitnDataCntxtFormatVersion;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SitnDataCntxtSchemaVersion</b>
     * </p>
     *
     * @param sitnDataCntxtSchemaVersion
     *            Schema Version of Data Context Definition
     */
    public void setSitnDataCntxtSchemaVersion( @Nullable final Integer sitnDataCntxtSchemaVersion )
    {
        rememberChangedField("SitnDataCntxtSchemaVersion", this.sitnDataCntxtSchemaVersion);
        this.sitnDataCntxtSchemaVersion = sitnDataCntxtSchemaVersion;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SitnDataCntxtSchema</b>
     * </p>
     *
     * @param sitnDataCntxtSchema
     *            Situation Data Context Data
     */
    public void setSitnDataCntxtSchema( @Nullable final String sitnDataCntxtSchema )
    {
        rememberChangedField("SitnDataCntxtSchema", this.sitnDataCntxtSchema);
        this.sitnDataCntxtSchema = sitnDataCntxtSchema;
    }

    @Override
    protected String getEntityCollection()
    {
        return "SituationContextDefSchema";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SitnDefTemplateID", getSitnDefTemplateID());
        result.put("SitnDataCntxtVersion", getSitnDataCntxtVersion());
        result.put("SitnDataCntxtFormatVersion", getSitnDataCntxtFormatVersion());
        result.put("SitnDataCntxtSchemaVersion", getSitnDataCntxtSchemaVersion());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SitnDefTemplateID", getSitnDefTemplateID());
        values.put("SitnDataCntxtVersion", getSitnDataCntxtVersion());
        values.put("SitnDataCntxtFormatVersion", getSitnDataCntxtFormatVersion());
        values.put("SitnDataCntxtSchemaVersion", getSitnDataCntxtSchemaVersion());
        values.put("SitnDataCntxtSchema", getSitnDataCntxtSchema());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SitnDefTemplateID") ) {
                final Object value = values.remove("SitnDefTemplateID");
                if( (value == null) || (!value.equals(getSitnDefTemplateID())) ) {
                    setSitnDefTemplateID(((String) value));
                }
            }
            if( values.containsKey("SitnDataCntxtVersion") ) {
                final Object value = values.remove("SitnDataCntxtVersion");
                if( (value == null) || (!value.equals(getSitnDataCntxtVersion())) ) {
                    setSitnDataCntxtVersion(((Integer) value));
                }
            }
            if( values.containsKey("SitnDataCntxtFormatVersion") ) {
                final Object value = values.remove("SitnDataCntxtFormatVersion");
                if( (value == null) || (!value.equals(getSitnDataCntxtFormatVersion())) ) {
                    setSitnDataCntxtFormatVersion(((Integer) value));
                }
            }
            if( values.containsKey("SitnDataCntxtSchemaVersion") ) {
                final Object value = values.remove("SitnDataCntxtSchemaVersion");
                if( (value == null) || (!value.equals(getSitnDataCntxtSchemaVersion())) ) {
                    setSitnDataCntxtSchemaVersion(((Integer) value));
                }
            }
            if( values.containsKey("SitnDataCntxtSchema") ) {
                final Object value = values.remove("SitnDataCntxtSchema");
                if( (value == null) || (!value.equals(getSitnDataCntxtSchema())) ) {
                    setSitnDataCntxtSchema(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_SituationContextDefText") ) {
                final Object value = (values).remove("to_SituationContextDefText");
                if( value instanceof Iterable ) {
                    if( toSituationContextDefText == null ) {
                        toSituationContextDefText = Lists.newArrayList();
                    } else {
                        toSituationContextDefText = Lists.newArrayList(toSituationContextDefText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SituationContextDefText entity;
                        if( toSituationContextDefText.size() > i ) {
                            entity = toSituationContextDefText.get(i);
                        } else {
                            entity = new SituationContextDefText();
                            toSituationContextDefText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SituationContextDefSchemaField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SituationContextDefSchemaField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SituationContextDefSchemaField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SituationContextDefSchemaField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSituationTypeV2Service.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSituationContextDefText != null ) {
            (values).put("to_SituationContextDefText", toSituationContextDefText);
        }
        return values;
    }

    /**
     * Fetches the <b>SituationContextDefText</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_SituationContextDefText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SituationContextDefText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SituationContextDefText> fetchSituationContextDefText()
    {
        return fetchFieldAsList("to_SituationContextDefText", SituationContextDefText.class);
    }

    /**
     * Retrieval of associated <b>SituationContextDefText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SituationContextDefText</b>.
     * <p>
     * If the navigation property <b>to_SituationContextDefText</b> of a queried <b>SituationContextDefSchema</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SituationContextDefText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SituationContextDefText> getSituationContextDefTextOrFetch()
    {
        if( toSituationContextDefText == null ) {
            toSituationContextDefText = fetchSituationContextDefText();
        }
        return toSituationContextDefText;
    }

    /**
     * Retrieval of associated <b>SituationContextDefText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SituationContextDefText</b>.
     * <p>
     * If the navigation property for an entity <b>SituationContextDefSchema</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SituationContextDefText</b> is already loaded, the
     *         result will contain the <b>SituationContextDefText</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SituationContextDefText>> getSituationContextDefTextIfPresent()
    {
        return Option.of(toSituationContextDefText);
    }

    /**
     * Overwrites the list of associated <b>SituationContextDefText</b> entities for the loaded navigation property
     * <b>to_SituationContextDefText</b>.
     * <p>
     * If the navigation property <b>to_SituationContextDefText</b> of a queried <b>SituationContextDefSchema</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SituationContextDefText</b> entities.
     */
    public void setSituationContextDefText( @Nonnull final List<SituationContextDefText> value )
    {
        if( toSituationContextDefText == null ) {
            toSituationContextDefText = Lists.newArrayList();
        }
        toSituationContextDefText.clear();
        toSituationContextDefText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SituationContextDefText</b> entities. This corresponds to the OData
     * navigation property <b>to_SituationContextDefText</b>.
     * <p>
     * If the navigation property <b>to_SituationContextDefText</b> of a queried <b>SituationContextDefSchema</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SituationContextDefText</b> entities.
     */
    public void addSituationContextDefText( SituationContextDefText... entity )
    {
        if( toSituationContextDefText == null ) {
            toSituationContextDefText = Lists.newArrayList();
        }
        toSituationContextDefText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of SituationContextDefSchema instances.
     *
     */
    public final static class SituationContextDefSchemaBuilder
    {

        private List<SituationContextDefText> toSituationContextDefText = Lists.newArrayList();

        private SituationContextDefSchema.SituationContextDefSchemaBuilder toSituationContextDefText(
            final List<SituationContextDefText> value )
        {
            toSituationContextDefText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SituationContextDefText</b> for <b>SituationContextDefSchema</b> to multiple
         * <b>SituationContextDefText</b>.
         *
         * @param value
         *            The SituationContextDefTexts to build this SituationContextDefSchema with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SituationContextDefSchema.SituationContextDefSchemaBuilder situationContextDefText(
            SituationContextDefText... value )
        {
            return toSituationContextDefText(Lists.newArrayList(value));
        }

    }

}
