/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.selectable.SituationContextDefSchemaSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationContextDefSchema
 * SituationContextDefSchema} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class SituationContextDefSchemaByKeyFluentHelper
    extends
    FluentHelperByKey<SituationContextDefSchemaByKeyFluentHelper, SituationContextDefSchema, SituationContextDefSchemaSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationContextDefSchema
     * SituationContextDefSchema} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param sitnDefTemplateID
     *            Situation Standard Template ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 32
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SituationContextDefSchema}
     * @param sitnDataCntxtVersion
     *            Version of Data Context Definition
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code SituationContextDefSchema}
     * @param sitnDataCntxtFormatVersion
     *            Context Format Version
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param sitnDataCntxtSchemaVersion
     *            Schema Version of Data Context Definition
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     */
    public SituationContextDefSchemaByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String sitnDefTemplateID,
        final Integer sitnDataCntxtVersion,
        final Integer sitnDataCntxtFormatVersion,
        final Integer sitnDataCntxtSchemaVersion )
    {
        super(servicePath, entityCollection);
        this.key.put("SitnDefTemplateID", sitnDefTemplateID);
        this.key.put("SitnDataCntxtVersion", sitnDataCntxtVersion);
        this.key.put("SitnDataCntxtFormatVersion", sitnDataCntxtFormatVersion);
        this.key.put("SitnDataCntxtSchemaVersion", sitnDataCntxtSchemaVersion);
    }

    @Override
    @Nonnull
    protected Class<SituationContextDefSchema> getEntityClass()
    {
        return SituationContextDefSchema.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
