/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.field.SituationContextDefTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.selectable.SituationContextDefTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Schema for Data Context Definition - Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SituationContextDefText_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SituationContextDefText extends VdmEntity<SituationContextDefText>
{

    /**
     * Selector for all available fields of SituationContextDefText.
     *
     */
    public final static SituationContextDefTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>SitnDefTemplateID</b>
     * </p>
     *
     * @return Situation Standard Template ID
     */
    @Key
    @SerializedName( "SitnDefTemplateID" )
    @JsonProperty( "SitnDefTemplateID" )
    @Nullable
    @ODataField( odataName = "SitnDefTemplateID" )
    private String sitnDefTemplateID;
    /**
     * Use with available fluent helpers to apply the <b>SitnDefTemplateID</b> field to query operations.
     *
     */
    public final static SituationContextDefTextField<String> SITN_DEF_TEMPLATE_ID =
        new SituationContextDefTextField<String>("SitnDefTemplateID");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SitnDataCntxtVersion</b>
     * </p>
     *
     * @return Version of Data Context Definition
     */
    @Key
    @SerializedName( "SitnDataCntxtVersion" )
    @JsonProperty( "SitnDataCntxtVersion" )
    @Nullable
    @ODataField( odataName = "SitnDataCntxtVersion" )
    private Integer sitnDataCntxtVersion;
    /**
     * Use with available fluent helpers to apply the <b>SitnDataCntxtVersion</b> field to query operations.
     *
     */
    public final static SituationContextDefTextField<Integer> SITN_DATA_CNTXT_VERSION =
        new SituationContextDefTextField<Integer>("SitnDataCntxtVersion");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SitnDataCntxtFormatVersion</b>
     * </p>
     *
     * @return Context Format Version
     */
    @Key
    @SerializedName( "SitnDataCntxtFormatVersion" )
    @JsonProperty( "SitnDataCntxtFormatVersion" )
    @Nullable
    @ODataField( odataName = "SitnDataCntxtFormatVersion" )
    private Integer sitnDataCntxtFormatVersion;
    /**
     * Use with available fluent helpers to apply the <b>SitnDataCntxtFormatVersion</b> field to query operations.
     *
     */
    public final static SituationContextDefTextField<Integer> SITN_DATA_CNTXT_FORMAT_VERSION =
        new SituationContextDefTextField<Integer>("SitnDataCntxtFormatVersion");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SitnDataCntxtSchemaVersion</b>
     * </p>
     *
     * @return Schema Version of Data Context Definition
     */
    @Key
    @SerializedName( "SitnDataCntxtSchemaVersion" )
    @JsonProperty( "SitnDataCntxtSchemaVersion" )
    @Nullable
    @ODataField( odataName = "SitnDataCntxtSchemaVersion" )
    private Integer sitnDataCntxtSchemaVersion;
    /**
     * Use with available fluent helpers to apply the <b>SitnDataCntxtSchemaVersion</b> field to query operations.
     *
     */
    public final static SituationContextDefTextField<Integer> SITN_DATA_CNTXT_SCHEMA_VERSION =
        new SituationContextDefTextField<Integer>("SitnDataCntxtSchemaVersion");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static SituationContextDefTextField<String> LANGUAGE =
        new SituationContextDefTextField<String>("Language");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SitnDataCntxtText</b>
     * </p>
     *
     * @return Situation Data Context Data
     */
    @SerializedName( "SitnDataCntxtText" )
    @JsonProperty( "SitnDataCntxtText" )
    @Nullable
    @ODataField( odataName = "SitnDataCntxtText" )
    private String sitnDataCntxtText;
    /**
     * Use with available fluent helpers to apply the <b>SitnDataCntxtText</b> field to query operations.
     *
     */
    public final static SituationContextDefTextField<String> SITN_DATA_CNTXT_TEXT =
        new SituationContextDefTextField<String>("SitnDataCntxtText");

    @Nonnull
    @Override
    public Class<SituationContextDefText> getType()
    {
        return SituationContextDefText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>SitnDefTemplateID</b>
     * </p>
     *
     * @param sitnDefTemplateID
     *            Situation Standard Template ID
     */
    public void setSitnDefTemplateID( @Nullable final String sitnDefTemplateID )
    {
        rememberChangedField("SitnDefTemplateID", this.sitnDefTemplateID);
        this.sitnDefTemplateID = sitnDefTemplateID;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SitnDataCntxtVersion</b>
     * </p>
     *
     * @param sitnDataCntxtVersion
     *            Version of Data Context Definition
     */
    public void setSitnDataCntxtVersion( @Nullable final Integer sitnDataCntxtVersion )
    {
        rememberChangedField("SitnDataCntxtVersion", this.sitnDataCntxtVersion);
        this.sitnDataCntxtVersion = sitnDataCntxtVersion;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SitnDataCntxtFormatVersion</b>
     * </p>
     *
     * @param sitnDataCntxtFormatVersion
     *            Context Format Version
     */
    public void setSitnDataCntxtFormatVersion( @Nullable final Integer sitnDataCntxtFormatVersion )
    {
        rememberChangedField("SitnDataCntxtFormatVersion", this.sitnDataCntxtFormatVersion);
        this.sitnDataCntxtFormatVersion = sitnDataCntxtFormatVersion;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SitnDataCntxtSchemaVersion</b>
     * </p>
     *
     * @param sitnDataCntxtSchemaVersion
     *            Schema Version of Data Context Definition
     */
    public void setSitnDataCntxtSchemaVersion( @Nullable final Integer sitnDataCntxtSchemaVersion )
    {
        rememberChangedField("SitnDataCntxtSchemaVersion", this.sitnDataCntxtSchemaVersion);
        this.sitnDataCntxtSchemaVersion = sitnDataCntxtSchemaVersion;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SitnDataCntxtText</b>
     * </p>
     *
     * @param sitnDataCntxtText
     *            Situation Data Context Data
     */
    public void setSitnDataCntxtText( @Nullable final String sitnDataCntxtText )
    {
        rememberChangedField("SitnDataCntxtText", this.sitnDataCntxtText);
        this.sitnDataCntxtText = sitnDataCntxtText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "SituationContextDefText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SitnDefTemplateID", getSitnDefTemplateID());
        result.put("SitnDataCntxtVersion", getSitnDataCntxtVersion());
        result.put("SitnDataCntxtFormatVersion", getSitnDataCntxtFormatVersion());
        result.put("SitnDataCntxtSchemaVersion", getSitnDataCntxtSchemaVersion());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SitnDefTemplateID", getSitnDefTemplateID());
        values.put("SitnDataCntxtVersion", getSitnDataCntxtVersion());
        values.put("SitnDataCntxtFormatVersion", getSitnDataCntxtFormatVersion());
        values.put("SitnDataCntxtSchemaVersion", getSitnDataCntxtSchemaVersion());
        values.put("Language", getLanguage());
        values.put("SitnDataCntxtText", getSitnDataCntxtText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SitnDefTemplateID") ) {
                final Object value = values.remove("SitnDefTemplateID");
                if( (value == null) || (!value.equals(getSitnDefTemplateID())) ) {
                    setSitnDefTemplateID(((String) value));
                }
            }
            if( values.containsKey("SitnDataCntxtVersion") ) {
                final Object value = values.remove("SitnDataCntxtVersion");
                if( (value == null) || (!value.equals(getSitnDataCntxtVersion())) ) {
                    setSitnDataCntxtVersion(((Integer) value));
                }
            }
            if( values.containsKey("SitnDataCntxtFormatVersion") ) {
                final Object value = values.remove("SitnDataCntxtFormatVersion");
                if( (value == null) || (!value.equals(getSitnDataCntxtFormatVersion())) ) {
                    setSitnDataCntxtFormatVersion(((Integer) value));
                }
            }
            if( values.containsKey("SitnDataCntxtSchemaVersion") ) {
                final Object value = values.remove("SitnDataCntxtSchemaVersion");
                if( (value == null) || (!value.equals(getSitnDataCntxtSchemaVersion())) ) {
                    setSitnDataCntxtSchemaVersion(((Integer) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("SitnDataCntxtText") ) {
                final Object value = values.remove("SitnDataCntxtText");
                if( (value == null) || (!value.equals(getSitnDataCntxtText())) ) {
                    setSitnDataCntxtText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SituationContextDefTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SituationContextDefTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SituationContextDefTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SituationContextDefTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSituationTypeV2Service.DEFAULT_SERVICE_PATH);
    }

}
