/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.selectable.SituationContextDefTextSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationContextDefText
 * SituationContextDefText} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class SituationContextDefTextByKeyFluentHelper
    extends
    FluentHelperByKey<SituationContextDefTextByKeyFluentHelper, SituationContextDefText, SituationContextDefTextSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationContextDefText
     * SituationContextDefText} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param sitnDefTemplateID
     *            Situation Standard Template ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 32
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SituationContextDefText}
     * @param sitnDataCntxtVersion
     *            Version of Data Context Definition
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code SituationContextDefText}
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param sitnDataCntxtFormatVersion
     *            Context Format Version
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param sitnDataCntxtSchemaVersion
     *            Schema Version of Data Context Definition
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     */
    public SituationContextDefTextByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String sitnDefTemplateID,
        final Integer sitnDataCntxtVersion,
        final Integer sitnDataCntxtFormatVersion,
        final Integer sitnDataCntxtSchemaVersion,
        final String language )
    {
        super(servicePath, entityCollection);
        this.key.put("SitnDefTemplateID", sitnDefTemplateID);
        this.key.put("SitnDataCntxtVersion", sitnDataCntxtVersion);
        this.key.put("SitnDataCntxtFormatVersion", sitnDataCntxtFormatVersion);
        this.key.put("SitnDataCntxtSchemaVersion", sitnDataCntxtSchemaVersion);
        this.key.put("Language", language);
    }

    @Override
    @Nonnull
    protected Class<SituationContextDefText> getEntityClass()
    {
        return SituationContextDefText.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
