/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.field.SituationTemplateField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.link.SituationTemplateLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.selectable.SituationTemplateSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Situation Template
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SituationTemplateType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SituationTemplate extends VdmEntity<SituationTemplate>
{

    /**
     * Selector for all available fields of SituationTemplate.
     *
     */
    public final static SituationTemplateSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>SitnDefTemplateID</b>
     * </p>
     *
     * @return Situation Standard Template ID
     */
    @Key
    @SerializedName( "SitnDefTemplateID" )
    @JsonProperty( "SitnDefTemplateID" )
    @Nullable
    @ODataField( odataName = "SitnDefTemplateID" )
    private String sitnDefTemplateID;
    /**
     * Use with available fluent helpers to apply the <b>SitnDefTemplateID</b> field to query operations.
     *
     */
    public final static SituationTemplateField<String> SITN_DEF_TEMPLATE_ID =
        new SituationTemplateField<String>("SitnDefTemplateID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SitnDefDataContextIsEnabled</b>
     * </p>
     *
     * @return Data element for domain BOOLE: TRUE (='X') and FALSE (=' ')
     */
    @SerializedName( "SitnDefDataContextIsEnabled" )
    @JsonProperty( "SitnDefDataContextIsEnabled" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "SitnDefDataContextIsEnabled" )
    private Boolean sitnDefDataContextIsEnabled;
    /**
     * Use with available fluent helpers to apply the <b>SitnDefDataContextIsEnabled</b> field to query operations.
     *
     */
    public final static SituationTemplateField<Boolean> SITN_DEF_DATA_CONTEXT_IS_ENABLED =
        new SituationTemplateField<Boolean>("SitnDefDataContextIsEnabled");
    /**
     * Navigation property <b>to_SituationAction</b> for <b>SituationTemplate</b> to multiple <b>SituationAction</b>.
     *
     */
    @SerializedName( "to_SituationAction" )
    @JsonProperty( "to_SituationAction" )
    @ODataField( odataName = "to_SituationAction" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SituationAction> toSituationAction;
    /**
     * Navigation property <b>to_SituationTemplateText</b> for <b>SituationTemplate</b> to multiple
     * <b>SituationTemplateText</b>.
     *
     */
    @SerializedName( "to_SituationTemplateText" )
    @JsonProperty( "to_SituationTemplateText" )
    @ODataField( odataName = "to_SituationTemplateText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SituationTemplateText> toSituationTemplateText;
    /**
     * Navigation property <b>to_SituationType</b> for <b>SituationTemplate</b> to multiple <b>SituationType</b>.
     *
     */
    @SerializedName( "to_SituationType" )
    @JsonProperty( "to_SituationType" )
    @ODataField( odataName = "to_SituationType" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SituationType> toSituationType;
    /**
     * Use with available fluent helpers to apply the <b>to_SituationAction</b> navigation property to query operations.
     *
     */
    public final static SituationTemplateLink<SituationAction> TO_SITUATION_ACTION =
        new SituationTemplateLink<SituationAction>("to_SituationAction");
    /**
     * Use with available fluent helpers to apply the <b>to_SituationTemplateText</b> navigation property to query
     * operations.
     *
     */
    public final static SituationTemplateLink<SituationTemplateText> TO_SITUATION_TEMPLATE_TEXT =
        new SituationTemplateLink<SituationTemplateText>("to_SituationTemplateText");
    /**
     * Use with available fluent helpers to apply the <b>to_SituationType</b> navigation property to query operations.
     *
     */
    public final static SituationTemplateLink<SituationType> TO_SITUATION_TYPE =
        new SituationTemplateLink<SituationType>("to_SituationType");

    @Nonnull
    @Override
    public Class<SituationTemplate> getType()
    {
        return SituationTemplate.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>SitnDefTemplateID</b>
     * </p>
     *
     * @param sitnDefTemplateID
     *            Situation Standard Template ID
     */
    public void setSitnDefTemplateID( @Nullable final String sitnDefTemplateID )
    {
        rememberChangedField("SitnDefTemplateID", this.sitnDefTemplateID);
        this.sitnDefTemplateID = sitnDefTemplateID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SitnDefDataContextIsEnabled</b>
     * </p>
     *
     * @param sitnDefDataContextIsEnabled
     *            Data element for domain BOOLE: TRUE (='X') and FALSE (=' ')
     */
    public void setSitnDefDataContextIsEnabled( @Nullable final Boolean sitnDefDataContextIsEnabled )
    {
        rememberChangedField("SitnDefDataContextIsEnabled", this.sitnDefDataContextIsEnabled);
        this.sitnDefDataContextIsEnabled = sitnDefDataContextIsEnabled;
    }

    @Override
    protected String getEntityCollection()
    {
        return "SituationTemplate";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SitnDefTemplateID", getSitnDefTemplateID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SitnDefTemplateID", getSitnDefTemplateID());
        values.put("SitnDefDataContextIsEnabled", getSitnDefDataContextIsEnabled());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SitnDefTemplateID") ) {
                final Object value = values.remove("SitnDefTemplateID");
                if( (value == null) || (!value.equals(getSitnDefTemplateID())) ) {
                    setSitnDefTemplateID(((String) value));
                }
            }
            if( values.containsKey("SitnDefDataContextIsEnabled") ) {
                final Object value = values.remove("SitnDefDataContextIsEnabled");
                if( (value == null) || (!value.equals(getSitnDefDataContextIsEnabled())) ) {
                    setSitnDefDataContextIsEnabled(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_SituationAction") ) {
                final Object value = (values).remove("to_SituationAction");
                if( value instanceof Iterable ) {
                    if( toSituationAction == null ) {
                        toSituationAction = Lists.newArrayList();
                    } else {
                        toSituationAction = Lists.newArrayList(toSituationAction);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SituationAction entity;
                        if( toSituationAction.size() > i ) {
                            entity = toSituationAction.get(i);
                        } else {
                            entity = new SituationAction();
                            toSituationAction.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SituationTemplateText") ) {
                final Object value = (values).remove("to_SituationTemplateText");
                if( value instanceof Iterable ) {
                    if( toSituationTemplateText == null ) {
                        toSituationTemplateText = Lists.newArrayList();
                    } else {
                        toSituationTemplateText = Lists.newArrayList(toSituationTemplateText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SituationTemplateText entity;
                        if( toSituationTemplateText.size() > i ) {
                            entity = toSituationTemplateText.get(i);
                        } else {
                            entity = new SituationTemplateText();
                            toSituationTemplateText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SituationType") ) {
                final Object value = (values).remove("to_SituationType");
                if( value instanceof Iterable ) {
                    if( toSituationType == null ) {
                        toSituationType = Lists.newArrayList();
                    } else {
                        toSituationType = Lists.newArrayList(toSituationType);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SituationType entity;
                        if( toSituationType.size() > i ) {
                            entity = toSituationType.get(i);
                        } else {
                            entity = new SituationType();
                            toSituationType.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SituationTemplateField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SituationTemplateField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SituationTemplateField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SituationTemplateField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSituationTypeV2Service.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSituationAction != null ) {
            (values).put("to_SituationAction", toSituationAction);
        }
        if( toSituationTemplateText != null ) {
            (values).put("to_SituationTemplateText", toSituationTemplateText);
        }
        if( toSituationType != null ) {
            (values).put("to_SituationType", toSituationType);
        }
        return values;
    }

    /**
     * Fetches the <b>SituationAction</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_SituationAction</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SituationAction</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SituationAction> fetchSituationAction()
    {
        return fetchFieldAsList("to_SituationAction", SituationAction.class);
    }

    /**
     * Retrieval of associated <b>SituationAction</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_SituationAction</b>.
     * <p>
     * If the navigation property <b>to_SituationAction</b> of a queried <b>SituationTemplate</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SituationAction</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SituationAction> getSituationActionOrFetch()
    {
        if( toSituationAction == null ) {
            toSituationAction = fetchSituationAction();
        }
        return toSituationAction;
    }

    /**
     * Retrieval of associated <b>SituationAction</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_SituationAction</b>.
     * <p>
     * If the navigation property for an entity <b>SituationTemplate</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SituationAction</b> is already loaded, the result will
     *         contain the <b>SituationAction</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SituationAction>> getSituationActionIfPresent()
    {
        return Option.of(toSituationAction);
    }

    /**
     * Overwrites the list of associated <b>SituationAction</b> entities for the loaded navigation property
     * <b>to_SituationAction</b>.
     * <p>
     * If the navigation property <b>to_SituationAction</b> of a queried <b>SituationTemplate</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SituationAction</b> entities.
     */
    public void setSituationAction( @Nonnull final List<SituationAction> value )
    {
        if( toSituationAction == null ) {
            toSituationAction = Lists.newArrayList();
        }
        toSituationAction.clear();
        toSituationAction.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SituationAction</b> entities. This corresponds to the OData navigation
     * property <b>to_SituationAction</b>.
     * <p>
     * If the navigation property <b>to_SituationAction</b> of a queried <b>SituationTemplate</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SituationAction</b> entities.
     */
    public void addSituationAction( SituationAction... entity )
    {
        if( toSituationAction == null ) {
            toSituationAction = Lists.newArrayList();
        }
        toSituationAction.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SituationTemplateText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_SituationTemplateText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SituationTemplateText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SituationTemplateText> fetchSituationTemplateText()
    {
        return fetchFieldAsList("to_SituationTemplateText", SituationTemplateText.class);
    }

    /**
     * Retrieval of associated <b>SituationTemplateText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SituationTemplateText</b>.
     * <p>
     * If the navigation property <b>to_SituationTemplateText</b> of a queried <b>SituationTemplate</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SituationTemplateText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SituationTemplateText> getSituationTemplateTextOrFetch()
    {
        if( toSituationTemplateText == null ) {
            toSituationTemplateText = fetchSituationTemplateText();
        }
        return toSituationTemplateText;
    }

    /**
     * Retrieval of associated <b>SituationTemplateText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SituationTemplateText</b>.
     * <p>
     * If the navigation property for an entity <b>SituationTemplate</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SituationTemplateText</b> is already loaded, the result
     *         will contain the <b>SituationTemplateText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SituationTemplateText>> getSituationTemplateTextIfPresent()
    {
        return Option.of(toSituationTemplateText);
    }

    /**
     * Overwrites the list of associated <b>SituationTemplateText</b> entities for the loaded navigation property
     * <b>to_SituationTemplateText</b>.
     * <p>
     * If the navigation property <b>to_SituationTemplateText</b> of a queried <b>SituationTemplate</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SituationTemplateText</b> entities.
     */
    public void setSituationTemplateText( @Nonnull final List<SituationTemplateText> value )
    {
        if( toSituationTemplateText == null ) {
            toSituationTemplateText = Lists.newArrayList();
        }
        toSituationTemplateText.clear();
        toSituationTemplateText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SituationTemplateText</b> entities. This corresponds to the OData
     * navigation property <b>to_SituationTemplateText</b>.
     * <p>
     * If the navigation property <b>to_SituationTemplateText</b> of a queried <b>SituationTemplate</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SituationTemplateText</b> entities.
     */
    public void addSituationTemplateText( SituationTemplateText... entity )
    {
        if( toSituationTemplateText == null ) {
            toSituationTemplateText = Lists.newArrayList();
        }
        toSituationTemplateText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SituationType</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_SituationType</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SituationType</b> entities. If no entities are associated then
     *         an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SituationType> fetchSituationType()
    {
        return fetchFieldAsList("to_SituationType", SituationType.class);
    }

    /**
     * Retrieval of associated <b>SituationType</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_SituationType</b>.
     * <p>
     * If the navigation property <b>to_SituationType</b> of a queried <b>SituationTemplate</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SituationType</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SituationType> getSituationTypeOrFetch()
    {
        if( toSituationType == null ) {
            toSituationType = fetchSituationType();
        }
        return toSituationType;
    }

    /**
     * Retrieval of associated <b>SituationType</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_SituationType</b>.
     * <p>
     * If the navigation property for an entity <b>SituationTemplate</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SituationType</b> is already loaded, the result will
     *         contain the <b>SituationType</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SituationType>> getSituationTypeIfPresent()
    {
        return Option.of(toSituationType);
    }

    /**
     * Overwrites the list of associated <b>SituationType</b> entities for the loaded navigation property
     * <b>to_SituationType</b>.
     * <p>
     * If the navigation property <b>to_SituationType</b> of a queried <b>SituationTemplate</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SituationType</b> entities.
     */
    public void setSituationType( @Nonnull final List<SituationType> value )
    {
        if( toSituationType == null ) {
            toSituationType = Lists.newArrayList();
        }
        toSituationType.clear();
        toSituationType.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SituationType</b> entities. This corresponds to the OData navigation
     * property <b>to_SituationType</b>.
     * <p>
     * If the navigation property <b>to_SituationType</b> of a queried <b>SituationTemplate</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SituationType</b> entities.
     */
    public void addSituationType( SituationType... entity )
    {
        if( toSituationType == null ) {
            toSituationType = Lists.newArrayList();
        }
        toSituationType.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of SituationTemplate instances.
     *
     */
    public final static class SituationTemplateBuilder
    {

        private List<SituationAction> toSituationAction = Lists.newArrayList();
        private List<SituationTemplateText> toSituationTemplateText = Lists.newArrayList();
        private List<SituationType> toSituationType = Lists.newArrayList();

        private SituationTemplate.SituationTemplateBuilder toSituationAction( final List<SituationAction> value )
        {
            toSituationAction.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SituationAction</b> for <b>SituationTemplate</b> to multiple
         * <b>SituationAction</b>.
         *
         * @param value
         *            The SituationActions to build this SituationTemplate with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SituationTemplate.SituationTemplateBuilder situationAction( SituationAction... value )
        {
            return toSituationAction(Lists.newArrayList(value));
        }

        private SituationTemplate.SituationTemplateBuilder toSituationTemplateText(
            final List<SituationTemplateText> value )
        {
            toSituationTemplateText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SituationTemplateText</b> for <b>SituationTemplate</b> to multiple
         * <b>SituationTemplateText</b>.
         *
         * @param value
         *            The SituationTemplateTexts to build this SituationTemplate with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SituationTemplate.SituationTemplateBuilder situationTemplateText( SituationTemplateText... value )
        {
            return toSituationTemplateText(Lists.newArrayList(value));
        }

        private SituationTemplate.SituationTemplateBuilder toSituationType( final List<SituationType> value )
        {
            toSituationType.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SituationType</b> for <b>SituationTemplate</b> to multiple <b>SituationType</b>.
         *
         * @param value
         *            The SituationTypes to build this SituationTemplate with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SituationTemplate.SituationTemplateBuilder situationType( SituationType... value )
        {
            return toSituationType(Lists.newArrayList(value));
        }

    }

}
