/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.field.SituationTemplateTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.selectable.SituationTemplateTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Situation Template - Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SituationTemplateTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SituationTemplateText extends VdmEntity<SituationTemplateText>
{

    /**
     * Selector for all available fields of SituationTemplateText.
     *
     */
    public final static SituationTemplateTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>SitnDefTemplateID</b>
     * </p>
     *
     * @return Situation Standard Template ID
     */
    @Key
    @SerializedName( "SitnDefTemplateID" )
    @JsonProperty( "SitnDefTemplateID" )
    @Nullable
    @ODataField( odataName = "SitnDefTemplateID" )
    private String sitnDefTemplateID;
    /**
     * Use with available fluent helpers to apply the <b>SitnDefTemplateID</b> field to query operations.
     *
     */
    public final static SituationTemplateTextField<String> SITN_DEF_TEMPLATE_ID =
        new SituationTemplateTextField<String>("SitnDefTemplateID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static SituationTemplateTextField<String> LANGUAGE =
        new SituationTemplateTextField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SitnDefName</b>
     * </p>
     *
     * @return Situation Type Name
     */
    @SerializedName( "SitnDefName" )
    @JsonProperty( "SitnDefName" )
    @Nullable
    @ODataField( odataName = "SitnDefName" )
    private String sitnDefName;
    /**
     * Use with available fluent helpers to apply the <b>SitnDefName</b> field to query operations.
     *
     */
    public final static SituationTemplateTextField<String> SITN_DEF_NAME =
        new SituationTemplateTextField<String>("SitnDefName");
    /**
     * Constraints: Not nullable, Maximum length: 250
     * <p>
     * Original property name from the Odata EDM: <b>SitnDefDescription</b>
     * </p>
     *
     * @return Situation Condition Description
     */
    @SerializedName( "SitnDefDescription" )
    @JsonProperty( "SitnDefDescription" )
    @Nullable
    @ODataField( odataName = "SitnDefDescription" )
    private String sitnDefDescription;
    /**
     * Use with available fluent helpers to apply the <b>SitnDefDescription</b> field to query operations.
     *
     */
    public final static SituationTemplateTextField<String> SITN_DEF_DESCRIPTION =
        new SituationTemplateTextField<String>("SitnDefDescription");

    @Nonnull
    @Override
    public Class<SituationTemplateText> getType()
    {
        return SituationTemplateText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>SitnDefTemplateID</b>
     * </p>
     *
     * @param sitnDefTemplateID
     *            Situation Standard Template ID
     */
    public void setSitnDefTemplateID( @Nullable final String sitnDefTemplateID )
    {
        rememberChangedField("SitnDefTemplateID", this.sitnDefTemplateID);
        this.sitnDefTemplateID = sitnDefTemplateID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SitnDefName</b>
     * </p>
     *
     * @param sitnDefName
     *            Situation Type Name
     */
    public void setSitnDefName( @Nullable final String sitnDefName )
    {
        rememberChangedField("SitnDefName", this.sitnDefName);
        this.sitnDefName = sitnDefName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 250
     * <p>
     * Original property name from the Odata EDM: <b>SitnDefDescription</b>
     * </p>
     *
     * @param sitnDefDescription
     *            Situation Condition Description
     */
    public void setSitnDefDescription( @Nullable final String sitnDefDescription )
    {
        rememberChangedField("SitnDefDescription", this.sitnDefDescription);
        this.sitnDefDescription = sitnDefDescription;
    }

    @Override
    protected String getEntityCollection()
    {
        return "SituationTemplateText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SitnDefTemplateID", getSitnDefTemplateID());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SitnDefTemplateID", getSitnDefTemplateID());
        values.put("Language", getLanguage());
        values.put("SitnDefName", getSitnDefName());
        values.put("SitnDefDescription", getSitnDefDescription());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SitnDefTemplateID") ) {
                final Object value = values.remove("SitnDefTemplateID");
                if( (value == null) || (!value.equals(getSitnDefTemplateID())) ) {
                    setSitnDefTemplateID(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("SitnDefName") ) {
                final Object value = values.remove("SitnDefName");
                if( (value == null) || (!value.equals(getSitnDefName())) ) {
                    setSitnDefName(((String) value));
                }
            }
            if( values.containsKey("SitnDefDescription") ) {
                final Object value = values.remove("SitnDefDescription");
                if( (value == null) || (!value.equals(getSitnDefDescription())) ) {
                    setSitnDefDescription(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SituationTemplateTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SituationTemplateTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SituationTemplateTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SituationTemplateTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSituationTypeV2Service.DEFAULT_SERVICE_PATH);
    }

}
