/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link BusinessSituationTypeV2ServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSituationTypeV2Service
 * BusinessSituationTypeV2Service}, allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultBusinessSituationTypeV2ServiceBatch
    extends
    BatchFluentHelperBasic<BusinessSituationTypeV2ServiceBatch, BusinessSituationTypeV2ServiceBatchChangeSet>
    implements
    BusinessSituationTypeV2ServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSituationTypeV2Service service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultBusinessSituationTypeV2ServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultBusinessSituationTypeV2ServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSituationTypeV2Service service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSituationTypeV2Service.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultBusinessSituationTypeV2ServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultBusinessSituationTypeV2ServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSituationTypeV2Service service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultBusinessSituationTypeV2ServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public BusinessSituationTypeV2ServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultBusinessSituationTypeV2ServiceBatchChangeSet(this, service);
    }

}
