/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link BusinessSituationTypeV2ServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSituationTypeV2Service
 * BusinessSituationTypeV2Service}.
 *
 */
public class DefaultBusinessSituationTypeV2ServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<BusinessSituationTypeV2ServiceBatch, BusinessSituationTypeV2ServiceBatchChangeSet>
    implements
    BusinessSituationTypeV2ServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSituationTypeV2Service service;

    @SuppressWarnings( "deprecation" )
    DefaultBusinessSituationTypeV2ServiceBatchChangeSet(
        @Nonnull final DefaultBusinessSituationTypeV2ServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSituationTypeV2Service service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultBusinessSituationTypeV2ServiceBatchChangeSet getThis()
    {
        return this;
    }

}
