/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationAction;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.selectable.SituationActionSelectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationAction SituationAction}
 * to other entities. Instances of this object are used in query modifier methods of the entity fluent helpers. Contains
 * methods to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class SituationActionLink<ObjectT extends VdmObject<?>>
    extends
    EntityLink<SituationActionLink<ObjectT>, SituationAction, ObjectT>
    implements
    SituationActionSelectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public SituationActionLink( final String fieldName )
    {
        super(fieldName);
    }

    private SituationActionLink( final EntityLink<SituationActionLink<ObjectT>, SituationAction, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected SituationActionLink<ObjectT> translateLinkType(
        final EntityLink<SituationActionLink<ObjectT>, SituationAction, ObjectT> link )
    {
        return new SituationActionLink<ObjectT>(link);
    }

}
