/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationAction;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationAction SituationAction}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.field.SituationActionField
 * SituationActionField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.link.SituationActionLink
 * SituationActionLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationAction#SITN_DEF_TEMPLATE_ID
 * SITN_DEF_TEMPLATE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationAction#SITN_ACTION_ID
 * SITN_ACTION_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationAction#TO_SITUATION_ACTION_TEXT
 * TO_SITUATION_ACTION_TEXT}</li>
 * </ul>
 *
 */
public interface SituationActionSelectable extends EntitySelectable<SituationAction>
{

}
