/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationContextDefSchema;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationContextDefSchema
 * SituationContextDefSchema}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.field.SituationContextDefSchemaField
 * SituationContextDefSchemaField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.link.SituationContextDefSchemaLink
 * SituationContextDefSchemaLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationContextDefSchema#SITN_DEF_TEMPLATE_ID
 * SITN_DEF_TEMPLATE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationContextDefSchema#SITN_DATA_CNTXT_VERSION
 * SITN_DATA_CNTXT_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationContextDefSchema#SITN_DATA_CNTXT_FORMAT_VERSION
 * SITN_DATA_CNTXT_FORMAT_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationContextDefSchema#SITN_DATA_CNTXT_SCHEMA_VERSION
 * SITN_DATA_CNTXT_SCHEMA_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationContextDefSchema#SITN_DATA_CNTXT_SCHEMA
 * SITN_DATA_CNTXT_SCHEMA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationContextDefSchema#TO_SITUATION_CONTEXT_DEF_TEXT
 * TO_SITUATION_CONTEXT_DEF_TEXT}</li>
 * </ul>
 *
 */
public interface SituationContextDefSchemaSelectable extends EntitySelectable<SituationContextDefSchema>
{

}
