/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationType;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationType SituationType}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.field.SituationTypeField
 * SituationTypeField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.link.SituationTypeLink
 * SituationTypeLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationType#SITN_DEFINITION_ID
 * SITN_DEFINITION_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationType#SITN_DEF_TEMPLATE_ID
 * SITN_DEF_TEMPLATE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationType#SITN_DEF_IS_ENABLED
 * SITN_DEF_IS_ENABLED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationType#SITN_DEF_DATA_CONTEXT_IS_ENABLED
 * SITN_DEF_DATA_CONTEXT_IS_ENABLED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationType#SITN_DEF_AUTOMATION_IS_ENABLED
 * SITN_DEF_AUTOMATION_IS_ENABLED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationType#TO_SITUATION_TYPE_TEXT
 * TO_SITUATION_TYPE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationType#TO_SITUATION_TEMPLATE
 * TO_SITUATION_TEMPLATE}</li>
 * </ul>
 *
 */
public interface SituationTypeSelectable extends EntitySelectable<SituationType>
{

}
