/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder;

import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.field.BSOrdSrvcContrItmBillgReqItmField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.link.BSOrdSrvcContrItmBillgReqItmLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.link.BSOrdSrvcContrItmBillgReqItmOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.selectable.BSOrdSrvcContrItmBillgReqItmSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Service Contract Item BRL Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BSOrdSrvcContrItmBillgReqItmType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BSOrdSrvcContrItmBillgReqItm extends VdmEntity<BSOrdSrvcContrItmBillgReqItm>
{

    /**
     * Selector for all available fields of BSOrdSrvcContrItmBillgReqItm.
     *
     */
    public final static BSOrdSrvcContrItmBillgReqItmSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrder</b>
     * </p>
     *
     * @return Transaction ID
     */
    @Key
    @SerializedName( "BusinessSolutionOrder" )
    @JsonProperty( "BusinessSolutionOrder" )
    @Nullable
    @ODataField( odataName = "BusinessSolutionOrder" )
    private String businessSolutionOrder;
    /**
     * Use with available fluent helpers to apply the <b>BusinessSolutionOrder</b> field to query operations.
     *
     */
    public final static BSOrdSrvcContrItmBillgReqItmField<String> BUSINESS_SOLUTION_ORDER =
        new BSOrdSrvcContrItmBillgReqItmField<String>("BusinessSolutionOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrderItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @Key
    @SerializedName( "BusinessSolutionOrderItem" )
    @JsonProperty( "BusinessSolutionOrderItem" )
    @Nullable
    @ODataField( odataName = "BusinessSolutionOrderItem" )
    private String businessSolutionOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>BusinessSolutionOrderItem</b> field to query operations.
     *
     */
    public final static BSOrdSrvcContrItmBillgReqItmField<String> BUSINESS_SOLUTION_ORDER_ITEM =
        new BSOrdSrvcContrItmBillgReqItmField<String>("BusinessSolutionOrderItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BillingRequestItem</b>
     * </p>
     *
     * @return Billing Request Item No
     */
    @Key
    @SerializedName( "BillingRequestItem" )
    @JsonProperty( "BillingRequestItem" )
    @Nullable
    @ODataField( odataName = "BillingRequestItem" )
    private String billingRequestItem;
    /**
     * Use with available fluent helpers to apply the <b>BillingRequestItem</b> field to query operations.
     *
     */
    public final static BSOrdSrvcContrItmBillgReqItmField<String> BILLING_REQUEST_ITEM =
        new BSOrdSrvcContrItmBillgReqItmField<String>("BillingRequestItem");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BillgReqItemBillingDateTime</b>
     * </p>
     *
     * @return Billing Date for Billing Index and Printout
     */
    @SerializedName( "BillgReqItemBillingDateTime" )
    @JsonProperty( "BillgReqItemBillingDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "BillgReqItemBillingDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime billgReqItemBillingDateTime;
    /**
     * Use with available fluent helpers to apply the <b>BillgReqItemBillingDateTime</b> field to query operations.
     *
     */
    public final static BSOrdSrvcContrItmBillgReqItmField<ZonedDateTime> BILLG_REQ_ITEM_BILLING_DATE_TIME =
        new BSOrdSrvcContrItmBillgReqItmField<ZonedDateTime>("BillgReqItemBillingDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SettlementStartDateTime</b>
     * </p>
     *
     * @return Start of Settlement for Period
     */
    @SerializedName( "SettlementStartDateTime" )
    @JsonProperty( "SettlementStartDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "SettlementStartDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime settlementStartDateTime;
    /**
     * Use with available fluent helpers to apply the <b>SettlementStartDateTime</b> field to query operations.
     *
     */
    public final static BSOrdSrvcContrItmBillgReqItmField<ZonedDateTime> SETTLEMENT_START_DATE_TIME =
        new BSOrdSrvcContrItmBillgReqItmField<ZonedDateTime>("SettlementStartDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SettlementEndDateTime</b>
     * </p>
     *
     * @return End of Settlement for Period
     */
    @SerializedName( "SettlementEndDateTime" )
    @JsonProperty( "SettlementEndDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "SettlementEndDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime settlementEndDateTime;
    /**
     * Use with available fluent helpers to apply the <b>SettlementEndDateTime</b> field to query operations.
     *
     */
    public final static BSOrdSrvcContrItmBillgReqItmField<ZonedDateTime> SETTLEMENT_END_DATE_TIME =
        new BSOrdSrvcContrItmBillgReqItmField<ZonedDateTime>("SettlementEndDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanTimeZone</b>
     * </p>
     *
     * @return Time Zone of Billing Plan Set
     */
    @SerializedName( "BillingPlanTimeZone" )
    @JsonProperty( "BillingPlanTimeZone" )
    @Nullable
    @ODataField( odataName = "BillingPlanTimeZone" )
    private String billingPlanTimeZone;
    /**
     * Use with available fluent helpers to apply the <b>BillingPlanTimeZone</b> field to query operations.
     *
     */
    public final static BSOrdSrvcContrItmBillgReqItmField<String> BILLING_PLAN_TIME_ZONE =
        new BSOrdSrvcContrItmBillgReqItmField<String>("BillingPlanTimeZone");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static BSOrdSrvcContrItmBillgReqItmField<String> TRANSACTION_CURRENCY =
        new BSOrdSrvcContrItmBillgReqItmField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillgReqItemNetAmount</b>
     * </p>
     *
     * @return Net Value
     */
    @SerializedName( "BillgReqItemNetAmount" )
    @JsonProperty( "BillgReqItemNetAmount" )
    @Nullable
    @ODataField( odataName = "BillgReqItemNetAmount" )
    private BigDecimal billgReqItemNetAmount;
    /**
     * Use with available fluent helpers to apply the <b>BillgReqItemNetAmount</b> field to query operations.
     *
     */
    public final static BSOrdSrvcContrItmBillgReqItmField<BigDecimal> BILLG_REQ_ITEM_NET_AMOUNT =
        new BSOrdSrvcContrItmBillgReqItmField<BigDecimal>("BillgReqItemNetAmount");
    /**
     * Navigation property <b>to_PricingElement</b> for <b>BSOrdSrvcContrItmBillgReqItm</b> to multiple
     * <b>BusSolnOrdBillgReqItmPrcElm</b>.
     *
     */
    @SerializedName( "to_PricingElement" )
    @JsonProperty( "to_PricingElement" )
    @ODataField( odataName = "to_PricingElement" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusSolnOrdBillgReqItmPrcElm> toPricingElement;
    /**
     * Navigation property <b>to_ServiceContractItem</b> for <b>BSOrdSrvcContrItmBillgReqItm</b> to single
     * <b>BusSolnOrdSrvcContractItem</b>.
     *
     */
    @SerializedName( "to_ServiceContractItem" )
    @JsonProperty( "to_ServiceContractItem" )
    @ODataField( odataName = "to_ServiceContractItem" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BusSolnOrdSrvcContractItem toServiceContractItem;
    /**
     * Use with available fluent helpers to apply the <b>to_PricingElement</b> navigation property to query operations.
     *
     */
    public final static BSOrdSrvcContrItmBillgReqItmLink<BusSolnOrdBillgReqItmPrcElm> TO_PRICING_ELEMENT =
        new BSOrdSrvcContrItmBillgReqItmLink<BusSolnOrdBillgReqItmPrcElm>("to_PricingElement");
    /**
     * Use with available fluent helpers to apply the <b>to_ServiceContractItem</b> navigation property to query
     * operations.
     *
     */
    public final static BSOrdSrvcContrItmBillgReqItmOneToOneLink<BusSolnOrdSrvcContractItem> TO_SERVICE_CONTRACT_ITEM =
        new BSOrdSrvcContrItmBillgReqItmOneToOneLink<BusSolnOrdSrvcContractItem>("to_ServiceContractItem");

    @Nonnull
    @Override
    public Class<BSOrdSrvcContrItmBillgReqItm> getType()
    {
        return BSOrdSrvcContrItmBillgReqItm.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrder</b>
     * </p>
     *
     * @param businessSolutionOrder
     *            Transaction ID
     */
    public void setBusinessSolutionOrder( @Nullable final String businessSolutionOrder )
    {
        rememberChangedField("BusinessSolutionOrder", this.businessSolutionOrder);
        this.businessSolutionOrder = businessSolutionOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrderItem</b>
     * </p>
     *
     * @param businessSolutionOrderItem
     *            Shortened Item Number in Document
     */
    public void setBusinessSolutionOrderItem( @Nullable final String businessSolutionOrderItem )
    {
        rememberChangedField("BusinessSolutionOrderItem", this.businessSolutionOrderItem);
        this.businessSolutionOrderItem = businessSolutionOrderItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BillingRequestItem</b>
     * </p>
     *
     * @param billingRequestItem
     *            Billing Request Item No
     */
    public void setBillingRequestItem( @Nullable final String billingRequestItem )
    {
        rememberChangedField("BillingRequestItem", this.billingRequestItem);
        this.billingRequestItem = billingRequestItem;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BillgReqItemBillingDateTime</b>
     * </p>
     *
     * @param billgReqItemBillingDateTime
     *            Billing Date for Billing Index and Printout
     */
    public void setBillgReqItemBillingDateTime( @Nullable final ZonedDateTime billgReqItemBillingDateTime )
    {
        rememberChangedField("BillgReqItemBillingDateTime", this.billgReqItemBillingDateTime);
        this.billgReqItemBillingDateTime = billgReqItemBillingDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SettlementStartDateTime</b>
     * </p>
     *
     * @param settlementStartDateTime
     *            Start of Settlement for Period
     */
    public void setSettlementStartDateTime( @Nullable final ZonedDateTime settlementStartDateTime )
    {
        rememberChangedField("SettlementStartDateTime", this.settlementStartDateTime);
        this.settlementStartDateTime = settlementStartDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SettlementEndDateTime</b>
     * </p>
     *
     * @param settlementEndDateTime
     *            End of Settlement for Period
     */
    public void setSettlementEndDateTime( @Nullable final ZonedDateTime settlementEndDateTime )
    {
        rememberChangedField("SettlementEndDateTime", this.settlementEndDateTime);
        this.settlementEndDateTime = settlementEndDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanTimeZone</b>
     * </p>
     *
     * @param billingPlanTimeZone
     *            Time Zone of Billing Plan Set
     */
    public void setBillingPlanTimeZone( @Nullable final String billingPlanTimeZone )
    {
        rememberChangedField("BillingPlanTimeZone", this.billingPlanTimeZone);
        this.billingPlanTimeZone = billingPlanTimeZone;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillgReqItemNetAmount</b>
     * </p>
     *
     * @param billgReqItemNetAmount
     *            Net Value
     */
    public void setBillgReqItemNetAmount( @Nullable final BigDecimal billgReqItemNetAmount )
    {
        rememberChangedField("BillgReqItemNetAmount", this.billgReqItemNetAmount);
        this.billgReqItemNetAmount = billgReqItemNetAmount;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BSOrdSrvcContrItmBillgReqItm";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BusinessSolutionOrder", getBusinessSolutionOrder());
        result.put("BusinessSolutionOrderItem", getBusinessSolutionOrderItem());
        result.put("BillingRequestItem", getBillingRequestItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BusinessSolutionOrder", getBusinessSolutionOrder());
        values.put("BusinessSolutionOrderItem", getBusinessSolutionOrderItem());
        values.put("BillingRequestItem", getBillingRequestItem());
        values.put("BillgReqItemBillingDateTime", getBillgReqItemBillingDateTime());
        values.put("SettlementStartDateTime", getSettlementStartDateTime());
        values.put("SettlementEndDateTime", getSettlementEndDateTime());
        values.put("BillingPlanTimeZone", getBillingPlanTimeZone());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("BillgReqItemNetAmount", getBillgReqItemNetAmount());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BusinessSolutionOrder") ) {
                final Object value = values.remove("BusinessSolutionOrder");
                if( (value == null) || (!value.equals(getBusinessSolutionOrder())) ) {
                    setBusinessSolutionOrder(((String) value));
                }
            }
            if( values.containsKey("BusinessSolutionOrderItem") ) {
                final Object value = values.remove("BusinessSolutionOrderItem");
                if( (value == null) || (!value.equals(getBusinessSolutionOrderItem())) ) {
                    setBusinessSolutionOrderItem(((String) value));
                }
            }
            if( values.containsKey("BillingRequestItem") ) {
                final Object value = values.remove("BillingRequestItem");
                if( (value == null) || (!value.equals(getBillingRequestItem())) ) {
                    setBillingRequestItem(((String) value));
                }
            }
            if( values.containsKey("BillgReqItemBillingDateTime") ) {
                final Object value = values.remove("BillgReqItemBillingDateTime");
                if( (value == null) || (!value.equals(getBillgReqItemBillingDateTime())) ) {
                    setBillgReqItemBillingDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("SettlementStartDateTime") ) {
                final Object value = values.remove("SettlementStartDateTime");
                if( (value == null) || (!value.equals(getSettlementStartDateTime())) ) {
                    setSettlementStartDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("SettlementEndDateTime") ) {
                final Object value = values.remove("SettlementEndDateTime");
                if( (value == null) || (!value.equals(getSettlementEndDateTime())) ) {
                    setSettlementEndDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("BillingPlanTimeZone") ) {
                final Object value = values.remove("BillingPlanTimeZone");
                if( (value == null) || (!value.equals(getBillingPlanTimeZone())) ) {
                    setBillingPlanTimeZone(((String) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("BillgReqItemNetAmount") ) {
                final Object value = values.remove("BillgReqItemNetAmount");
                if( (value == null) || (!value.equals(getBillgReqItemNetAmount())) ) {
                    setBillgReqItemNetAmount(((BigDecimal) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_PricingElement") ) {
                final Object value = (values).remove("to_PricingElement");
                if( value instanceof Iterable ) {
                    if( toPricingElement == null ) {
                        toPricingElement = Lists.newArrayList();
                    } else {
                        toPricingElement = Lists.newArrayList(toPricingElement);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusSolnOrdBillgReqItmPrcElm entity;
                        if( toPricingElement.size() > i ) {
                            entity = toPricingElement.get(i);
                        } else {
                            entity = new BusSolnOrdBillgReqItmPrcElm();
                            toPricingElement.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ServiceContractItem") ) {
                final Object value = (values).remove("to_ServiceContractItem");
                if( value instanceof Map ) {
                    if( toServiceContractItem == null ) {
                        toServiceContractItem = new BusSolnOrdSrvcContractItem();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toServiceContractItem.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> BSOrdSrvcContrItmBillgReqItmField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new BSOrdSrvcContrItmBillgReqItmField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BSOrdSrvcContrItmBillgReqItmField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BSOrdSrvcContrItmBillgReqItmField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSolutionOrderService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toPricingElement != null ) {
            (values).put("to_PricingElement", toPricingElement);
        }
        if( toServiceContractItem != null ) {
            (values).put("to_ServiceContractItem", toServiceContractItem);
        }
        return values;
    }

    /**
     * Fetches the <b>BusSolnOrdBillgReqItmPrcElm</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_PricingElement</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusSolnOrdBillgReqItmPrcElm</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdBillgReqItmPrcElm> fetchPricingElement()
    {
        return fetchFieldAsList("to_PricingElement", BusSolnOrdBillgReqItmPrcElm.class);
    }

    /**
     * Retrieval of associated <b>BusSolnOrdBillgReqItmPrcElm</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>BSOrdSrvcContrItmBillgReqItm</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusSolnOrdBillgReqItmPrcElm</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdBillgReqItmPrcElm> getPricingElementOrFetch()
    {
        if( toPricingElement == null ) {
            toPricingElement = fetchPricingElement();
        }
        return toPricingElement;
    }

    /**
     * Retrieval of associated <b>BusSolnOrdBillgReqItmPrcElm</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property for an entity <b>BSOrdSrvcContrItmBillgReqItm</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PricingElement</b> is already loaded, the result will
     *         contain the <b>BusSolnOrdBillgReqItmPrcElm</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusSolnOrdBillgReqItmPrcElm>> getPricingElementIfPresent()
    {
        return Option.of(toPricingElement);
    }

    /**
     * Overwrites the list of associated <b>BusSolnOrdBillgReqItmPrcElm</b> entities for the loaded navigation property
     * <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>BSOrdSrvcContrItmBillgReqItm</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusSolnOrdBillgReqItmPrcElm</b> entities.
     */
    public void setPricingElement( @Nonnull final List<BusSolnOrdBillgReqItmPrcElm> value )
    {
        if( toPricingElement == null ) {
            toPricingElement = Lists.newArrayList();
        }
        toPricingElement.clear();
        toPricingElement.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusSolnOrdBillgReqItmPrcElm</b> entities. This corresponds to the
     * OData navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>BSOrdSrvcContrItmBillgReqItm</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusSolnOrdBillgReqItmPrcElm</b> entities.
     */
    public void addPricingElement( BusSolnOrdBillgReqItmPrcElm... entity )
    {
        if( toPricingElement == null ) {
            toPricingElement = Lists.newArrayList();
        }
        toPricingElement.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BusSolnOrdSrvcContractItem</b> entity (one to one) associated with this entity. This corresponds
     * to the OData navigation property <b>to_ServiceContractItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BusSolnOrdSrvcContractItem</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BusSolnOrdSrvcContractItem fetchServiceContractItem()
    {
        return fetchFieldAsSingle("to_ServiceContractItem", BusSolnOrdSrvcContractItem.class);
    }

    /**
     * Retrieval of associated <b>BusSolnOrdSrvcContractItem</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_ServiceContractItem</b>.
     * <p>
     * If the navigation property <b>to_ServiceContractItem</b> of a queried <b>BSOrdSrvcContrItmBillgReqItm</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusSolnOrdSrvcContractItem</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BusSolnOrdSrvcContractItem getServiceContractItemOrFetch()
    {
        if( toServiceContractItem == null ) {
            toServiceContractItem = fetchServiceContractItem();
        }
        return toServiceContractItem;
    }

    /**
     * Retrieval of associated <b>BusSolnOrdSrvcContractItem</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_ServiceContractItem</b>.
     * <p>
     * If the navigation property for an entity <b>BSOrdSrvcContrItmBillgReqItm</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ServiceContractItem</b> is already loaded, the result
     *         will contain the <b>BusSolnOrdSrvcContractItem</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<BusSolnOrdSrvcContractItem> getServiceContractItemIfPresent()
    {
        return Option.of(toServiceContractItem);
    }

    /**
     * Overwrites the associated <b>BusSolnOrdSrvcContractItem</b> entity for the loaded navigation property
     * <b>to_ServiceContractItem</b>.
     *
     * @param value
     *            New <b>BusSolnOrdSrvcContractItem</b> entity.
     */
    public void setServiceContractItem( final BusSolnOrdSrvcContractItem value )
    {
        toServiceContractItem = value;
    }

    /**
     * Helper class to allow for fluent creation of BSOrdSrvcContrItmBillgReqItm instances.
     *
     */
    public final static class BSOrdSrvcContrItmBillgReqItmBuilder
    {

        private List<BusSolnOrdBillgReqItmPrcElm> toPricingElement = Lists.newArrayList();
        private BusSolnOrdSrvcContractItem toServiceContractItem;

        private BSOrdSrvcContrItmBillgReqItm.BSOrdSrvcContrItmBillgReqItmBuilder toPricingElement(
            final List<BusSolnOrdBillgReqItmPrcElm> value )
        {
            toPricingElement.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PricingElement</b> for <b>BSOrdSrvcContrItmBillgReqItm</b> to multiple
         * <b>BusSolnOrdBillgReqItmPrcElm</b>.
         *
         * @param value
         *            The BusSolnOrdBillgReqItmPrcElms to build this BSOrdSrvcContrItmBillgReqItm with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BSOrdSrvcContrItmBillgReqItm.BSOrdSrvcContrItmBillgReqItmBuilder pricingElement(
            BusSolnOrdBillgReqItmPrcElm... value )
        {
            return toPricingElement(Lists.newArrayList(value));
        }

        private BSOrdSrvcContrItmBillgReqItm.BSOrdSrvcContrItmBillgReqItmBuilder toServiceContractItem(
            final BusSolnOrdSrvcContractItem value )
        {
            toServiceContractItem = value;
            return this;
        }

        /**
         * Navigation property <b>to_ServiceContractItem</b> for <b>BSOrdSrvcContrItmBillgReqItm</b> to single
         * <b>BusSolnOrdSrvcContractItem</b>.
         *
         * @param value
         *            The BusSolnOrdSrvcContractItem to build this BSOrdSrvcContrItmBillgReqItm with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BSOrdSrvcContrItmBillgReqItm.BSOrdSrvcContrItmBillgReqItmBuilder serviceContractItem(
            final BusSolnOrdSrvcContractItem value )
        {
            return toServiceContractItem(value);
        }

    }

}
