/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.field.BusSolnOrdEntProjectItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.link.BusSolnOrdEntProjectItemLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.link.BusSolnOrdEntProjectItemOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.selectable.BusSolnOrdEntProjectItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Enterprise Project Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BusSolnOrdEntProjectItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BusSolnOrdEntProjectItem extends VdmEntity<BusSolnOrdEntProjectItem>
{

    /**
     * Selector for all available fields of BusSolnOrdEntProjectItem.
     *
     */
    public final static BusSolnOrdEntProjectItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrder</b>
     * </p>
     *
     * @return Transaction ID
     */
    @Key
    @SerializedName( "BusinessSolutionOrder" )
    @JsonProperty( "BusinessSolutionOrder" )
    @Nullable
    @ODataField( odataName = "BusinessSolutionOrder" )
    private String businessSolutionOrder;
    /**
     * Use with available fluent helpers to apply the <b>BusinessSolutionOrder</b> field to query operations.
     *
     */
    public final static BusSolnOrdEntProjectItemField<String> BUSINESS_SOLUTION_ORDER =
        new BusSolnOrdEntProjectItemField<String>("BusinessSolutionOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrderItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @Key
    @SerializedName( "BusinessSolutionOrderItem" )
    @JsonProperty( "BusinessSolutionOrderItem" )
    @Nullable
    @ODataField( odataName = "BusinessSolutionOrderItem" )
    private String businessSolutionOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>BusinessSolutionOrderItem</b> field to query operations.
     *
     */
    public final static BusSolnOrdEntProjectItemField<String> BUSINESS_SOLUTION_ORDER_ITEM =
        new BusSolnOrdEntProjectItemField<String>("BusinessSolutionOrderItem");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrderItemUUID</b>
     * </p>
     *
     * @return GUID of a CRM Order Object
     */
    @SerializedName( "BusinessSolutionOrderItemUUID" )
    @JsonProperty( "BusinessSolutionOrderItemUUID" )
    @Nullable
    @ODataField( odataName = "BusinessSolutionOrderItemUUID" )
    private UUID businessSolutionOrderItemUUID;
    /**
     * Use with available fluent helpers to apply the <b>BusinessSolutionOrderItemUUID</b> field to query operations.
     *
     */
    public final static BusSolnOrdEntProjectItemField<UUID> BUSINESS_SOLUTION_ORDER_ITEM_UUID =
        new BusSolnOrdEntProjectItemField<UUID>("BusinessSolutionOrderItemUUID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmCategory</b>
     * </p>
     *
     * @return Item Category
     */
    @SerializedName( "BusSolnOrdItmCategory" )
    @JsonProperty( "BusSolnOrdItmCategory" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmCategory" )
    private String busSolnOrdItmCategory;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmCategory</b> field to query operations.
     *
     */
    public final static BusSolnOrdEntProjectItemField<String> BUS_SOLN_ORD_ITM_CATEGORY =
        new BusSolnOrdEntProjectItemField<String>("BusSolnOrdItmCategory");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Product Number
     */
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static BusSolnOrdEntProjectItemField<String> PRODUCT =
        new BusSolnOrdEntProjectItemField<String>("Product");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Quantity</b>
     * </p>
     *
     * @return CRM: Order Quantity
     */
    @SerializedName( "Quantity" )
    @JsonProperty( "Quantity" )
    @Nullable
    @ODataField( odataName = "Quantity" )
    private BigDecimal quantity;
    /**
     * Use with available fluent helpers to apply the <b>Quantity</b> field to query operations.
     *
     */
    public final static BusSolnOrdEntProjectItemField<BigDecimal> QUANTITY =
        new BusSolnOrdEntProjectItemField<BigDecimal>("Quantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityUnit</b>
     * </p>
     *
     * @return Unit of Measure in Which the Product Is Sold
     */
    @SerializedName( "QuantityUnit" )
    @JsonProperty( "QuantityUnit" )
    @Nullable
    @ODataField( odataName = "QuantityUnit" )
    private String quantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>QuantityUnit</b> field to query operations.
     *
     */
    public final static BusSolnOrdEntProjectItemField<String> QUANTITY_UNIT =
        new BusSolnOrdEntProjectItemField<String>("QuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmQtyUnitSAPCode</b>
     * </p>
     *
     * @return SAP Unit Code for Order Quantity
     */
    @SerializedName( "BusSolnOrdItmQtyUnitSAPCode" )
    @JsonProperty( "BusSolnOrdItmQtyUnitSAPCode" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmQtyUnitSAPCode" )
    private String busSolnOrdItmQtyUnitSAPCode;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmQtyUnitSAPCode</b> field to query operations.
     *
     */
    public final static BusSolnOrdEntProjectItemField<String> BUS_SOLN_ORD_ITM_QTY_UNIT_SAP_CODE =
        new BusSolnOrdEntProjectItemField<String>("BusSolnOrdItmQtyUnitSAPCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmQtyUnitISOCode</b>
     * </p>
     *
     * @return ISO Unit Code for Order Quantity
     */
    @SerializedName( "BusSolnOrdItmQtyUnitISOCode" )
    @JsonProperty( "BusSolnOrdItmQtyUnitISOCode" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmQtyUnitISOCode" )
    private String busSolnOrdItmQtyUnitISOCode;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmQtyUnitISOCode</b> field to query operations.
     *
     */
    public final static BusSolnOrdEntProjectItemField<String> BUS_SOLN_ORD_ITM_QTY_UNIT_ISO_CODE =
        new BusSolnOrdEntProjectItemField<String>("BusSolnOrdItmQtyUnitISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmDescription</b>
     * </p>
     *
     * @return Product Description
     */
    @SerializedName( "BusSolnOrdItmDescription" )
    @JsonProperty( "BusSolnOrdItmDescription" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmDescription" )
    private String busSolnOrdItmDescription;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmDescription</b> field to query operations.
     *
     */
    public final static BusSolnOrdEntProjectItemField<String> BUS_SOLN_ORD_ITM_DESCRIPTION =
        new BusSolnOrdEntProjectItemField<String>("BusSolnOrdItmDescription");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItemNetAmount</b>
     * </p>
     *
     * @return Net Value
     */
    @SerializedName( "ServiceDocumentItemNetAmount" )
    @JsonProperty( "ServiceDocumentItemNetAmount" )
    @Nullable
    @ODataField( odataName = "ServiceDocumentItemNetAmount" )
    private BigDecimal serviceDocumentItemNetAmount;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocumentItemNetAmount</b> field to query operations.
     *
     */
    public final static BusSolnOrdEntProjectItemField<BigDecimal> SERVICE_DOCUMENT_ITEM_NET_AMOUNT =
        new BusSolnOrdEntProjectItemField<BigDecimal>("ServiceDocumentItemNetAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static BusSolnOrdEntProjectItemField<String> TRANSACTION_CURRENCY =
        new BusSolnOrdEntProjectItemField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmExtReference</b>
     * </p>
     *
     * @return External Reference Number
     */
    @SerializedName( "BusSolnOrdItmExtReference" )
    @JsonProperty( "BusSolnOrdItmExtReference" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmExtReference" )
    private String busSolnOrdItmExtReference;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmExtReference</b> field to query operations.
     *
     */
    public final static BusSolnOrdEntProjectItemField<String> BUS_SOLN_ORD_ITM_EXT_REFERENCE =
        new BusSolnOrdEntProjectItemField<String>("BusSolnOrdItmExtReference");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmIsReleased</b>
     * </p>
     *
     * @return Release Status
     */
    @SerializedName( "BusSolnOrdItmIsReleased" )
    @JsonProperty( "BusSolnOrdItmIsReleased" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmIsReleased" )
    private String busSolnOrdItmIsReleased;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmIsReleased</b> field to query operations.
     *
     */
    public final static BusSolnOrdEntProjectItemField<String> BUS_SOLN_ORD_ITM_IS_RELEASED =
        new BusSolnOrdEntProjectItemField<String>("BusSolnOrdItmIsReleased");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmIsCompleted</b>
     * </p>
     *
     * @return The busSolnOrdItmIsCompleted contained in this entity.
     */
    @SerializedName( "BusSolnOrdItmIsCompleted" )
    @JsonProperty( "BusSolnOrdItmIsCompleted" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmIsCompleted" )
    private String busSolnOrdItmIsCompleted;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmIsCompleted</b> field to query operations.
     *
     */
    public final static BusSolnOrdEntProjectItemField<String> BUS_SOLN_ORD_ITM_IS_COMPLETED =
        new BusSolnOrdEntProjectItemField<String>("BusSolnOrdItmIsCompleted");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @return Sold-To Party
     */
    @SerializedName( "SoldToParty" )
    @JsonProperty( "SoldToParty" )
    @Nullable
    @ODataField( odataName = "SoldToParty" )
    private String soldToParty;
    /**
     * Use with available fluent helpers to apply the <b>SoldToParty</b> field to query operations.
     *
     */
    public final static BusSolnOrdEntProjectItemField<String> SOLD_TO_PARTY =
        new BusSolnOrdEntProjectItemField<String>("SoldToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProjectManager</b>
     * </p>
     *
     * @return Business Partner Number
     */
    @SerializedName( "ProjectManager" )
    @JsonProperty( "ProjectManager" )
    @Nullable
    @ODataField( odataName = "ProjectManager" )
    private String projectManager;
    /**
     * Use with available fluent helpers to apply the <b>ProjectManager</b> field to query operations.
     *
     */
    public final static BusSolnOrdEntProjectItemField<String> PROJECT_MANAGER =
        new BusSolnOrdEntProjectItemField<String>("ProjectManager");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>PersonResponsible</b>
     * </p>
     *
     * @return The personResponsible contained in this entity.
     */
    @SerializedName( "PersonResponsible" )
    @JsonProperty( "PersonResponsible" )
    @Nullable
    @ODataField( odataName = "PersonResponsible" )
    private String personResponsible;
    /**
     * Use with available fluent helpers to apply the <b>PersonResponsible</b> field to query operations.
     *
     */
    public final static BusSolnOrdEntProjectItemField<String> PERSON_RESPONSIBLE =
        new BusSolnOrdEntProjectItemField<String>("PersonResponsible");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProjectStartDate</b>
     * </p>
     *
     * @return The projectStartDate contained in this entity.
     */
    @SerializedName( "ProjectStartDate" )
    @JsonProperty( "ProjectStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ProjectStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime projectStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ProjectStartDate</b> field to query operations.
     *
     */
    public final static BusSolnOrdEntProjectItemField<LocalDateTime> PROJECT_START_DATE =
        new BusSolnOrdEntProjectItemField<LocalDateTime>("ProjectStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProjectEndDate</b>
     * </p>
     *
     * @return The projectEndDate contained in this entity.
     */
    @SerializedName( "ProjectEndDate" )
    @JsonProperty( "ProjectEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ProjectEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime projectEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ProjectEndDate</b> field to query operations.
     *
     */
    public final static BusSolnOrdEntProjectItemField<LocalDateTime> PROJECT_END_DATE =
        new BusSolnOrdEntProjectItemField<LocalDateTime>("ProjectEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ResponsibleCostCenter</b>
     * </p>
     *
     * @return Cost Center
     */
    @SerializedName( "ResponsibleCostCenter" )
    @JsonProperty( "ResponsibleCostCenter" )
    @Nullable
    @ODataField( odataName = "ResponsibleCostCenter" )
    private String responsibleCostCenter;
    /**
     * Use with available fluent helpers to apply the <b>ResponsibleCostCenter</b> field to query operations.
     *
     */
    public final static BusSolnOrdEntProjectItemField<String> RESPONSIBLE_COST_CENTER =
        new BusSolnOrdEntProjectItemField<String>("ResponsibleCostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Profit Center
     */
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static BusSolnOrdEntProjectItemField<String> PROFIT_CENTER =
        new BusSolnOrdEntProjectItemField<String>("ProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>EnterpriseProjectServiceOrg</b>
     * </p>
     *
     * @return Service Organization (Project)
     */
    @SerializedName( "EnterpriseProjectServiceOrg" )
    @JsonProperty( "EnterpriseProjectServiceOrg" )
    @Nullable
    @ODataField( odataName = "EnterpriseProjectServiceOrg" )
    private String enterpriseProjectServiceOrg;
    /**
     * Use with available fluent helpers to apply the <b>EnterpriseProjectServiceOrg</b> field to query operations.
     *
     */
    public final static BusSolnOrdEntProjectItemField<String> ENTERPRISE_PROJECT_SERVICE_ORG =
        new BusSolnOrdEntProjectItemField<String>("EnterpriseProjectServiceOrg");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItemCharUUID</b>
     * </p>
     *
     * @return 32 Character CRM Object GUID (Converted)
     */
    @SerializedName( "ServiceDocumentItemCharUUID" )
    @JsonProperty( "ServiceDocumentItemCharUUID" )
    @Nullable
    @ODataField( odataName = "ServiceDocumentItemCharUUID" )
    private UUID serviceDocumentItemCharUUID;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocumentItemCharUUID</b> field to query operations.
     *
     */
    public final static BusSolnOrdEntProjectItemField<UUID> SERVICE_DOCUMENT_ITEM_CHAR_UUID =
        new BusSolnOrdEntProjectItemField<UUID>("ServiceDocumentItemCharUUID");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>LinkedProject</b>
     * </p>
     *
     * @return Project ID
     */
    @SerializedName( "LinkedProject" )
    @JsonProperty( "LinkedProject" )
    @Nullable
    @ODataField( odataName = "LinkedProject" )
    private String linkedProject;
    /**
     * Use with available fluent helpers to apply the <b>LinkedProject</b> field to query operations.
     *
     */
    public final static BusSolnOrdEntProjectItemField<String> LINKED_PROJECT =
        new BusSolnOrdEntProjectItemField<String>("LinkedProject");
    /**
     * Navigation property <b>to_BusinessSolutionOrder</b> for <b>BusSolnOrdEntProjectItem</b> to single
     * <b>BusinessSolutionOrder</b>.
     *
     */
    @SerializedName( "to_BusinessSolutionOrder" )
    @JsonProperty( "to_BusinessSolutionOrder" )
    @ODataField( odataName = "to_BusinessSolutionOrder" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BusinessSolutionOrder toBusinessSolutionOrder;
    /**
     * Navigation property <b>to_EnterpriseProject</b> for <b>BusSolnOrdEntProjectItem</b> to single
     * <b>BusSolnOrdItmFUPEntProject</b>.
     *
     */
    @SerializedName( "to_EnterpriseProject" )
    @JsonProperty( "to_EnterpriseProject" )
    @ODataField( odataName = "to_EnterpriseProject" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BusSolnOrdItmFUPEntProject toEnterpriseProject;
    /**
     * Navigation property <b>to_Text</b> for <b>BusSolnOrdEntProjectItem</b> to multiple
     * <b>BusSolutionOrderItemText</b>.
     *
     */
    @SerializedName( "to_Text" )
    @JsonProperty( "to_Text" )
    @ODataField( odataName = "to_Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusSolutionOrderItemText> toText;
    /**
     * Navigation property <b>to_UserStatus</b> for <b>BusSolnOrdEntProjectItem</b> to multiple
     * <b>BusSolnOrdItmUserStatus</b>.
     *
     */
    @SerializedName( "to_UserStatus" )
    @JsonProperty( "to_UserStatus" )
    @ODataField( odataName = "to_UserStatus" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusSolnOrdItmUserStatus> toUserStatus;
    /**
     * Use with available fluent helpers to apply the <b>to_BusinessSolutionOrder</b> navigation property to query
     * operations.
     *
     */
    public final static BusSolnOrdEntProjectItemOneToOneLink<BusinessSolutionOrder> TO_BUSINESS_SOLUTION_ORDER =
        new BusSolnOrdEntProjectItemOneToOneLink<BusinessSolutionOrder>("to_BusinessSolutionOrder");
    /**
     * Use with available fluent helpers to apply the <b>to_EnterpriseProject</b> navigation property to query
     * operations.
     *
     */
    public final static BusSolnOrdEntProjectItemOneToOneLink<BusSolnOrdItmFUPEntProject> TO_ENTERPRISE_PROJECT =
        new BusSolnOrdEntProjectItemOneToOneLink<BusSolnOrdItmFUPEntProject>("to_EnterpriseProject");
    /**
     * Use with available fluent helpers to apply the <b>to_Text</b> navigation property to query operations.
     *
     */
    public final static BusSolnOrdEntProjectItemLink<BusSolutionOrderItemText> TO_TEXT =
        new BusSolnOrdEntProjectItemLink<BusSolutionOrderItemText>("to_Text");
    /**
     * Use with available fluent helpers to apply the <b>to_UserStatus</b> navigation property to query operations.
     *
     */
    public final static BusSolnOrdEntProjectItemLink<BusSolnOrdItmUserStatus> TO_USER_STATUS =
        new BusSolnOrdEntProjectItemLink<BusSolnOrdItmUserStatus>("to_UserStatus");

    @Nonnull
    @Override
    public Class<BusSolnOrdEntProjectItem> getType()
    {
        return BusSolnOrdEntProjectItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrder</b>
     * </p>
     *
     * @param businessSolutionOrder
     *            Transaction ID
     */
    public void setBusinessSolutionOrder( @Nullable final String businessSolutionOrder )
    {
        rememberChangedField("BusinessSolutionOrder", this.businessSolutionOrder);
        this.businessSolutionOrder = businessSolutionOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrderItem</b>
     * </p>
     *
     * @param businessSolutionOrderItem
     *            Shortened Item Number in Document
     */
    public void setBusinessSolutionOrderItem( @Nullable final String businessSolutionOrderItem )
    {
        rememberChangedField("BusinessSolutionOrderItem", this.businessSolutionOrderItem);
        this.businessSolutionOrderItem = businessSolutionOrderItem;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrderItemUUID</b>
     * </p>
     *
     * @param businessSolutionOrderItemUUID
     *            GUID of a CRM Order Object
     */
    public void setBusinessSolutionOrderItemUUID( @Nullable final UUID businessSolutionOrderItemUUID )
    {
        rememberChangedField("BusinessSolutionOrderItemUUID", this.businessSolutionOrderItemUUID);
        this.businessSolutionOrderItemUUID = businessSolutionOrderItemUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmCategory</b>
     * </p>
     *
     * @param busSolnOrdItmCategory
     *            Item Category
     */
    public void setBusSolnOrdItmCategory( @Nullable final String busSolnOrdItmCategory )
    {
        rememberChangedField("BusSolnOrdItmCategory", this.busSolnOrdItmCategory);
        this.busSolnOrdItmCategory = busSolnOrdItmCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Product Number
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Quantity</b>
     * </p>
     *
     * @param quantity
     *            CRM: Order Quantity
     */
    public void setQuantity( @Nullable final BigDecimal quantity )
    {
        rememberChangedField("Quantity", this.quantity);
        this.quantity = quantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityUnit</b>
     * </p>
     *
     * @param quantityUnit
     *            Unit of Measure in Which the Product Is Sold
     */
    public void setQuantityUnit( @Nullable final String quantityUnit )
    {
        rememberChangedField("QuantityUnit", this.quantityUnit);
        this.quantityUnit = quantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmQtyUnitSAPCode</b>
     * </p>
     *
     * @param busSolnOrdItmQtyUnitSAPCode
     *            SAP Unit Code for Order Quantity
     */
    public void setBusSolnOrdItmQtyUnitSAPCode( @Nullable final String busSolnOrdItmQtyUnitSAPCode )
    {
        rememberChangedField("BusSolnOrdItmQtyUnitSAPCode", this.busSolnOrdItmQtyUnitSAPCode);
        this.busSolnOrdItmQtyUnitSAPCode = busSolnOrdItmQtyUnitSAPCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmQtyUnitISOCode</b>
     * </p>
     *
     * @param busSolnOrdItmQtyUnitISOCode
     *            ISO Unit Code for Order Quantity
     */
    public void setBusSolnOrdItmQtyUnitISOCode( @Nullable final String busSolnOrdItmQtyUnitISOCode )
    {
        rememberChangedField("BusSolnOrdItmQtyUnitISOCode", this.busSolnOrdItmQtyUnitISOCode);
        this.busSolnOrdItmQtyUnitISOCode = busSolnOrdItmQtyUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmDescription</b>
     * </p>
     *
     * @param busSolnOrdItmDescription
     *            Product Description
     */
    public void setBusSolnOrdItmDescription( @Nullable final String busSolnOrdItmDescription )
    {
        rememberChangedField("BusSolnOrdItmDescription", this.busSolnOrdItmDescription);
        this.busSolnOrdItmDescription = busSolnOrdItmDescription;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItemNetAmount</b>
     * </p>
     *
     * @param serviceDocumentItemNetAmount
     *            Net Value
     */
    public void setServiceDocumentItemNetAmount( @Nullable final BigDecimal serviceDocumentItemNetAmount )
    {
        rememberChangedField("ServiceDocumentItemNetAmount", this.serviceDocumentItemNetAmount);
        this.serviceDocumentItemNetAmount = serviceDocumentItemNetAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmExtReference</b>
     * </p>
     *
     * @param busSolnOrdItmExtReference
     *            External Reference Number
     */
    public void setBusSolnOrdItmExtReference( @Nullable final String busSolnOrdItmExtReference )
    {
        rememberChangedField("BusSolnOrdItmExtReference", this.busSolnOrdItmExtReference);
        this.busSolnOrdItmExtReference = busSolnOrdItmExtReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmIsReleased</b>
     * </p>
     *
     * @param busSolnOrdItmIsReleased
     *            Release Status
     */
    public void setBusSolnOrdItmIsReleased( @Nullable final String busSolnOrdItmIsReleased )
    {
        rememberChangedField("BusSolnOrdItmIsReleased", this.busSolnOrdItmIsReleased);
        this.busSolnOrdItmIsReleased = busSolnOrdItmIsReleased;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmIsCompleted</b>
     * </p>
     *
     * @param busSolnOrdItmIsCompleted
     *            The busSolnOrdItmIsCompleted to set.
     */
    public void setBusSolnOrdItmIsCompleted( @Nullable final String busSolnOrdItmIsCompleted )
    {
        rememberChangedField("BusSolnOrdItmIsCompleted", this.busSolnOrdItmIsCompleted);
        this.busSolnOrdItmIsCompleted = busSolnOrdItmIsCompleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @param soldToParty
     *            Sold-To Party
     */
    public void setSoldToParty( @Nullable final String soldToParty )
    {
        rememberChangedField("SoldToParty", this.soldToParty);
        this.soldToParty = soldToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProjectManager</b>
     * </p>
     *
     * @param projectManager
     *            Business Partner Number
     */
    public void setProjectManager( @Nullable final String projectManager )
    {
        rememberChangedField("ProjectManager", this.projectManager);
        this.projectManager = projectManager;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>PersonResponsible</b>
     * </p>
     *
     * @param personResponsible
     *            The personResponsible to set.
     */
    public void setPersonResponsible( @Nullable final String personResponsible )
    {
        rememberChangedField("PersonResponsible", this.personResponsible);
        this.personResponsible = personResponsible;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProjectStartDate</b>
     * </p>
     *
     * @param projectStartDate
     *            The projectStartDate to set.
     */
    public void setProjectStartDate( @Nullable final LocalDateTime projectStartDate )
    {
        rememberChangedField("ProjectStartDate", this.projectStartDate);
        this.projectStartDate = projectStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProjectEndDate</b>
     * </p>
     *
     * @param projectEndDate
     *            The projectEndDate to set.
     */
    public void setProjectEndDate( @Nullable final LocalDateTime projectEndDate )
    {
        rememberChangedField("ProjectEndDate", this.projectEndDate);
        this.projectEndDate = projectEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ResponsibleCostCenter</b>
     * </p>
     *
     * @param responsibleCostCenter
     *            Cost Center
     */
    public void setResponsibleCostCenter( @Nullable final String responsibleCostCenter )
    {
        rememberChangedField("ResponsibleCostCenter", this.responsibleCostCenter);
        this.responsibleCostCenter = responsibleCostCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Profit Center
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>EnterpriseProjectServiceOrg</b>
     * </p>
     *
     * @param enterpriseProjectServiceOrg
     *            Service Organization (Project)
     */
    public void setEnterpriseProjectServiceOrg( @Nullable final String enterpriseProjectServiceOrg )
    {
        rememberChangedField("EnterpriseProjectServiceOrg", this.enterpriseProjectServiceOrg);
        this.enterpriseProjectServiceOrg = enterpriseProjectServiceOrg;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItemCharUUID</b>
     * </p>
     *
     * @param serviceDocumentItemCharUUID
     *            32 Character CRM Object GUID (Converted)
     */
    public void setServiceDocumentItemCharUUID( @Nullable final UUID serviceDocumentItemCharUUID )
    {
        rememberChangedField("ServiceDocumentItemCharUUID", this.serviceDocumentItemCharUUID);
        this.serviceDocumentItemCharUUID = serviceDocumentItemCharUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>LinkedProject</b>
     * </p>
     *
     * @param linkedProject
     *            Project ID
     */
    public void setLinkedProject( @Nullable final String linkedProject )
    {
        rememberChangedField("LinkedProject", this.linkedProject);
        this.linkedProject = linkedProject;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BusSolnOrdEntProjectItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BusinessSolutionOrder", getBusinessSolutionOrder());
        result.put("BusinessSolutionOrderItem", getBusinessSolutionOrderItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BusinessSolutionOrder", getBusinessSolutionOrder());
        values.put("BusinessSolutionOrderItem", getBusinessSolutionOrderItem());
        values.put("BusinessSolutionOrderItemUUID", getBusinessSolutionOrderItemUUID());
        values.put("BusSolnOrdItmCategory", getBusSolnOrdItmCategory());
        values.put("Product", getProduct());
        values.put("Quantity", getQuantity());
        values.put("QuantityUnit", getQuantityUnit());
        values.put("BusSolnOrdItmQtyUnitSAPCode", getBusSolnOrdItmQtyUnitSAPCode());
        values.put("BusSolnOrdItmQtyUnitISOCode", getBusSolnOrdItmQtyUnitISOCode());
        values.put("BusSolnOrdItmDescription", getBusSolnOrdItmDescription());
        values.put("ServiceDocumentItemNetAmount", getServiceDocumentItemNetAmount());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("BusSolnOrdItmExtReference", getBusSolnOrdItmExtReference());
        values.put("BusSolnOrdItmIsReleased", getBusSolnOrdItmIsReleased());
        values.put("BusSolnOrdItmIsCompleted", getBusSolnOrdItmIsCompleted());
        values.put("SoldToParty", getSoldToParty());
        values.put("ProjectManager", getProjectManager());
        values.put("PersonResponsible", getPersonResponsible());
        values.put("ProjectStartDate", getProjectStartDate());
        values.put("ProjectEndDate", getProjectEndDate());
        values.put("ResponsibleCostCenter", getResponsibleCostCenter());
        values.put("ProfitCenter", getProfitCenter());
        values.put("EnterpriseProjectServiceOrg", getEnterpriseProjectServiceOrg());
        values.put("ServiceDocumentItemCharUUID", getServiceDocumentItemCharUUID());
        values.put("LinkedProject", getLinkedProject());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BusinessSolutionOrder") ) {
                final Object value = values.remove("BusinessSolutionOrder");
                if( (value == null) || (!value.equals(getBusinessSolutionOrder())) ) {
                    setBusinessSolutionOrder(((String) value));
                }
            }
            if( values.containsKey("BusinessSolutionOrderItem") ) {
                final Object value = values.remove("BusinessSolutionOrderItem");
                if( (value == null) || (!value.equals(getBusinessSolutionOrderItem())) ) {
                    setBusinessSolutionOrderItem(((String) value));
                }
            }
            if( values.containsKey("BusinessSolutionOrderItemUUID") ) {
                final Object value = values.remove("BusinessSolutionOrderItemUUID");
                if( (value == null) || (!value.equals(getBusinessSolutionOrderItemUUID())) ) {
                    setBusinessSolutionOrderItemUUID(((UUID) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmCategory") ) {
                final Object value = values.remove("BusSolnOrdItmCategory");
                if( (value == null) || (!value.equals(getBusSolnOrdItmCategory())) ) {
                    setBusSolnOrdItmCategory(((String) value));
                }
            }
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("Quantity") ) {
                final Object value = values.remove("Quantity");
                if( (value == null) || (!value.equals(getQuantity())) ) {
                    setQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("QuantityUnit") ) {
                final Object value = values.remove("QuantityUnit");
                if( (value == null) || (!value.equals(getQuantityUnit())) ) {
                    setQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmQtyUnitSAPCode") ) {
                final Object value = values.remove("BusSolnOrdItmQtyUnitSAPCode");
                if( (value == null) || (!value.equals(getBusSolnOrdItmQtyUnitSAPCode())) ) {
                    setBusSolnOrdItmQtyUnitSAPCode(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmQtyUnitISOCode") ) {
                final Object value = values.remove("BusSolnOrdItmQtyUnitISOCode");
                if( (value == null) || (!value.equals(getBusSolnOrdItmQtyUnitISOCode())) ) {
                    setBusSolnOrdItmQtyUnitISOCode(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmDescription") ) {
                final Object value = values.remove("BusSolnOrdItmDescription");
                if( (value == null) || (!value.equals(getBusSolnOrdItmDescription())) ) {
                    setBusSolnOrdItmDescription(((String) value));
                }
            }
            if( values.containsKey("ServiceDocumentItemNetAmount") ) {
                final Object value = values.remove("ServiceDocumentItemNetAmount");
                if( (value == null) || (!value.equals(getServiceDocumentItemNetAmount())) ) {
                    setServiceDocumentItemNetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmExtReference") ) {
                final Object value = values.remove("BusSolnOrdItmExtReference");
                if( (value == null) || (!value.equals(getBusSolnOrdItmExtReference())) ) {
                    setBusSolnOrdItmExtReference(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmIsReleased") ) {
                final Object value = values.remove("BusSolnOrdItmIsReleased");
                if( (value == null) || (!value.equals(getBusSolnOrdItmIsReleased())) ) {
                    setBusSolnOrdItmIsReleased(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmIsCompleted") ) {
                final Object value = values.remove("BusSolnOrdItmIsCompleted");
                if( (value == null) || (!value.equals(getBusSolnOrdItmIsCompleted())) ) {
                    setBusSolnOrdItmIsCompleted(((String) value));
                }
            }
            if( values.containsKey("SoldToParty") ) {
                final Object value = values.remove("SoldToParty");
                if( (value == null) || (!value.equals(getSoldToParty())) ) {
                    setSoldToParty(((String) value));
                }
            }
            if( values.containsKey("ProjectManager") ) {
                final Object value = values.remove("ProjectManager");
                if( (value == null) || (!value.equals(getProjectManager())) ) {
                    setProjectManager(((String) value));
                }
            }
            if( values.containsKey("PersonResponsible") ) {
                final Object value = values.remove("PersonResponsible");
                if( (value == null) || (!value.equals(getPersonResponsible())) ) {
                    setPersonResponsible(((String) value));
                }
            }
            if( values.containsKey("ProjectStartDate") ) {
                final Object value = values.remove("ProjectStartDate");
                if( (value == null) || (!value.equals(getProjectStartDate())) ) {
                    setProjectStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ProjectEndDate") ) {
                final Object value = values.remove("ProjectEndDate");
                if( (value == null) || (!value.equals(getProjectEndDate())) ) {
                    setProjectEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ResponsibleCostCenter") ) {
                final Object value = values.remove("ResponsibleCostCenter");
                if( (value == null) || (!value.equals(getResponsibleCostCenter())) ) {
                    setResponsibleCostCenter(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("EnterpriseProjectServiceOrg") ) {
                final Object value = values.remove("EnterpriseProjectServiceOrg");
                if( (value == null) || (!value.equals(getEnterpriseProjectServiceOrg())) ) {
                    setEnterpriseProjectServiceOrg(((String) value));
                }
            }
            if( values.containsKey("ServiceDocumentItemCharUUID") ) {
                final Object value = values.remove("ServiceDocumentItemCharUUID");
                if( (value == null) || (!value.equals(getServiceDocumentItemCharUUID())) ) {
                    setServiceDocumentItemCharUUID(((UUID) value));
                }
            }
            if( values.containsKey("LinkedProject") ) {
                final Object value = values.remove("LinkedProject");
                if( (value == null) || (!value.equals(getLinkedProject())) ) {
                    setLinkedProject(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BusinessSolutionOrder") ) {
                final Object value = (values).remove("to_BusinessSolutionOrder");
                if( value instanceof Map ) {
                    if( toBusinessSolutionOrder == null ) {
                        toBusinessSolutionOrder = new BusinessSolutionOrder();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBusinessSolutionOrder.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_EnterpriseProject") ) {
                final Object value = (values).remove("to_EnterpriseProject");
                if( value instanceof Map ) {
                    if( toEnterpriseProject == null ) {
                        toEnterpriseProject = new BusSolnOrdItmFUPEntProject();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toEnterpriseProject.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_Text") ) {
                final Object value = (values).remove("to_Text");
                if( value instanceof Iterable ) {
                    if( toText == null ) {
                        toText = Lists.newArrayList();
                    } else {
                        toText = Lists.newArrayList(toText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusSolutionOrderItemText entity;
                        if( toText.size() > i ) {
                            entity = toText.get(i);
                        } else {
                            entity = new BusSolutionOrderItemText();
                            toText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_UserStatus") ) {
                final Object value = (values).remove("to_UserStatus");
                if( value instanceof Iterable ) {
                    if( toUserStatus == null ) {
                        toUserStatus = Lists.newArrayList();
                    } else {
                        toUserStatus = Lists.newArrayList(toUserStatus);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusSolnOrdItmUserStatus entity;
                        if( toUserStatus.size() > i ) {
                            entity = toUserStatus.get(i);
                        } else {
                            entity = new BusSolnOrdItmUserStatus();
                            toUserStatus.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> BusSolnOrdEntProjectItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BusSolnOrdEntProjectItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BusSolnOrdEntProjectItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BusSolnOrdEntProjectItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSolutionOrderService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBusinessSolutionOrder != null ) {
            (values).put("to_BusinessSolutionOrder", toBusinessSolutionOrder);
        }
        if( toEnterpriseProject != null ) {
            (values).put("to_EnterpriseProject", toEnterpriseProject);
        }
        if( toText != null ) {
            (values).put("to_Text", toText);
        }
        if( toUserStatus != null ) {
            (values).put("to_UserStatus", toUserStatus);
        }
        return values;
    }

    /**
     * Fetches the <b>BusinessSolutionOrder</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_BusinessSolutionOrder</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BusinessSolutionOrder</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BusinessSolutionOrder fetchBusinessSolutionOrder()
    {
        return fetchFieldAsSingle("to_BusinessSolutionOrder", BusinessSolutionOrder.class);
    }

    /**
     * Retrieval of associated <b>BusinessSolutionOrder</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_BusinessSolutionOrder</b>.
     * <p>
     * If the navigation property <b>to_BusinessSolutionOrder</b> of a queried <b>BusSolnOrdEntProjectItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusinessSolutionOrder</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BusinessSolutionOrder getBusinessSolutionOrderOrFetch()
    {
        if( toBusinessSolutionOrder == null ) {
            toBusinessSolutionOrder = fetchBusinessSolutionOrder();
        }
        return toBusinessSolutionOrder;
    }

    /**
     * Retrieval of associated <b>BusinessSolutionOrder</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_BusinessSolutionOrder</b>.
     * <p>
     * If the navigation property for an entity <b>BusSolnOrdEntProjectItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BusinessSolutionOrder</b> is already loaded, the result
     *         will contain the <b>BusinessSolutionOrder</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<BusinessSolutionOrder> getBusinessSolutionOrderIfPresent()
    {
        return Option.of(toBusinessSolutionOrder);
    }

    /**
     * Overwrites the associated <b>BusinessSolutionOrder</b> entity for the loaded navigation property
     * <b>to_BusinessSolutionOrder</b>.
     *
     * @param value
     *            New <b>BusinessSolutionOrder</b> entity.
     */
    public void setBusinessSolutionOrder( final BusinessSolutionOrder value )
    {
        toBusinessSolutionOrder = value;
    }

    /**
     * Fetches the <b>BusSolnOrdItmFUPEntProject</b> entity (one to one) associated with this entity. This corresponds
     * to the OData navigation property <b>to_EnterpriseProject</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BusSolnOrdItmFUPEntProject</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BusSolnOrdItmFUPEntProject fetchEnterpriseProject()
    {
        return fetchFieldAsSingle("to_EnterpriseProject", BusSolnOrdItmFUPEntProject.class);
    }

    /**
     * Retrieval of associated <b>BusSolnOrdItmFUPEntProject</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_EnterpriseProject</b>.
     * <p>
     * If the navigation property <b>to_EnterpriseProject</b> of a queried <b>BusSolnOrdEntProjectItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusSolnOrdItmFUPEntProject</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BusSolnOrdItmFUPEntProject getEnterpriseProjectOrFetch()
    {
        if( toEnterpriseProject == null ) {
            toEnterpriseProject = fetchEnterpriseProject();
        }
        return toEnterpriseProject;
    }

    /**
     * Retrieval of associated <b>BusSolnOrdItmFUPEntProject</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_EnterpriseProject</b>.
     * <p>
     * If the navigation property for an entity <b>BusSolnOrdEntProjectItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_EnterpriseProject</b> is already loaded, the result will
     *         contain the <b>BusSolnOrdItmFUPEntProject</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<BusSolnOrdItmFUPEntProject> getEnterpriseProjectIfPresent()
    {
        return Option.of(toEnterpriseProject);
    }

    /**
     * Overwrites the associated <b>BusSolnOrdItmFUPEntProject</b> entity for the loaded navigation property
     * <b>to_EnterpriseProject</b>.
     *
     * @param value
     *            New <b>BusSolnOrdItmFUPEntProject</b> entity.
     */
    public void setEnterpriseProject( final BusSolnOrdItmFUPEntProject value )
    {
        toEnterpriseProject = value;
    }

    /**
     * Fetches the <b>BusSolutionOrderItemText</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_Text</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusSolutionOrderItemText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolutionOrderItemText> fetchText()
    {
        return fetchFieldAsList("to_Text", BusSolutionOrderItemText.class);
    }

    /**
     * Retrieval of associated <b>BusSolutionOrderItemText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>BusSolnOrdEntProjectItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusSolutionOrderItemText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolutionOrderItemText> getTextOrFetch()
    {
        if( toText == null ) {
            toText = fetchText();
        }
        return toText;
    }

    /**
     * Retrieval of associated <b>BusSolutionOrderItemText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property for an entity <b>BusSolnOrdEntProjectItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Text</b> is already loaded, the result will contain the
     *         <b>BusSolutionOrderItemText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusSolutionOrderItemText>> getTextIfPresent()
    {
        return Option.of(toText);
    }

    /**
     * Overwrites the list of associated <b>BusSolutionOrderItemText</b> entities for the loaded navigation property
     * <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>BusSolnOrdEntProjectItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusSolutionOrderItemText</b> entities.
     */
    public void setText( @Nonnull final List<BusSolutionOrderItemText> value )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.clear();
        toText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusSolutionOrderItemText</b> entities. This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>BusSolnOrdEntProjectItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusSolutionOrderItemText</b> entities.
     */
    public void addText( BusSolutionOrderItemText... entity )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BusSolnOrdItmUserStatus</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_UserStatus</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusSolnOrdItmUserStatus</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdItmUserStatus> fetchUserStatus()
    {
        return fetchFieldAsList("to_UserStatus", BusSolnOrdItmUserStatus.class);
    }

    /**
     * Retrieval of associated <b>BusSolnOrdItmUserStatus</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_UserStatus</b>.
     * <p>
     * If the navigation property <b>to_UserStatus</b> of a queried <b>BusSolnOrdEntProjectItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusSolnOrdItmUserStatus</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdItmUserStatus> getUserStatusOrFetch()
    {
        if( toUserStatus == null ) {
            toUserStatus = fetchUserStatus();
        }
        return toUserStatus;
    }

    /**
     * Retrieval of associated <b>BusSolnOrdItmUserStatus</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_UserStatus</b>.
     * <p>
     * If the navigation property for an entity <b>BusSolnOrdEntProjectItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_UserStatus</b> is already loaded, the result will
     *         contain the <b>BusSolnOrdItmUserStatus</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusSolnOrdItmUserStatus>> getUserStatusIfPresent()
    {
        return Option.of(toUserStatus);
    }

    /**
     * Overwrites the list of associated <b>BusSolnOrdItmUserStatus</b> entities for the loaded navigation property
     * <b>to_UserStatus</b>.
     * <p>
     * If the navigation property <b>to_UserStatus</b> of a queried <b>BusSolnOrdEntProjectItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusSolnOrdItmUserStatus</b> entities.
     */
    public void setUserStatus( @Nonnull final List<BusSolnOrdItmUserStatus> value )
    {
        if( toUserStatus == null ) {
            toUserStatus = Lists.newArrayList();
        }
        toUserStatus.clear();
        toUserStatus.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusSolnOrdItmUserStatus</b> entities. This corresponds to the OData
     * navigation property <b>to_UserStatus</b>.
     * <p>
     * If the navigation property <b>to_UserStatus</b> of a queried <b>BusSolnOrdEntProjectItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusSolnOrdItmUserStatus</b> entities.
     */
    public void addUserStatus( BusSolnOrdItmUserStatus... entity )
    {
        if( toUserStatus == null ) {
            toUserStatus = Lists.newArrayList();
        }
        toUserStatus.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of BusSolnOrdEntProjectItem instances.
     *
     */
    public final static class BusSolnOrdEntProjectItemBuilder
    {

        private BusinessSolutionOrder toBusinessSolutionOrder;
        private String businessSolutionOrder = null;
        private BusSolnOrdItmFUPEntProject toEnterpriseProject;
        private List<BusSolutionOrderItemText> toText = Lists.newArrayList();
        private List<BusSolnOrdItmUserStatus> toUserStatus = Lists.newArrayList();

        private BusSolnOrdEntProjectItem.BusSolnOrdEntProjectItemBuilder toBusinessSolutionOrder(
            final BusinessSolutionOrder value )
        {
            toBusinessSolutionOrder = value;
            return this;
        }

        /**
         * Navigation property <b>to_BusinessSolutionOrder</b> for <b>BusSolnOrdEntProjectItem</b> to single
         * <b>BusinessSolutionOrder</b>.
         *
         * @param value
         *            The BusinessSolutionOrder to build this BusSolnOrdEntProjectItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusSolnOrdEntProjectItem.BusSolnOrdEntProjectItemBuilder businessSolutionOrder(
            final BusinessSolutionOrder value )
        {
            return toBusinessSolutionOrder(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>BusinessSolutionOrder</b>
         * </p>
         *
         * @param value
         *            The businessSolutionOrder to build this BusSolnOrdEntProjectItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusSolnOrdEntProjectItem.BusSolnOrdEntProjectItemBuilder businessSolutionOrder( final String value )
        {
            businessSolutionOrder = value;
            return this;
        }

        private BusSolnOrdEntProjectItem.BusSolnOrdEntProjectItemBuilder toEnterpriseProject(
            final BusSolnOrdItmFUPEntProject value )
        {
            toEnterpriseProject = value;
            return this;
        }

        /**
         * Navigation property <b>to_EnterpriseProject</b> for <b>BusSolnOrdEntProjectItem</b> to single
         * <b>BusSolnOrdItmFUPEntProject</b>.
         *
         * @param value
         *            The BusSolnOrdItmFUPEntProject to build this BusSolnOrdEntProjectItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusSolnOrdEntProjectItem.BusSolnOrdEntProjectItemBuilder enterpriseProject(
            final BusSolnOrdItmFUPEntProject value )
        {
            return toEnterpriseProject(value);
        }

        private BusSolnOrdEntProjectItem.BusSolnOrdEntProjectItemBuilder toText(
            final List<BusSolutionOrderItemText> value )
        {
            toText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Text</b> for <b>BusSolnOrdEntProjectItem</b> to multiple
         * <b>BusSolutionOrderItemText</b>.
         *
         * @param value
         *            The BusSolutionOrderItemTexts to build this BusSolnOrdEntProjectItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusSolnOrdEntProjectItem.BusSolnOrdEntProjectItemBuilder text( BusSolutionOrderItemText... value )
        {
            return toText(Lists.newArrayList(value));
        }

        private BusSolnOrdEntProjectItem.BusSolnOrdEntProjectItemBuilder toUserStatus(
            final List<BusSolnOrdItmUserStatus> value )
        {
            toUserStatus.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_UserStatus</b> for <b>BusSolnOrdEntProjectItem</b> to multiple
         * <b>BusSolnOrdItmUserStatus</b>.
         *
         * @param value
         *            The BusSolnOrdItmUserStatuss to build this BusSolnOrdEntProjectItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusSolnOrdEntProjectItem.BusSolnOrdEntProjectItemBuilder userStatus( BusSolnOrdItmUserStatus... value )
        {
            return toUserStatus(Lists.newArrayList(value));
        }

    }

}
