/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.field.BusSolnOrdFUPEntProjectField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.selectable.BusSolnOrdFUPEntProjectSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Follow up Enterprise Projects
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BusSolnOrdFUPEntProjectType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BusSolnOrdFUPEntProject extends VdmEntity<BusSolnOrdFUPEntProject>
{

    /**
     * Selector for all available fields of BusSolnOrdFUPEntProject.
     *
     */
    public final static BusSolnOrdFUPEntProjectSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentRelationUUID</b>
     * </p>
     *
     * @return Object Relationship Service : GUID binary link
     */
    @Key
    @SerializedName( "ServiceDocumentRelationUUID" )
    @JsonProperty( "ServiceDocumentRelationUUID" )
    @Nullable
    @ODataField( odataName = "ServiceDocumentRelationUUID" )
    private UUID serviceDocumentRelationUUID;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocumentRelationUUID</b> field to query operations.
     *
     */
    public final static BusSolnOrdFUPEntProjectField<UUID> SERVICE_DOCUMENT_RELATION_UUID =
        new BusSolnOrdFUPEntProjectField<UUID>("ServiceDocumentRelationUUID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocRltnSequenceNumber</b>
     * </p>
     *
     * @return Sequential Number of Segment in IDoc Type
     */
    @Key
    @SerializedName( "ServiceDocRltnSequenceNumber" )
    @JsonProperty( "ServiceDocRltnSequenceNumber" )
    @Nullable
    @ODataField( odataName = "ServiceDocRltnSequenceNumber" )
    private String serviceDocRltnSequenceNumber;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocRltnSequenceNumber</b> field to query operations.
     *
     */
    public final static BusSolnOrdFUPEntProjectField<String> SERVICE_DOC_RLTN_SEQUENCE_NUMBER =
        new BusSolnOrdFUPEntProjectField<String>("ServiceDocRltnSequenceNumber");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrderUUID</b>
     * </p>
     *
     * @return GUID of a CRM Order Object
     */
    @SerializedName( "BusinessSolutionOrderUUID" )
    @JsonProperty( "BusinessSolutionOrderUUID" )
    @Nullable
    @ODataField( odataName = "BusinessSolutionOrderUUID" )
    private UUID businessSolutionOrderUUID;
    /**
     * Use with available fluent helpers to apply the <b>BusinessSolutionOrderUUID</b> field to query operations.
     *
     */
    public final static BusSolnOrdFUPEntProjectField<UUID> BUSINESS_SOLUTION_ORDER_UUID =
        new BusSolnOrdFUPEntProjectField<UUID>("BusinessSolutionOrderUUID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrder</b>
     * </p>
     *
     * @return Transaction ID
     */
    @SerializedName( "BusinessSolutionOrder" )
    @JsonProperty( "BusinessSolutionOrder" )
    @Nullable
    @ODataField( odataName = "BusinessSolutionOrder" )
    private String businessSolutionOrder;
    /**
     * Use with available fluent helpers to apply the <b>BusinessSolutionOrder</b> field to query operations.
     *
     */
    public final static BusSolnOrdFUPEntProjectField<String> BUSINESS_SOLUTION_ORDER =
        new BusSolnOrdFUPEntProjectField<String>("BusinessSolutionOrder");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectUUID</b>
     * </p>
     *
     * @return GUID of a CRM Order Object
     */
    @SerializedName( "ProjectUUID" )
    @JsonProperty( "ProjectUUID" )
    @Nullable
    @ODataField( odataName = "ProjectUUID" )
    private UUID projectUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectUUID</b> field to query operations.
     *
     */
    public final static BusSolnOrdFUPEntProjectField<UUID> PROJECT_UUID =
        new BusSolnOrdFUPEntProjectField<UUID>("ProjectUUID");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>Project</b>
     * </p>
     *
     * @return Project ID
     */
    @SerializedName( "Project" )
    @JsonProperty( "Project" )
    @Nullable
    @ODataField( odataName = "Project" )
    private String project;
    /**
     * Use with available fluent helpers to apply the <b>Project</b> field to query operations.
     *
     */
    public final static BusSolnOrdFUPEntProjectField<String> PROJECT =
        new BusSolnOrdFUPEntProjectField<String>("Project");

    @Nonnull
    @Override
    public Class<BusSolnOrdFUPEntProject> getType()
    {
        return BusSolnOrdFUPEntProject.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentRelationUUID</b>
     * </p>
     *
     * @param serviceDocumentRelationUUID
     *            Object Relationship Service : GUID binary link
     */
    public void setServiceDocumentRelationUUID( @Nullable final UUID serviceDocumentRelationUUID )
    {
        rememberChangedField("ServiceDocumentRelationUUID", this.serviceDocumentRelationUUID);
        this.serviceDocumentRelationUUID = serviceDocumentRelationUUID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocRltnSequenceNumber</b>
     * </p>
     *
     * @param serviceDocRltnSequenceNumber
     *            Sequential Number of Segment in IDoc Type
     */
    public void setServiceDocRltnSequenceNumber( @Nullable final String serviceDocRltnSequenceNumber )
    {
        rememberChangedField("ServiceDocRltnSequenceNumber", this.serviceDocRltnSequenceNumber);
        this.serviceDocRltnSequenceNumber = serviceDocRltnSequenceNumber;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrderUUID</b>
     * </p>
     *
     * @param businessSolutionOrderUUID
     *            GUID of a CRM Order Object
     */
    public void setBusinessSolutionOrderUUID( @Nullable final UUID businessSolutionOrderUUID )
    {
        rememberChangedField("BusinessSolutionOrderUUID", this.businessSolutionOrderUUID);
        this.businessSolutionOrderUUID = businessSolutionOrderUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrder</b>
     * </p>
     *
     * @param businessSolutionOrder
     *            Transaction ID
     */
    public void setBusinessSolutionOrder( @Nullable final String businessSolutionOrder )
    {
        rememberChangedField("BusinessSolutionOrder", this.businessSolutionOrder);
        this.businessSolutionOrder = businessSolutionOrder;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectUUID</b>
     * </p>
     *
     * @param projectUUID
     *            GUID of a CRM Order Object
     */
    public void setProjectUUID( @Nullable final UUID projectUUID )
    {
        rememberChangedField("ProjectUUID", this.projectUUID);
        this.projectUUID = projectUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>Project</b>
     * </p>
     *
     * @param project
     *            Project ID
     */
    public void setProject( @Nullable final String project )
    {
        rememberChangedField("Project", this.project);
        this.project = project;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BusSolnOrdFUPEntProject";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ServiceDocumentRelationUUID", getServiceDocumentRelationUUID());
        result.put("ServiceDocRltnSequenceNumber", getServiceDocRltnSequenceNumber());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ServiceDocumentRelationUUID", getServiceDocumentRelationUUID());
        values.put("ServiceDocRltnSequenceNumber", getServiceDocRltnSequenceNumber());
        values.put("BusinessSolutionOrderUUID", getBusinessSolutionOrderUUID());
        values.put("BusinessSolutionOrder", getBusinessSolutionOrder());
        values.put("ProjectUUID", getProjectUUID());
        values.put("Project", getProject());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ServiceDocumentRelationUUID") ) {
                final Object value = values.remove("ServiceDocumentRelationUUID");
                if( (value == null) || (!value.equals(getServiceDocumentRelationUUID())) ) {
                    setServiceDocumentRelationUUID(((UUID) value));
                }
            }
            if( values.containsKey("ServiceDocRltnSequenceNumber") ) {
                final Object value = values.remove("ServiceDocRltnSequenceNumber");
                if( (value == null) || (!value.equals(getServiceDocRltnSequenceNumber())) ) {
                    setServiceDocRltnSequenceNumber(((String) value));
                }
            }
            if( values.containsKey("BusinessSolutionOrderUUID") ) {
                final Object value = values.remove("BusinessSolutionOrderUUID");
                if( (value == null) || (!value.equals(getBusinessSolutionOrderUUID())) ) {
                    setBusinessSolutionOrderUUID(((UUID) value));
                }
            }
            if( values.containsKey("BusinessSolutionOrder") ) {
                final Object value = values.remove("BusinessSolutionOrder");
                if( (value == null) || (!value.equals(getBusinessSolutionOrder())) ) {
                    setBusinessSolutionOrder(((String) value));
                }
            }
            if( values.containsKey("ProjectUUID") ) {
                final Object value = values.remove("ProjectUUID");
                if( (value == null) || (!value.equals(getProjectUUID())) ) {
                    setProjectUUID(((UUID) value));
                }
            }
            if( values.containsKey("Project") ) {
                final Object value = values.remove("Project");
                if( (value == null) || (!value.equals(getProject())) ) {
                    setProject(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> BusSolnOrdFUPEntProjectField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BusSolnOrdFUPEntProjectField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BusSolnOrdFUPEntProjectField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BusSolnOrdFUPEntProjectField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSolutionOrderService.DEFAULT_SERVICE_PATH);
    }

}
