/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.field.BusSolnOrdItemRelationshipsField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.selectable.BusSolnOrdItemRelationshipsSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Item Relationships
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BusSolnOrdItemRelationshipsType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BusSolnOrdItemRelationships extends VdmEntity<BusSolnOrdItemRelationships>
{

    /**
     * Selector for all available fields of BusSolnOrdItemRelationships.
     *
     */
    public final static BusSolnOrdItemRelationshipsSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrder</b>
     * </p>
     *
     * @return Transaction ID
     */
    @Key
    @SerializedName( "BusinessSolutionOrder" )
    @JsonProperty( "BusinessSolutionOrder" )
    @Nullable
    @ODataField( odataName = "BusinessSolutionOrder" )
    private String businessSolutionOrder;
    /**
     * Use with available fluent helpers to apply the <b>BusinessSolutionOrder</b> field to query operations.
     *
     */
    public final static BusSolnOrdItemRelationshipsField<String> BUSINESS_SOLUTION_ORDER =
        new BusSolnOrdItemRelationshipsField<String>("BusinessSolutionOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SrvcItemRelshpFromItemNumber</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @Key
    @SerializedName( "SrvcItemRelshpFromItemNumber" )
    @JsonProperty( "SrvcItemRelshpFromItemNumber" )
    @Nullable
    @ODataField( odataName = "SrvcItemRelshpFromItemNumber" )
    private String srvcItemRelshpFromItemNumber;
    /**
     * Use with available fluent helpers to apply the <b>SrvcItemRelshpFromItemNumber</b> field to query operations.
     *
     */
    public final static BusSolnOrdItemRelationshipsField<String> SRVC_ITEM_RELSHP_FROM_ITEM_NUMBER =
        new BusSolnOrdItemRelationshipsField<String>("SrvcItemRelshpFromItemNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SrvcItemRelshpType</b>
     * </p>
     *
     * @return Item Relationship Type
     */
    @Key
    @SerializedName( "SrvcItemRelshpType" )
    @JsonProperty( "SrvcItemRelshpType" )
    @Nullable
    @ODataField( odataName = "SrvcItemRelshpType" )
    private String srvcItemRelshpType;
    /**
     * Use with available fluent helpers to apply the <b>SrvcItemRelshpType</b> field to query operations.
     *
     */
    public final static BusSolnOrdItemRelationshipsField<String> SRVC_ITEM_RELSHP_TYPE =
        new BusSolnOrdItemRelationshipsField<String>("SrvcItemRelshpType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SrvcItemRelshpToItemNumber</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @Key
    @SerializedName( "SrvcItemRelshpToItemNumber" )
    @JsonProperty( "SrvcItemRelshpToItemNumber" )
    @Nullable
    @ODataField( odataName = "SrvcItemRelshpToItemNumber" )
    private String srvcItemRelshpToItemNumber;
    /**
     * Use with available fluent helpers to apply the <b>SrvcItemRelshpToItemNumber</b> field to query operations.
     *
     */
    public final static BusSolnOrdItemRelationshipsField<String> SRVC_ITEM_RELSHP_TO_ITEM_NUMBER =
        new BusSolnOrdItemRelationshipsField<String>("SrvcItemRelshpToItemNumber");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>SrvcItemRelshpFromTypeName</b>
     * </p>
     *
     * @return Name of Item Relationship (Forward)
     */
    @SerializedName( "SrvcItemRelshpFromTypeName" )
    @JsonProperty( "SrvcItemRelshpFromTypeName" )
    @Nullable
    @ODataField( odataName = "SrvcItemRelshpFromTypeName" )
    private String srvcItemRelshpFromTypeName;
    /**
     * Use with available fluent helpers to apply the <b>SrvcItemRelshpFromTypeName</b> field to query operations.
     *
     */
    public final static BusSolnOrdItemRelationshipsField<String> SRVC_ITEM_RELSHP_FROM_TYPE_NAME =
        new BusSolnOrdItemRelationshipsField<String>("SrvcItemRelshpFromTypeName");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>SrvcItemRelshpToTypeName</b>
     * </p>
     *
     * @return Name of Item Relationship (Backward)
     */
    @SerializedName( "SrvcItemRelshpToTypeName" )
    @JsonProperty( "SrvcItemRelshpToTypeName" )
    @Nullable
    @ODataField( odataName = "SrvcItemRelshpToTypeName" )
    private String srvcItemRelshpToTypeName;
    /**
     * Use with available fluent helpers to apply the <b>SrvcItemRelshpToTypeName</b> field to query operations.
     *
     */
    public final static BusSolnOrdItemRelationshipsField<String> SRVC_ITEM_RELSHP_TO_TYPE_NAME =
        new BusSolnOrdItemRelationshipsField<String>("SrvcItemRelshpToTypeName");

    @Nonnull
    @Override
    public Class<BusSolnOrdItemRelationships> getType()
    {
        return BusSolnOrdItemRelationships.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrder</b>
     * </p>
     *
     * @param businessSolutionOrder
     *            Transaction ID
     */
    public void setBusinessSolutionOrder( @Nullable final String businessSolutionOrder )
    {
        rememberChangedField("BusinessSolutionOrder", this.businessSolutionOrder);
        this.businessSolutionOrder = businessSolutionOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SrvcItemRelshpFromItemNumber</b>
     * </p>
     *
     * @param srvcItemRelshpFromItemNumber
     *            Shortened Item Number in Document
     */
    public void setSrvcItemRelshpFromItemNumber( @Nullable final String srvcItemRelshpFromItemNumber )
    {
        rememberChangedField("SrvcItemRelshpFromItemNumber", this.srvcItemRelshpFromItemNumber);
        this.srvcItemRelshpFromItemNumber = srvcItemRelshpFromItemNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SrvcItemRelshpType</b>
     * </p>
     *
     * @param srvcItemRelshpType
     *            Item Relationship Type
     */
    public void setSrvcItemRelshpType( @Nullable final String srvcItemRelshpType )
    {
        rememberChangedField("SrvcItemRelshpType", this.srvcItemRelshpType);
        this.srvcItemRelshpType = srvcItemRelshpType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SrvcItemRelshpToItemNumber</b>
     * </p>
     *
     * @param srvcItemRelshpToItemNumber
     *            Shortened Item Number in Document
     */
    public void setSrvcItemRelshpToItemNumber( @Nullable final String srvcItemRelshpToItemNumber )
    {
        rememberChangedField("SrvcItemRelshpToItemNumber", this.srvcItemRelshpToItemNumber);
        this.srvcItemRelshpToItemNumber = srvcItemRelshpToItemNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>SrvcItemRelshpFromTypeName</b>
     * </p>
     *
     * @param srvcItemRelshpFromTypeName
     *            Name of Item Relationship (Forward)
     */
    public void setSrvcItemRelshpFromTypeName( @Nullable final String srvcItemRelshpFromTypeName )
    {
        rememberChangedField("SrvcItemRelshpFromTypeName", this.srvcItemRelshpFromTypeName);
        this.srvcItemRelshpFromTypeName = srvcItemRelshpFromTypeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>SrvcItemRelshpToTypeName</b>
     * </p>
     *
     * @param srvcItemRelshpToTypeName
     *            Name of Item Relationship (Backward)
     */
    public void setSrvcItemRelshpToTypeName( @Nullable final String srvcItemRelshpToTypeName )
    {
        rememberChangedField("SrvcItemRelshpToTypeName", this.srvcItemRelshpToTypeName);
        this.srvcItemRelshpToTypeName = srvcItemRelshpToTypeName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BusSolnOrdItemRelationships";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BusinessSolutionOrder", getBusinessSolutionOrder());
        result.put("SrvcItemRelshpFromItemNumber", getSrvcItemRelshpFromItemNumber());
        result.put("SrvcItemRelshpType", getSrvcItemRelshpType());
        result.put("SrvcItemRelshpToItemNumber", getSrvcItemRelshpToItemNumber());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BusinessSolutionOrder", getBusinessSolutionOrder());
        values.put("SrvcItemRelshpFromItemNumber", getSrvcItemRelshpFromItemNumber());
        values.put("SrvcItemRelshpType", getSrvcItemRelshpType());
        values.put("SrvcItemRelshpToItemNumber", getSrvcItemRelshpToItemNumber());
        values.put("SrvcItemRelshpFromTypeName", getSrvcItemRelshpFromTypeName());
        values.put("SrvcItemRelshpToTypeName", getSrvcItemRelshpToTypeName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BusinessSolutionOrder") ) {
                final Object value = values.remove("BusinessSolutionOrder");
                if( (value == null) || (!value.equals(getBusinessSolutionOrder())) ) {
                    setBusinessSolutionOrder(((String) value));
                }
            }
            if( values.containsKey("SrvcItemRelshpFromItemNumber") ) {
                final Object value = values.remove("SrvcItemRelshpFromItemNumber");
                if( (value == null) || (!value.equals(getSrvcItemRelshpFromItemNumber())) ) {
                    setSrvcItemRelshpFromItemNumber(((String) value));
                }
            }
            if( values.containsKey("SrvcItemRelshpType") ) {
                final Object value = values.remove("SrvcItemRelshpType");
                if( (value == null) || (!value.equals(getSrvcItemRelshpType())) ) {
                    setSrvcItemRelshpType(((String) value));
                }
            }
            if( values.containsKey("SrvcItemRelshpToItemNumber") ) {
                final Object value = values.remove("SrvcItemRelshpToItemNumber");
                if( (value == null) || (!value.equals(getSrvcItemRelshpToItemNumber())) ) {
                    setSrvcItemRelshpToItemNumber(((String) value));
                }
            }
            if( values.containsKey("SrvcItemRelshpFromTypeName") ) {
                final Object value = values.remove("SrvcItemRelshpFromTypeName");
                if( (value == null) || (!value.equals(getSrvcItemRelshpFromTypeName())) ) {
                    setSrvcItemRelshpFromTypeName(((String) value));
                }
            }
            if( values.containsKey("SrvcItemRelshpToTypeName") ) {
                final Object value = values.remove("SrvcItemRelshpToTypeName");
                if( (value == null) || (!value.equals(getSrvcItemRelshpToTypeName())) ) {
                    setSrvcItemRelshpToTypeName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> BusSolnOrdItemRelationshipsField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new BusSolnOrdItemRelationshipsField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BusSolnOrdItemRelationshipsField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BusSolnOrdItemRelationshipsField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSolutionOrderService.DEFAULT_SERVICE_PATH);
    }

}
