/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.field.BusSolnOrdItmConfigurationField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.selectable.BusSolnOrdItmConfigurationSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Solution Order Item Configuration
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BusSolnOrdItmConfigurationType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BusSolnOrdItmConfiguration extends VdmEntity<BusSolnOrdItmConfiguration>
{

    /**
     * Selector for all available fields of BusSolnOrdItmConfiguration.
     *
     */
    public final static BusSolnOrdItmConfigurationSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>VarConfignInstceBusObjectKey</b>
     * </p>
     *
     * @return IB: Key of a Referencing Object
     */
    @Key
    @SerializedName( "VarConfignInstceBusObjectKey" )
    @JsonProperty( "VarConfignInstceBusObjectKey" )
    @Nullable
    @ODataField( odataName = "VarConfignInstceBusObjectKey" )
    private String varConfignInstceBusObjectKey;
    /**
     * Use with available fluent helpers to apply the <b>VarConfignInstceBusObjectKey</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmConfigurationField<String> VAR_CONFIGN_INSTCE_BUS_OBJECT_KEY =
        new BusSolnOrdItmConfigurationField<String>("VarConfignInstceBusObjectKey");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>VarConfignInstceBusObjectType</b>
     * </p>
     *
     * @return IB: External Type of a (Referencing) Object
     */
    @Key
    @SerializedName( "VarConfignInstceBusObjectType" )
    @JsonProperty( "VarConfignInstceBusObjectType" )
    @Nullable
    @ODataField( odataName = "VarConfignInstceBusObjectType" )
    private String varConfignInstceBusObjectType;
    /**
     * Use with available fluent helpers to apply the <b>VarConfignInstceBusObjectType</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmConfigurationField<String> VAR_CONFIGN_INSTCE_BUS_OBJECT_TYPE =
        new BusSolnOrdItmConfigurationField<String>("VarConfignInstceBusObjectType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>VariantConfigurationInstance</b>
     * </p>
     *
     * @return IB: Component (instance)
     */
    @Key
    @SerializedName( "VariantConfigurationInstance" )
    @JsonProperty( "VariantConfigurationInstance" )
    @Nullable
    @ODataField( odataName = "VariantConfigurationInstance" )
    private String variantConfigurationInstance;
    /**
     * Use with available fluent helpers to apply the <b>VariantConfigurationInstance</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmConfigurationField<String> VARIANT_CONFIGURATION_INSTANCE =
        new BusSolnOrdItmConfigurationField<String>("VariantConfigurationInstance");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CharcInternalID</b>
     * </p>
     *
     * @return Characteristic Internal ID
     */
    @Key
    @SerializedName( "CharcInternalID" )
    @JsonProperty( "CharcInternalID" )
    @Nullable
    @ODataField( odataName = "CharcInternalID" )
    private String charcInternalID;
    /**
     * Use with available fluent helpers to apply the <b>CharcInternalID</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmConfigurationField<String> CHARC_INTERNAL_ID =
        new BusSolnOrdItmConfigurationField<String>("CharcInternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>CharcValue</b>
     * </p>
     *
     * @return Characteristic Value
     */
    @Key
    @SerializedName( "CharcValue" )
    @JsonProperty( "CharcValue" )
    @Nullable
    @ODataField( odataName = "CharcValue" )
    private String charcValue;
    /**
     * Use with available fluent helpers to apply the <b>CharcValue</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmConfigurationField<String> CHARC_VALUE =
        new BusSolnOrdItmConfigurationField<String>("CharcValue");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CharcFromNumericValue</b>
     * </p>
     *
     * @return Internal floating point from
     */
    @Key
    @SerializedName( "CharcFromNumericValue" )
    @JsonProperty( "CharcFromNumericValue" )
    @Nullable
    @ODataField( odataName = "CharcFromNumericValue" )
    private Double charcFromNumericValue;
    /**
     * Use with available fluent helpers to apply the <b>CharcFromNumericValue</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmConfigurationField<Double> CHARC_FROM_NUMERIC_VALUE =
        new BusSolnOrdItmConfigurationField<Double>("CharcFromNumericValue");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CharcToNumericValue</b>
     * </p>
     *
     * @return Internal floating point value to
     */
    @Key
    @SerializedName( "CharcToNumericValue" )
    @JsonProperty( "CharcToNumericValue" )
    @Nullable
    @ODataField( odataName = "CharcToNumericValue" )
    private Double charcToNumericValue;
    /**
     * Use with available fluent helpers to apply the <b>CharcToNumericValue</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmConfigurationField<Double> CHARC_TO_NUMERIC_VALUE =
        new BusSolnOrdItmConfigurationField<Double>("CharcToNumericValue");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CharcReferenceTable</b>
     * </p>
     *
     * @return Table Name
     */
    @SerializedName( "CharcReferenceTable" )
    @JsonProperty( "CharcReferenceTable" )
    @Nullable
    @ODataField( odataName = "CharcReferenceTable" )
    private String charcReferenceTable;
    /**
     * Use with available fluent helpers to apply the <b>CharcReferenceTable</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmConfigurationField<String> CHARC_REFERENCE_TABLE =
        new BusSolnOrdItmConfigurationField<String>("CharcReferenceTable");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CharcReferenceTableField</b>
     * </p>
     *
     * @return Field Name
     */
    @SerializedName( "CharcReferenceTableField" )
    @JsonProperty( "CharcReferenceTableField" )
    @Nullable
    @ODataField( odataName = "CharcReferenceTableField" )
    private String charcReferenceTableField;
    /**
     * Use with available fluent helpers to apply the <b>CharcReferenceTableField</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmConfigurationField<String> CHARC_REFERENCE_TABLE_FIELD =
        new BusSolnOrdItmConfigurationField<String>("CharcReferenceTableField");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>Characteristic</b>
     * </p>
     *
     * @return Characteristic Name
     */
    @SerializedName( "Characteristic" )
    @JsonProperty( "Characteristic" )
    @Nullable
    @ODataField( odataName = "Characteristic" )
    private String characteristic;
    /**
     * Use with available fluent helpers to apply the <b>Characteristic</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmConfigurationField<String> CHARACTERISTIC =
        new BusSolnOrdItmConfigurationField<String>("Characteristic");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>CharcValueAsCharacterValue</b>
     * </p>
     *
     * @return Characteristic Value
     */
    @SerializedName( "CharcValueAsCharacterValue" )
    @JsonProperty( "CharcValueAsCharacterValue" )
    @Nullable
    @ODataField( odataName = "CharcValueAsCharacterValue" )
    private String charcValueAsCharacterValue;
    /**
     * Use with available fluent helpers to apply the <b>CharcValueAsCharacterValue</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmConfigurationField<String> CHARC_VALUE_AS_CHARACTER_VALUE =
        new BusSolnOrdItmConfigurationField<String>("CharcValueAsCharacterValue");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CharcValueAssignmentType</b>
     * </p>
     *
     * @return Characteristic Value Assignment Type for API access (input)
     */
    @SerializedName( "CharcValueAssignmentType" )
    @JsonProperty( "CharcValueAssignmentType" )
    @Nullable
    @ODataField( odataName = "CharcValueAssignmentType" )
    private String charcValueAssignmentType;
    /**
     * Use with available fluent helpers to apply the <b>CharcValueAssignmentType</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmConfigurationField<String> CHARC_VALUE_ASSIGNMENT_TYPE =
        new BusSolnOrdItmConfigurationField<String>("CharcValueAssignmentType");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>VariantConditionFactor</b>
     * </p>
     *
     * @return Variant Condition Factor
     */
    @SerializedName( "VariantConditionFactor" )
    @JsonProperty( "VariantConditionFactor" )
    @Nullable
    @ODataField( odataName = "VariantConditionFactor" )
    private String variantConditionFactor;
    /**
     * Use with available fluent helpers to apply the <b>VariantConditionFactor</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmConfigurationField<String> VARIANT_CONDITION_FACTOR =
        new BusSolnOrdItmConfigurationField<String>("VariantConditionFactor");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>VariantConfigurationDate</b>
     * </p>
     *
     * @return Valid-From Date
     */
    @SerializedName( "VariantConfigurationDate" )
    @JsonProperty( "VariantConfigurationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "VariantConfigurationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime variantConfigurationDate;
    /**
     * Use with available fluent helpers to apply the <b>VariantConfigurationDate</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmConfigurationField<LocalDateTime> VARIANT_CONFIGURATION_DATE =
        new BusSolnOrdItmConfigurationField<LocalDateTime>("VariantConfigurationDate");

    @Nonnull
    @Override
    public Class<BusSolnOrdItmConfiguration> getType()
    {
        return BusSolnOrdItmConfiguration.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>VarConfignInstceBusObjectKey</b>
     * </p>
     *
     * @param varConfignInstceBusObjectKey
     *            IB: Key of a Referencing Object
     */
    public void setVarConfignInstceBusObjectKey( @Nullable final String varConfignInstceBusObjectKey )
    {
        rememberChangedField("VarConfignInstceBusObjectKey", this.varConfignInstceBusObjectKey);
        this.varConfignInstceBusObjectKey = varConfignInstceBusObjectKey;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>VarConfignInstceBusObjectType</b>
     * </p>
     *
     * @param varConfignInstceBusObjectType
     *            IB: External Type of a (Referencing) Object
     */
    public void setVarConfignInstceBusObjectType( @Nullable final String varConfignInstceBusObjectType )
    {
        rememberChangedField("VarConfignInstceBusObjectType", this.varConfignInstceBusObjectType);
        this.varConfignInstceBusObjectType = varConfignInstceBusObjectType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>VariantConfigurationInstance</b>
     * </p>
     *
     * @param variantConfigurationInstance
     *            IB: Component (instance)
     */
    public void setVariantConfigurationInstance( @Nullable final String variantConfigurationInstance )
    {
        rememberChangedField("VariantConfigurationInstance", this.variantConfigurationInstance);
        this.variantConfigurationInstance = variantConfigurationInstance;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CharcInternalID</b>
     * </p>
     *
     * @param charcInternalID
     *            Characteristic Internal ID
     */
    public void setCharcInternalID( @Nullable final String charcInternalID )
    {
        rememberChangedField("CharcInternalID", this.charcInternalID);
        this.charcInternalID = charcInternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>CharcValue</b>
     * </p>
     *
     * @param charcValue
     *            Characteristic Value
     */
    public void setCharcValue( @Nullable final String charcValue )
    {
        rememberChangedField("CharcValue", this.charcValue);
        this.charcValue = charcValue;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CharcFromNumericValue</b>
     * </p>
     *
     * @param charcFromNumericValue
     *            Internal floating point from
     */
    public void setCharcFromNumericValue( @Nullable final Double charcFromNumericValue )
    {
        rememberChangedField("CharcFromNumericValue", this.charcFromNumericValue);
        this.charcFromNumericValue = charcFromNumericValue;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CharcToNumericValue</b>
     * </p>
     *
     * @param charcToNumericValue
     *            Internal floating point value to
     */
    public void setCharcToNumericValue( @Nullable final Double charcToNumericValue )
    {
        rememberChangedField("CharcToNumericValue", this.charcToNumericValue);
        this.charcToNumericValue = charcToNumericValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CharcReferenceTable</b>
     * </p>
     *
     * @param charcReferenceTable
     *            Table Name
     */
    public void setCharcReferenceTable( @Nullable final String charcReferenceTable )
    {
        rememberChangedField("CharcReferenceTable", this.charcReferenceTable);
        this.charcReferenceTable = charcReferenceTable;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CharcReferenceTableField</b>
     * </p>
     *
     * @param charcReferenceTableField
     *            Field Name
     */
    public void setCharcReferenceTableField( @Nullable final String charcReferenceTableField )
    {
        rememberChangedField("CharcReferenceTableField", this.charcReferenceTableField);
        this.charcReferenceTableField = charcReferenceTableField;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>Characteristic</b>
     * </p>
     *
     * @param characteristic
     *            Characteristic Name
     */
    public void setCharacteristic( @Nullable final String characteristic )
    {
        rememberChangedField("Characteristic", this.characteristic);
        this.characteristic = characteristic;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>CharcValueAsCharacterValue</b>
     * </p>
     *
     * @param charcValueAsCharacterValue
     *            Characteristic Value
     */
    public void setCharcValueAsCharacterValue( @Nullable final String charcValueAsCharacterValue )
    {
        rememberChangedField("CharcValueAsCharacterValue", this.charcValueAsCharacterValue);
        this.charcValueAsCharacterValue = charcValueAsCharacterValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CharcValueAssignmentType</b>
     * </p>
     *
     * @param charcValueAssignmentType
     *            Characteristic Value Assignment Type for API access (input)
     */
    public void setCharcValueAssignmentType( @Nullable final String charcValueAssignmentType )
    {
        rememberChangedField("CharcValueAssignmentType", this.charcValueAssignmentType);
        this.charcValueAssignmentType = charcValueAssignmentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>VariantConditionFactor</b>
     * </p>
     *
     * @param variantConditionFactor
     *            Variant Condition Factor
     */
    public void setVariantConditionFactor( @Nullable final String variantConditionFactor )
    {
        rememberChangedField("VariantConditionFactor", this.variantConditionFactor);
        this.variantConditionFactor = variantConditionFactor;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>VariantConfigurationDate</b>
     * </p>
     *
     * @param variantConfigurationDate
     *            Valid-From Date
     */
    public void setVariantConfigurationDate( @Nullable final LocalDateTime variantConfigurationDate )
    {
        rememberChangedField("VariantConfigurationDate", this.variantConfigurationDate);
        this.variantConfigurationDate = variantConfigurationDate;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BusSolnOrdItmConfiguration";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("VarConfignInstceBusObjectKey", getVarConfignInstceBusObjectKey());
        result.put("VarConfignInstceBusObjectType", getVarConfignInstceBusObjectType());
        result.put("VariantConfigurationInstance", getVariantConfigurationInstance());
        result.put("CharcInternalID", getCharcInternalID());
        result.put("CharcValue", getCharcValue());
        result.put("CharcFromNumericValue", getCharcFromNumericValue());
        result.put("CharcToNumericValue", getCharcToNumericValue());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("VarConfignInstceBusObjectKey", getVarConfignInstceBusObjectKey());
        values.put("VarConfignInstceBusObjectType", getVarConfignInstceBusObjectType());
        values.put("VariantConfigurationInstance", getVariantConfigurationInstance());
        values.put("CharcInternalID", getCharcInternalID());
        values.put("CharcValue", getCharcValue());
        values.put("CharcFromNumericValue", getCharcFromNumericValue());
        values.put("CharcToNumericValue", getCharcToNumericValue());
        values.put("CharcReferenceTable", getCharcReferenceTable());
        values.put("CharcReferenceTableField", getCharcReferenceTableField());
        values.put("Characteristic", getCharacteristic());
        values.put("CharcValueAsCharacterValue", getCharcValueAsCharacterValue());
        values.put("CharcValueAssignmentType", getCharcValueAssignmentType());
        values.put("VariantConditionFactor", getVariantConditionFactor());
        values.put("VariantConfigurationDate", getVariantConfigurationDate());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("VarConfignInstceBusObjectKey") ) {
                final Object value = values.remove("VarConfignInstceBusObjectKey");
                if( (value == null) || (!value.equals(getVarConfignInstceBusObjectKey())) ) {
                    setVarConfignInstceBusObjectKey(((String) value));
                }
            }
            if( values.containsKey("VarConfignInstceBusObjectType") ) {
                final Object value = values.remove("VarConfignInstceBusObjectType");
                if( (value == null) || (!value.equals(getVarConfignInstceBusObjectType())) ) {
                    setVarConfignInstceBusObjectType(((String) value));
                }
            }
            if( values.containsKey("VariantConfigurationInstance") ) {
                final Object value = values.remove("VariantConfigurationInstance");
                if( (value == null) || (!value.equals(getVariantConfigurationInstance())) ) {
                    setVariantConfigurationInstance(((String) value));
                }
            }
            if( values.containsKey("CharcInternalID") ) {
                final Object value = values.remove("CharcInternalID");
                if( (value == null) || (!value.equals(getCharcInternalID())) ) {
                    setCharcInternalID(((String) value));
                }
            }
            if( values.containsKey("CharcValue") ) {
                final Object value = values.remove("CharcValue");
                if( (value == null) || (!value.equals(getCharcValue())) ) {
                    setCharcValue(((String) value));
                }
            }
            if( values.containsKey("CharcFromNumericValue") ) {
                final Object value = values.remove("CharcFromNumericValue");
                if( (value == null) || (!value.equals(getCharcFromNumericValue())) ) {
                    setCharcFromNumericValue(((Double) value));
                }
            }
            if( values.containsKey("CharcToNumericValue") ) {
                final Object value = values.remove("CharcToNumericValue");
                if( (value == null) || (!value.equals(getCharcToNumericValue())) ) {
                    setCharcToNumericValue(((Double) value));
                }
            }
            if( values.containsKey("CharcReferenceTable") ) {
                final Object value = values.remove("CharcReferenceTable");
                if( (value == null) || (!value.equals(getCharcReferenceTable())) ) {
                    setCharcReferenceTable(((String) value));
                }
            }
            if( values.containsKey("CharcReferenceTableField") ) {
                final Object value = values.remove("CharcReferenceTableField");
                if( (value == null) || (!value.equals(getCharcReferenceTableField())) ) {
                    setCharcReferenceTableField(((String) value));
                }
            }
            if( values.containsKey("Characteristic") ) {
                final Object value = values.remove("Characteristic");
                if( (value == null) || (!value.equals(getCharacteristic())) ) {
                    setCharacteristic(((String) value));
                }
            }
            if( values.containsKey("CharcValueAsCharacterValue") ) {
                final Object value = values.remove("CharcValueAsCharacterValue");
                if( (value == null) || (!value.equals(getCharcValueAsCharacterValue())) ) {
                    setCharcValueAsCharacterValue(((String) value));
                }
            }
            if( values.containsKey("CharcValueAssignmentType") ) {
                final Object value = values.remove("CharcValueAssignmentType");
                if( (value == null) || (!value.equals(getCharcValueAssignmentType())) ) {
                    setCharcValueAssignmentType(((String) value));
                }
            }
            if( values.containsKey("VariantConditionFactor") ) {
                final Object value = values.remove("VariantConditionFactor");
                if( (value == null) || (!value.equals(getVariantConditionFactor())) ) {
                    setVariantConditionFactor(((String) value));
                }
            }
            if( values.containsKey("VariantConfigurationDate") ) {
                final Object value = values.remove("VariantConfigurationDate");
                if( (value == null) || (!value.equals(getVariantConfigurationDate())) ) {
                    setVariantConfigurationDate(((LocalDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> BusSolnOrdItmConfigurationField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new BusSolnOrdItmConfigurationField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BusSolnOrdItmConfigurationField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BusSolnOrdItmConfigurationField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSolutionOrderService.DEFAULT_SERVICE_PATH);
    }

}
