/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.selectable.BusSolnOrdItmConfigurationSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmConfiguration
 * BusSolnOrdItmConfiguration} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class BusSolnOrdItmConfigurationByKeyFluentHelper
    extends
    FluentHelperByKey<BusSolnOrdItmConfigurationByKeyFluentHelper, BusSolnOrdItmConfiguration, BusSolnOrdItmConfigurationSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmConfiguration
     * BusSolnOrdItmConfiguration} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code BusSolnOrdItmConfiguration}
     * @param charcValue
     *            Characteristic Value
     *            <p>
     *            Constraints: Not nullable, Maximum length: 70
     *            </p>
     * @param varConfignInstceBusObjectKey
     *            IB: Key of a Referencing Object
     *            <p>
     *            Constraints: Not nullable, Maximum length: 50
     *            </p>
     * @param charcInternalID
     *            Characteristic Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code BusSolnOrdItmConfiguration}
     * @param charcFromNumericValue
     *            Internal floating point from
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param variantConfigurationInstance
     *            IB: Component (instance)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param charcToNumericValue
     *            Internal floating point value to
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param varConfignInstceBusObjectType
     *            IB: External Type of a (Referencing) Object
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     */
    public BusSolnOrdItmConfigurationByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String varConfignInstceBusObjectKey,
        final String varConfignInstceBusObjectType,
        final String variantConfigurationInstance,
        final String charcInternalID,
        final String charcValue,
        final Double charcFromNumericValue,
        final Double charcToNumericValue )
    {
        super(servicePath, entityCollection);
        this.key.put("VarConfignInstceBusObjectKey", varConfignInstceBusObjectKey);
        this.key.put("VarConfignInstceBusObjectType", varConfignInstceBusObjectType);
        this.key.put("VariantConfigurationInstance", variantConfigurationInstance);
        this.key.put("CharcInternalID", charcInternalID);
        this.key.put("CharcValue", charcValue);
        this.key.put("CharcFromNumericValue", charcFromNumericValue);
        this.key.put("CharcToNumericValue", charcToNumericValue);
    }

    @Override
    @Nonnull
    protected Class<BusSolnOrdItmConfiguration> getEntityClass()
    {
        return BusSolnOrdItmConfiguration.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
