/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.field.BusSolnOrdItmFUPEntProjectField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.selectable.BusSolnOrdItmFUPEntProjectSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Follow up Enterprise Project Items
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BusSolnOrdItmFUPEntProjectType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BusSolnOrdItmFUPEntProject extends VdmEntity<BusSolnOrdItmFUPEntProject>
{

    /**
     * Selector for all available fields of BusSolnOrdItmFUPEntProject.
     *
     */
    public final static BusSolnOrdItmFUPEntProjectSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItmRelationUUID</b>
     * </p>
     *
     * @return Object Relationship Service : GUID binary link
     */
    @Key
    @SerializedName( "ServiceDocumentItmRelationUUID" )
    @JsonProperty( "ServiceDocumentItmRelationUUID" )
    @Nullable
    @ODataField( odataName = "ServiceDocumentItmRelationUUID" )
    private UUID serviceDocumentItmRelationUUID;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocumentItmRelationUUID</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmFUPEntProjectField<UUID> SERVICE_DOCUMENT_ITM_RELATION_UUID =
        new BusSolnOrdItmFUPEntProjectField<UUID>("ServiceDocumentItmRelationUUID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocItmRltnSqncNumber</b>
     * </p>
     *
     * @return Sequential Number of Segment in IDoc Type
     */
    @Key
    @SerializedName( "ServiceDocItmRltnSqncNumber" )
    @JsonProperty( "ServiceDocItmRltnSqncNumber" )
    @Nullable
    @ODataField( odataName = "ServiceDocItmRltnSqncNumber" )
    private String serviceDocItmRltnSqncNumber;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocItmRltnSqncNumber</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmFUPEntProjectField<String> SERVICE_DOC_ITM_RLTN_SQNC_NUMBER =
        new BusSolnOrdItmFUPEntProjectField<String>("ServiceDocItmRltnSqncNumber");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrder</b>
     * </p>
     *
     * @return Transaction ID
     */
    @SerializedName( "BusinessSolutionOrder" )
    @JsonProperty( "BusinessSolutionOrder" )
    @Nullable
    @ODataField( odataName = "BusinessSolutionOrder" )
    private String businessSolutionOrder;
    /**
     * Use with available fluent helpers to apply the <b>BusinessSolutionOrder</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmFUPEntProjectField<String> BUSINESS_SOLUTION_ORDER =
        new BusSolnOrdItmFUPEntProjectField<String>("BusinessSolutionOrder");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrderItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @SerializedName( "BusinessSolutionOrderItem" )
    @JsonProperty( "BusinessSolutionOrderItem" )
    @Nullable
    @ODataField( odataName = "BusinessSolutionOrderItem" )
    private String businessSolutionOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>BusinessSolutionOrderItem</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmFUPEntProjectField<String> BUSINESS_SOLUTION_ORDER_ITEM =
        new BusSolnOrdItmFUPEntProjectField<String>("BusinessSolutionOrderItem");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectUUID</b>
     * </p>
     *
     * @return GUID of a CRM Order Object
     */
    @SerializedName( "ProjectUUID" )
    @JsonProperty( "ProjectUUID" )
    @Nullable
    @ODataField( odataName = "ProjectUUID" )
    private UUID projectUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectUUID</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmFUPEntProjectField<UUID> PROJECT_UUID =
        new BusSolnOrdItmFUPEntProjectField<UUID>("ProjectUUID");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>Project</b>
     * </p>
     *
     * @return Project ID
     */
    @SerializedName( "Project" )
    @JsonProperty( "Project" )
    @Nullable
    @ODataField( odataName = "Project" )
    private String project;
    /**
     * Use with available fluent helpers to apply the <b>Project</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmFUPEntProjectField<String> PROJECT =
        new BusSolnOrdItmFUPEntProjectField<String>("Project");

    @Nonnull
    @Override
    public Class<BusSolnOrdItmFUPEntProject> getType()
    {
        return BusSolnOrdItmFUPEntProject.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItmRelationUUID</b>
     * </p>
     *
     * @param serviceDocumentItmRelationUUID
     *            Object Relationship Service : GUID binary link
     */
    public void setServiceDocumentItmRelationUUID( @Nullable final UUID serviceDocumentItmRelationUUID )
    {
        rememberChangedField("ServiceDocumentItmRelationUUID", this.serviceDocumentItmRelationUUID);
        this.serviceDocumentItmRelationUUID = serviceDocumentItmRelationUUID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocItmRltnSqncNumber</b>
     * </p>
     *
     * @param serviceDocItmRltnSqncNumber
     *            Sequential Number of Segment in IDoc Type
     */
    public void setServiceDocItmRltnSqncNumber( @Nullable final String serviceDocItmRltnSqncNumber )
    {
        rememberChangedField("ServiceDocItmRltnSqncNumber", this.serviceDocItmRltnSqncNumber);
        this.serviceDocItmRltnSqncNumber = serviceDocItmRltnSqncNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrder</b>
     * </p>
     *
     * @param businessSolutionOrder
     *            Transaction ID
     */
    public void setBusinessSolutionOrder( @Nullable final String businessSolutionOrder )
    {
        rememberChangedField("BusinessSolutionOrder", this.businessSolutionOrder);
        this.businessSolutionOrder = businessSolutionOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrderItem</b>
     * </p>
     *
     * @param businessSolutionOrderItem
     *            Shortened Item Number in Document
     */
    public void setBusinessSolutionOrderItem( @Nullable final String businessSolutionOrderItem )
    {
        rememberChangedField("BusinessSolutionOrderItem", this.businessSolutionOrderItem);
        this.businessSolutionOrderItem = businessSolutionOrderItem;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectUUID</b>
     * </p>
     *
     * @param projectUUID
     *            GUID of a CRM Order Object
     */
    public void setProjectUUID( @Nullable final UUID projectUUID )
    {
        rememberChangedField("ProjectUUID", this.projectUUID);
        this.projectUUID = projectUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>Project</b>
     * </p>
     *
     * @param project
     *            Project ID
     */
    public void setProject( @Nullable final String project )
    {
        rememberChangedField("Project", this.project);
        this.project = project;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BusSolnOrdItmFUPEntProject";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ServiceDocumentItmRelationUUID", getServiceDocumentItmRelationUUID());
        result.put("ServiceDocItmRltnSqncNumber", getServiceDocItmRltnSqncNumber());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ServiceDocumentItmRelationUUID", getServiceDocumentItmRelationUUID());
        values.put("ServiceDocItmRltnSqncNumber", getServiceDocItmRltnSqncNumber());
        values.put("BusinessSolutionOrder", getBusinessSolutionOrder());
        values.put("BusinessSolutionOrderItem", getBusinessSolutionOrderItem());
        values.put("ProjectUUID", getProjectUUID());
        values.put("Project", getProject());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ServiceDocumentItmRelationUUID") ) {
                final Object value = values.remove("ServiceDocumentItmRelationUUID");
                if( (value == null) || (!value.equals(getServiceDocumentItmRelationUUID())) ) {
                    setServiceDocumentItmRelationUUID(((UUID) value));
                }
            }
            if( values.containsKey("ServiceDocItmRltnSqncNumber") ) {
                final Object value = values.remove("ServiceDocItmRltnSqncNumber");
                if( (value == null) || (!value.equals(getServiceDocItmRltnSqncNumber())) ) {
                    setServiceDocItmRltnSqncNumber(((String) value));
                }
            }
            if( values.containsKey("BusinessSolutionOrder") ) {
                final Object value = values.remove("BusinessSolutionOrder");
                if( (value == null) || (!value.equals(getBusinessSolutionOrder())) ) {
                    setBusinessSolutionOrder(((String) value));
                }
            }
            if( values.containsKey("BusinessSolutionOrderItem") ) {
                final Object value = values.remove("BusinessSolutionOrderItem");
                if( (value == null) || (!value.equals(getBusinessSolutionOrderItem())) ) {
                    setBusinessSolutionOrderItem(((String) value));
                }
            }
            if( values.containsKey("ProjectUUID") ) {
                final Object value = values.remove("ProjectUUID");
                if( (value == null) || (!value.equals(getProjectUUID())) ) {
                    setProjectUUID(((UUID) value));
                }
            }
            if( values.containsKey("Project") ) {
                final Object value = values.remove("Project");
                if( (value == null) || (!value.equals(getProject())) ) {
                    setProject(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> BusSolnOrdItmFUPEntProjectField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new BusSolnOrdItmFUPEntProjectField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BusSolnOrdItmFUPEntProjectField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BusSolnOrdItmFUPEntProjectField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSolutionOrderService.DEFAULT_SERVICE_PATH);
    }

}
