/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.field.BusSolnOrdItmFUPSalesOrderField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.selectable.BusSolnOrdItmFUPSalesOrderSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Follow-up Sales Order Items
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BusSolnOrdItmFUPSalesOrderType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BusSolnOrdItmFUPSalesOrder extends VdmEntity<BusSolnOrdItmFUPSalesOrder>
{

    /**
     * Selector for all available fields of BusSolnOrdItmFUPSalesOrder.
     *
     */
    public final static BusSolnOrdItmFUPSalesOrderSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItmRelationUUID</b>
     * </p>
     *
     * @return Object Relationship Service : GUID binary link
     */
    @Key
    @SerializedName( "ServiceDocumentItmRelationUUID" )
    @JsonProperty( "ServiceDocumentItmRelationUUID" )
    @Nullable
    @ODataField( odataName = "ServiceDocumentItmRelationUUID" )
    private UUID serviceDocumentItmRelationUUID;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocumentItmRelationUUID</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmFUPSalesOrderField<UUID> SERVICE_DOCUMENT_ITM_RELATION_UUID =
        new BusSolnOrdItmFUPSalesOrderField<UUID>("ServiceDocumentItmRelationUUID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocItmRltnSqncNumber</b>
     * </p>
     *
     * @return Sequential Number of Segment in IDoc Type
     */
    @Key
    @SerializedName( "ServiceDocItmRltnSqncNumber" )
    @JsonProperty( "ServiceDocItmRltnSqncNumber" )
    @Nullable
    @ODataField( odataName = "ServiceDocItmRltnSqncNumber" )
    private String serviceDocItmRltnSqncNumber;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocItmRltnSqncNumber</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmFUPSalesOrderField<String> SERVICE_DOC_ITM_RLTN_SQNC_NUMBER =
        new BusSolnOrdItmFUPSalesOrderField<String>("ServiceDocItmRltnSqncNumber");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrderUUID</b>
     * </p>
     *
     * @return 32 Character CRM Object GUID
     */
    @SerializedName( "BusinessSolutionOrderUUID" )
    @JsonProperty( "BusinessSolutionOrderUUID" )
    @Nullable
    @ODataField( odataName = "BusinessSolutionOrderUUID" )
    private UUID businessSolutionOrderUUID;
    /**
     * Use with available fluent helpers to apply the <b>BusinessSolutionOrderUUID</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmFUPSalesOrderField<UUID> BUSINESS_SOLUTION_ORDER_UUID =
        new BusSolnOrdItmFUPSalesOrderField<UUID>("BusinessSolutionOrderUUID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrder</b>
     * </p>
     *
     * @return Transaction ID
     */
    @SerializedName( "BusinessSolutionOrder" )
    @JsonProperty( "BusinessSolutionOrder" )
    @Nullable
    @ODataField( odataName = "BusinessSolutionOrder" )
    private String businessSolutionOrder;
    /**
     * Use with available fluent helpers to apply the <b>BusinessSolutionOrder</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmFUPSalesOrderField<String> BUSINESS_SOLUTION_ORDER =
        new BusSolnOrdItmFUPSalesOrderField<String>("BusinessSolutionOrder");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrderItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @SerializedName( "BusinessSolutionOrderItem" )
    @JsonProperty( "BusinessSolutionOrderItem" )
    @Nullable
    @ODataField( odataName = "BusinessSolutionOrderItem" )
    private String businessSolutionOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>BusinessSolutionOrderItem</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmFUPSalesOrderField<String> BUSINESS_SOLUTION_ORDER_ITEM =
        new BusSolnOrdItmFUPSalesOrderField<String>("BusinessSolutionOrderItem");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @return Object key
     */
    @SerializedName( "SalesOrder" )
    @JsonProperty( "SalesOrder" )
    @Nullable
    @ODataField( odataName = "SalesOrder" )
    private String salesOrder;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrder</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmFUPSalesOrderField<String> SALES_ORDER =
        new BusSolnOrdItmFUPSalesOrderField<String>("SalesOrder");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @return The salesOrderItem contained in this entity.
     */
    @SerializedName( "SalesOrderItem" )
    @JsonProperty( "SalesOrderItem" )
    @Nullable
    @ODataField( odataName = "SalesOrderItem" )
    private String salesOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderItem</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmFUPSalesOrderField<String> SALES_ORDER_ITEM =
        new BusSolnOrdItmFUPSalesOrderField<String>("SalesOrderItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocSuccessorBusObjType</b>
     * </p>
     *
     * @return Object Type
     */
    @SerializedName( "ServiceDocSuccessorBusObjType" )
    @JsonProperty( "ServiceDocSuccessorBusObjType" )
    @Nullable
    @ODataField( odataName = "ServiceDocSuccessorBusObjType" )
    private String serviceDocSuccessorBusObjType;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocSuccessorBusObjType</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmFUPSalesOrderField<String> SERVICE_DOC_SUCCESSOR_BUS_OBJ_TYPE =
        new BusSolnOrdItmFUPSalesOrderField<String>("ServiceDocSuccessorBusObjType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceObjectType</b>
     * </p>
     *
     * @return Business Trans. Cat.
     */
    @SerializedName( "ServiceObjectType" )
    @JsonProperty( "ServiceObjectType" )
    @Nullable
    @ODataField( odataName = "ServiceObjectType" )
    private String serviceObjectType;
    /**
     * Use with available fluent helpers to apply the <b>ServiceObjectType</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmFUPSalesOrderField<String> SERVICE_OBJECT_TYPE =
        new BusSolnOrdItmFUPSalesOrderField<String>("ServiceObjectType");

    @Nonnull
    @Override
    public Class<BusSolnOrdItmFUPSalesOrder> getType()
    {
        return BusSolnOrdItmFUPSalesOrder.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItmRelationUUID</b>
     * </p>
     *
     * @param serviceDocumentItmRelationUUID
     *            Object Relationship Service : GUID binary link
     */
    public void setServiceDocumentItmRelationUUID( @Nullable final UUID serviceDocumentItmRelationUUID )
    {
        rememberChangedField("ServiceDocumentItmRelationUUID", this.serviceDocumentItmRelationUUID);
        this.serviceDocumentItmRelationUUID = serviceDocumentItmRelationUUID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocItmRltnSqncNumber</b>
     * </p>
     *
     * @param serviceDocItmRltnSqncNumber
     *            Sequential Number of Segment in IDoc Type
     */
    public void setServiceDocItmRltnSqncNumber( @Nullable final String serviceDocItmRltnSqncNumber )
    {
        rememberChangedField("ServiceDocItmRltnSqncNumber", this.serviceDocItmRltnSqncNumber);
        this.serviceDocItmRltnSqncNumber = serviceDocItmRltnSqncNumber;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrderUUID</b>
     * </p>
     *
     * @param businessSolutionOrderUUID
     *            32 Character CRM Object GUID
     */
    public void setBusinessSolutionOrderUUID( @Nullable final UUID businessSolutionOrderUUID )
    {
        rememberChangedField("BusinessSolutionOrderUUID", this.businessSolutionOrderUUID);
        this.businessSolutionOrderUUID = businessSolutionOrderUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrder</b>
     * </p>
     *
     * @param businessSolutionOrder
     *            Transaction ID
     */
    public void setBusinessSolutionOrder( @Nullable final String businessSolutionOrder )
    {
        rememberChangedField("BusinessSolutionOrder", this.businessSolutionOrder);
        this.businessSolutionOrder = businessSolutionOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrderItem</b>
     * </p>
     *
     * @param businessSolutionOrderItem
     *            Shortened Item Number in Document
     */
    public void setBusinessSolutionOrderItem( @Nullable final String businessSolutionOrderItem )
    {
        rememberChangedField("BusinessSolutionOrderItem", this.businessSolutionOrderItem);
        this.businessSolutionOrderItem = businessSolutionOrderItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @param salesOrder
     *            Object key
     */
    public void setSalesOrder( @Nullable final String salesOrder )
    {
        rememberChangedField("SalesOrder", this.salesOrder);
        this.salesOrder = salesOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @param salesOrderItem
     *            The salesOrderItem to set.
     */
    public void setSalesOrderItem( @Nullable final String salesOrderItem )
    {
        rememberChangedField("SalesOrderItem", this.salesOrderItem);
        this.salesOrderItem = salesOrderItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocSuccessorBusObjType</b>
     * </p>
     *
     * @param serviceDocSuccessorBusObjType
     *            Object Type
     */
    public void setServiceDocSuccessorBusObjType( @Nullable final String serviceDocSuccessorBusObjType )
    {
        rememberChangedField("ServiceDocSuccessorBusObjType", this.serviceDocSuccessorBusObjType);
        this.serviceDocSuccessorBusObjType = serviceDocSuccessorBusObjType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceObjectType</b>
     * </p>
     *
     * @param serviceObjectType
     *            Business Trans. Cat.
     */
    public void setServiceObjectType( @Nullable final String serviceObjectType )
    {
        rememberChangedField("ServiceObjectType", this.serviceObjectType);
        this.serviceObjectType = serviceObjectType;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BusSolnOrdItmFUPSalesOrder";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ServiceDocumentItmRelationUUID", getServiceDocumentItmRelationUUID());
        result.put("ServiceDocItmRltnSqncNumber", getServiceDocItmRltnSqncNumber());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ServiceDocumentItmRelationUUID", getServiceDocumentItmRelationUUID());
        values.put("ServiceDocItmRltnSqncNumber", getServiceDocItmRltnSqncNumber());
        values.put("BusinessSolutionOrderUUID", getBusinessSolutionOrderUUID());
        values.put("BusinessSolutionOrder", getBusinessSolutionOrder());
        values.put("BusinessSolutionOrderItem", getBusinessSolutionOrderItem());
        values.put("SalesOrder", getSalesOrder());
        values.put("SalesOrderItem", getSalesOrderItem());
        values.put("ServiceDocSuccessorBusObjType", getServiceDocSuccessorBusObjType());
        values.put("ServiceObjectType", getServiceObjectType());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ServiceDocumentItmRelationUUID") ) {
                final Object value = values.remove("ServiceDocumentItmRelationUUID");
                if( (value == null) || (!value.equals(getServiceDocumentItmRelationUUID())) ) {
                    setServiceDocumentItmRelationUUID(((UUID) value));
                }
            }
            if( values.containsKey("ServiceDocItmRltnSqncNumber") ) {
                final Object value = values.remove("ServiceDocItmRltnSqncNumber");
                if( (value == null) || (!value.equals(getServiceDocItmRltnSqncNumber())) ) {
                    setServiceDocItmRltnSqncNumber(((String) value));
                }
            }
            if( values.containsKey("BusinessSolutionOrderUUID") ) {
                final Object value = values.remove("BusinessSolutionOrderUUID");
                if( (value == null) || (!value.equals(getBusinessSolutionOrderUUID())) ) {
                    setBusinessSolutionOrderUUID(((UUID) value));
                }
            }
            if( values.containsKey("BusinessSolutionOrder") ) {
                final Object value = values.remove("BusinessSolutionOrder");
                if( (value == null) || (!value.equals(getBusinessSolutionOrder())) ) {
                    setBusinessSolutionOrder(((String) value));
                }
            }
            if( values.containsKey("BusinessSolutionOrderItem") ) {
                final Object value = values.remove("BusinessSolutionOrderItem");
                if( (value == null) || (!value.equals(getBusinessSolutionOrderItem())) ) {
                    setBusinessSolutionOrderItem(((String) value));
                }
            }
            if( values.containsKey("SalesOrder") ) {
                final Object value = values.remove("SalesOrder");
                if( (value == null) || (!value.equals(getSalesOrder())) ) {
                    setSalesOrder(((String) value));
                }
            }
            if( values.containsKey("SalesOrderItem") ) {
                final Object value = values.remove("SalesOrderItem");
                if( (value == null) || (!value.equals(getSalesOrderItem())) ) {
                    setSalesOrderItem(((String) value));
                }
            }
            if( values.containsKey("ServiceDocSuccessorBusObjType") ) {
                final Object value = values.remove("ServiceDocSuccessorBusObjType");
                if( (value == null) || (!value.equals(getServiceDocSuccessorBusObjType())) ) {
                    setServiceDocSuccessorBusObjType(((String) value));
                }
            }
            if( values.containsKey("ServiceObjectType") ) {
                final Object value = values.remove("ServiceObjectType");
                if( (value == null) || (!value.equals(getServiceObjectType())) ) {
                    setServiceObjectType(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> BusSolnOrdItmFUPSalesOrderField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new BusSolnOrdItmFUPSalesOrderField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BusSolnOrdItmFUPSalesOrderField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BusSolnOrdItmFUPSalesOrderField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSolutionOrderService.DEFAULT_SERVICE_PATH);
    }

}
